/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model.parts;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import thut.api.maths.vecmath.Vec3f;
import thut.core.client.render.model.parts.RenderTypeProvider;

public class Material {
    public static final RenderStateShard.TransparencyStateShard DEFAULTTRANSP = new RenderStateShard.TransparencyStateShard("material_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
    }, () -> RenderSystem.m_69461_());
    static final RenderType WATER_MASK = RenderType.m_173209_((String)"water_mask_", (VertexFormat)DefaultVertexFormat.f_85814_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173076_).m_173290_(RenderStateShard.f_110147_).m_110687_(RenderStateShard.f_110116_).m_110691_(false));
    public static final Map<String, RenderStateShard.ShaderStateShard> SHADERS = Maps.newHashMap();
    public static final RenderStateShard.DepthTestStateShard LESSTHAN;
    public final String name;
    final String render_name;
    public String texture;
    public Vec3f diffuseColor;
    public Vec3f specularColor;
    public Vec3f emissiveColor;
    public ResourceLocation tex;
    public float emissiveMagnitude;
    public float ambientIntensity;
    public float shininess;
    public float alpha = 1.0f;
    public boolean transluscent = false;
    public boolean cull = true;
    public boolean flat = true;
    public int[] rgbabro = new int[6];
    public String shader = "";
    public RenderTypeProvider renderType = RenderTypeProvider.NORMAL;
    static MultiBufferSource.BufferSource lastImpl;
    final Map<ResourceLocation, RenderType> types = new Object2ObjectOpenHashMap();

    public Material(String name) {
        this.name = name;
        this.render_name = "thutcore:mat_" + name + "_";
    }

    public Material(String name, String texture, Vec3f diffuse, Vec3f specular, Vec3f emissive, float ambient, float shiny) {
        this(name);
        this.texture = texture;
        this.diffuseColor = diffuse;
        this.specularColor = specular;
        this.emissiveColor = emissive;
        this.emissiveMagnitude = Math.min(emissive.x / 0.8f, 1.0f);
        this.ambientIntensity = ambient;
        this.shininess = shiny;
    }

    public void makeVertexBuilder(ResourceLocation texture, MultiBufferSource buffer) {
        this.makeVertexBuilder(texture, buffer, VertexFormat.Mode.TRIANGLES);
    }

    public void makeVertexBuilder(ResourceLocation texture, MultiBufferSource buffer, VertexFormat.Mode mode) {
        this.makeRenderType(texture, mode);
        if (buffer instanceof MultiBufferSource.BufferSource) {
            lastImpl = (MultiBufferSource.BufferSource)buffer;
        }
    }

    private RenderType makeRenderType(ResourceLocation tex, VertexFormat.Mode mode) {
        RenderType type = this.renderType.makeRenderType(this, tex, mode);
        return type;
    }

    public VertexConsumer preRender(PoseStack mat, VertexConsumer buffer) {
        return this.preRender(mat, buffer, VertexFormat.Mode.TRIANGLES);
    }

    public VertexConsumer preRender(PoseStack mat, VertexConsumer buffer, VertexFormat.Mode mode) {
        if (lastImpl == null) {
            lastImpl = Minecraft.m_91087_().m_91269_().m_110104_();
        }
        if (this.tex == null || lastImpl == null) {
            return buffer;
        }
        RenderType type = this.makeRenderType(this.tex, mode);
        VertexConsumer newBuffer = lastImpl.m_6299_(type);
        return newBuffer;
    }

    static {
        SHADERS.put("alpha_shader", RenderStateShard.f_173072_);
        SHADERS.put("eyes_shader", RenderStateShard.f_173073_);
        SHADERS.put("swirl_shader", RenderStateShard.f_173074_);
        LESSTHAN = new RenderStateShard.DepthTestStateShard("<", 513);
        lastImpl = null;
    }
}

