/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model.parts;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.client.Minecraft;
import thut.api.maths.vecmath.Vec3f;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.TextureCoordinate;
import thut.core.common.ThutCore;

public abstract class Mesh {
    public static boolean debug = false;
    protected final boolean hasTextures;
    public Vertex[] vertices;
    public Vertex[] normals;
    public TextureCoordinate[] textureCoordinates;
    public Integer[] order;
    Material material;
    public String name;
    public boolean overrideColour = false;
    private final double[] uvShift = new double[]{0.0, 0.0};
    final int GL_FORMAT;
    final Vertex[] normalList;
    Vector4f centre = new Vector4f();
    public int[] rgbabro = new int[6];
    private boolean same_mat = false;
    public final VertexFormat.Mode vertexMode;
    Vertex min = new Vertex(0.0f, 0.0f);
    Vertex max = new Vertex(0.0f, 0.0f);
    final int iter;
    static double sum;
    static long n;
    public static Vector4f METRIC;
    private final Vector3f dummy3 = new Vector3f();
    private final Vector3f dummy_1 = new Vector3f();
    private final Vector4f dummy4 = new Vector4f();
    private final TextureCoordinate dummyTex = new TextureCoordinate(0.0f, 0.0f);

    public Mesh(Integer[] order, Vertex[] vert, Vertex[] norm, TextureCoordinate[] tex, int GL_FORMAT) {
        this.order = order;
        this.vertices = vert;
        this.normals = norm;
        this.textureCoordinates = tex;
        this.hasTextures = tex != null;
        this.GL_FORMAT = GL_FORMAT;
        this.normalList = new Vertex[this.order.length];
        this.iter = GL_FORMAT == 4 ? 3 : 4;
        this.vertexMode = GL_FORMAT == 4 ? VertexFormat.Mode.TRIANGLES : VertexFormat.Mode.QUADS;
        Vec3f mins = new Vec3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Vec3f maxs = new Vec3f(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        for (int i = 0; i < this.order.length; i += this.iter) {
            Vertex vertex = this.vertices[this.order[i]];
            Vec3f v1 = new Vec3f(vertex.x, vertex.y, vertex.z);
            vertex = this.vertices[this.order[i + 1]];
            Vec3f v2 = new Vec3f(vertex.x, vertex.y, vertex.z);
            vertex = this.vertices[this.order[i + 2]];
            Vec3f v3 = new Vec3f(vertex.x, vertex.y, vertex.z);
            if (v1.x < mins.x) {
                mins.x = v1.x;
            }
            if (v1.y < mins.y) {
                mins.y = v1.y;
            }
            if (v1.z < mins.z) {
                mins.z = v1.z;
            }
            if (v2.x < mins.x) {
                mins.x = v2.x;
            }
            if (v2.y < mins.y) {
                mins.y = v2.y;
            }
            if (v2.z < mins.z) {
                mins.z = v2.z;
            }
            if (v3.x < mins.x) {
                mins.x = v3.x;
            }
            if (v3.y < mins.y) {
                mins.y = v3.y;
            }
            if (v3.z < mins.z) {
                mins.z = v3.z;
            }
            if (v1.x > maxs.x) {
                maxs.x = v1.x;
            }
            if (v1.y > maxs.y) {
                maxs.y = v1.y;
            }
            if (v1.z > maxs.z) {
                maxs.z = v1.z;
            }
            if (v2.x > maxs.x) {
                maxs.x = v2.x;
            }
            if (v2.y > maxs.y) {
                maxs.y = v2.y;
            }
            if (v2.z > maxs.z) {
                maxs.z = v2.z;
            }
            if (v3.x > maxs.x) {
                maxs.x = v3.x;
            }
            if (v3.y > maxs.y) {
                maxs.y = v3.y;
            }
            if (v3.z > maxs.z) {
                maxs.z = v3.z;
            }
            this.centre.m_176875_(v1.x, v1.y, v1.z, 0.0f);
            this.centre.m_176875_(v2.x, v2.y, v2.z, 0.0f);
            this.centre.m_176875_(v3.x, v3.y, v3.z, 0.0f);
            if (this.iter == 4) {
                vertex = this.vertices[this.order[i + 3]];
                Vec3f v4 = new Vec3f(vertex.x, vertex.y, vertex.z);
                this.centre.m_176875_(v4.x, v4.y, v4.z, 0.0f);
                if (v4.x < mins.x) {
                    mins.x = v4.x;
                }
                if (v4.y < mins.y) {
                    mins.y = v4.y;
                }
                if (v4.z < mins.z) {
                    mins.z = v4.z;
                }
                if (v4.x > maxs.x) {
                    maxs.x = v4.x;
                }
                if (v4.y > maxs.y) {
                    maxs.y = v4.y;
                }
                if (v4.z > maxs.z) {
                    maxs.z = v4.z;
                }
            }
            Vec3f a = new Vec3f(v2);
            a.sub(v1);
            Vec3f b = new Vec3f(v3);
            b.sub(v1);
            Vec3f c = new Vec3f();
            c.cross(a, b);
            c.normalize();
            Vertex normal = new Vertex(c.x, c.y, c.z);
            if (Double.isNaN(normal.x)) {
                normal.x = 0.0f;
                normal.y = 0.0f;
                normal.z = 1.0f;
            }
            this.normalList[i] = normal;
            this.normalList[i + 1] = normal;
            this.normalList[i + 2] = normal;
            if (this.iter != 4) continue;
            this.normalList[i + 3] = normal;
        }
        if (this.normals == null) {
            this.normals = this.normalList;
        }
        this.centre.m_176870_(1.0f / (float)order.length);
        this.min.set(mins);
        this.max.set(maxs);
        this.material = new Material("auto:" + this.name);
    }

    public void scale(float scale) {
        for (Vertex v : this.vertices) {
            v.scale(scale);
        }
    }

    protected void doRender(PoseStack mat, VertexConsumer buffer, IPartTexturer texturer) {
        TextureCoordinate textureCoordinate = this.dummyTex;
        boolean flat = this.material.flat;
        float red = (float)this.material.rgbabro[0] / 255.0f;
        float green = (float)this.material.rgbabro[1] / 255.0f;
        float blue = (float)this.material.rgbabro[2] / 255.0f;
        float alpha = this.material.alpha * (float)this.material.rgbabro[3] / 255.0f;
        int lightmapUV = this.material.rgbabro[4];
        int overlayUV = this.material.rgbabro[5];
        if (debug || this.overrideColour) {
            red = (float)this.rgbabro[0] / 255.0f;
            green = (float)this.rgbabro[1] / 255.0f;
            blue = (float)this.rgbabro[2] / 255.0f;
            alpha = this.material.alpha * (float)this.rgbabro[3] / 255.0f;
            lightmapUV = this.rgbabro[4];
            overlayUV = this.rgbabro[5];
        }
        PoseStack.Pose matrixstack$entry = mat.m_85850_();
        Matrix4f pos = matrixstack$entry.m_85861_();
        Matrix3f norms = matrixstack$entry.m_85864_();
        Vector4f dp = this.dummy4;
        Vector3f dn = this.dummy3;
        if (ThutCore.getConfig().modelCullThreshold > 0.0) {
            boolean size_cull;
            float a = (float)(Minecraft.m_91087_().m_91268_().m_85444_() * Minecraft.m_91087_().m_91268_().m_85443_()) * 0.001f;
            a = (float)Math.sqrt(a);
            this.dummy_1.m_122245_(this.max.x - this.min.x, this.max.y - this.min.y, this.max.z - this.min.z);
            float len = (float)Math.sqrt(this.dummy_1.m_122276_(this.dummy_1));
            dp.m_123602_(len, len, len, 0.0f);
            dp.m_123607_(pos);
            dp.m_176870_(a);
            double dr2_us = dp.m_123613_(dp);
            dp.m_123602_(0.0f, 0.0f, 0.0f, 1.0f);
            dp.m_123607_(pos);
            double dr2_2 = dp.m_123613_(dp);
            boolean bl = size_cull = dr2_us / dr2_2 < ThutCore.getConfig().modelCullThreshold;
            if (size_cull) {
                return;
            }
        }
        for (int i0 = 0; i0 < this.order.length; ++i0) {
            Integer i = this.order[i0];
            Vertex normal = flat ? this.normalList[i0] : this.normals[i];
            float nx = normal.x;
            float ny = normal.y;
            float nz = normal.z;
            dn.m_122245_(nx, ny, nz);
            dn.m_122249_(norms);
            if (this.hasTextures) {
                textureCoordinate = this.textureCoordinates[i];
            }
            Vertex vertex = this.vertices[i];
            float x = vertex.x;
            float y = vertex.y;
            float z = vertex.z;
            dp.m_123602_(x, y, z, 1.0f);
            dp.m_123607_(pos);
            float u = textureCoordinate.u + (float)this.uvShift[0];
            float v = textureCoordinate.v + (float)this.uvShift[1];
            buffer.m_5954_(dp.m_123601_(), dp.m_123615_(), dp.m_123616_(), red, green, blue, alpha, u, v, overlayUV, lightmapUV, dn.m_122239_(), dn.m_122260_(), dn.m_122269_());
        }
    }

    public void renderShape(PoseStack mat, VertexConsumer buffer, IPartTexturer texturer) {
        if (texturer != null) {
            texturer.shiftUVs(this.material.name, this.uvShift);
            if (texturer.isHidden(this.material.name)) {
                return;
            }
            if (!this.same_mat && texturer.isHidden(this.name)) {
                return;
            }
            texturer.modifiyRGBA(this.material.name, this.material.rgbabro);
            if (!this.same_mat) {
                texturer.modifiyRGBA(this.name, this.material.rgbabro);
            }
        }
        buffer = this.material.preRender(mat, buffer, this.vertexMode);
        if (this.material.emissiveMagnitude > 0.0f) {
            int j = (int)(this.material.emissiveMagnitude * 15.0f);
            this.material.rgbabro[4] = j << 20 | j << 4;
        }
        this.doRender(mat, buffer, texturer);
    }

    public void setMaterial(Material material) {
        this.material = material;
        this.name = material.name;
        this.same_mat = true;
    }

    static {
        METRIC = new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);
    }
}

