/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model.parts;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import thut.api.entity.IAnimated;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.api.util.JsonUtil;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.model.parts.Mesh;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.IRetexturableModel;
import thut.core.common.ThutCore;

public abstract class Part
implements IExtendedModelPart,
IRetexturableModel {
    private final Map<String, IExtendedModelPart> parts = new Object2ObjectOpenHashMap();
    private final List<String> order = Lists.newArrayList();
    private final List<Mesh> shapes = Lists.newArrayList();
    private final String name;
    private IExtendedModelPart parent = null;
    IPartTexturer texturer;
    IAnimationChanger changer;
    IAnimated.IAnimationHolder currentHolder = null;
    public Vector4 preRot = new Vector4();
    public Vector4 postRot = new Vector4();
    public Vector3 preTrans = new Vector3();
    public Vector3 postTrans = new Vector3();
    public Vertex preScale = new Vertex(1.0f, 1.0f, 1.0f);
    public Vector3 offset = new Vector3();
    public Vector4 rotations = new Vector4();
    public Vertex scale = new Vertex(1.0f, 1.0f, 1.0f);
    Vector3 min = new Vector3();
    Vector3 max = new Vector3();
    public int brightness = 0xF00000;
    public int overlay = 655360;
    private boolean hidden = false;
    private boolean disabled = false;
    private final List<Material> materials = Lists.newArrayList();
    private final Map<String, Material> namedMaterials = new Object2ObjectOpenHashMap();
    private final Set<Material> matcache = Sets.newHashSet();
    private Set<String> parentNames = Sets.newHashSet();
    private Set<String> childNames = Sets.newHashSet();

    public Part(String name) {
        this.name = name;
    }

    private void initBounds() {
        if (!this.max.isEmpty() || !this.min.isEmpty()) {
            return;
        }
        for (Mesh shape : this.shapes) {
            for (Vertex v : shape.vertices) {
                this.min.x = Math.min(this.min.x, (double)v.x);
                this.min.y = Math.min(this.min.y, (double)v.y);
                this.min.z = Math.min(this.min.z, (double)v.z);
                this.max.x = Math.max(this.max.x, (double)v.x);
                this.max.y = Math.max(this.max.y, (double)v.y);
                this.max.z = Math.max(this.max.z, (double)v.z);
            }
        }
    }

    @Override
    public Vector3 minBound() {
        this.initBounds();
        return this.min;
    }

    @Override
    public Vector3 maxBound() {
        this.initBounds();
        return this.max;
    }

    @Override
    public void preProcess() {
        this.sort(this.order);
        IExtendedModelPart.super.preProcess();
    }

    public void addShape(Mesh shape) {
        this.shapes.add(shape);
        if (shape.material == null) {
            return;
        }
        if (this.matcache.add(shape.material)) {
            this.materials.add(shape.material);
            this.namedMaterials.put(shape.material.name, shape.material);
        }
    }

    public void setShapes(List<Mesh> shapes) {
        this.shapes.clear();
        this.shapes.addAll(shapes);
        for (Mesh shape : shapes) {
            if (shape.material == null || !this.matcache.add(shape.material)) continue;
            this.materials.add(shape.material);
            this.namedMaterials.put(shape.material.name, shape.material);
        }
    }

    @Override
    public void applyTexture(MultiBufferSource bufferIn, ResourceLocation tex, IPartTexturer texer) {
        for (Mesh shape : this.shapes) {
            ResourceLocation tex_1 = tex;
            if (texer.hasMapping(shape.material.name)) {
                tex_1 = texer.getTexture(shape.material.name, tex_1);
            }
            shape.material.makeVertexBuilder(tex_1, bufferIn, shape.vertexMode);
        }
    }

    @Override
    public void addChild(IExtendedModelPart subPart) {
        this.parts.put(subPart.getName(), subPart);
        subPart.setParent(this);
    }

    @Override
    public Set<String> getParentNames() {
        return this.parentNames;
    }

    @Override
    public Set<String> getRecursiveChildNames() {
        return this.childNames;
    }

    @Override
    public List<Material> getMaterials() {
        return this.materials;
    }

    @Override
    public Vector4 getDefaultRotations() {
        return this.rotations;
    }

    @Override
    public Vector3 getDefaultTranslations() {
        return this.offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IExtendedModelPart getParent() {
        return this.parent;
    }

    public Map<String, IExtendedModelPart> getSubParts() {
        return this.parts;
    }

    @Override
    public void postRender(PoseStack mat) {
        mat.m_85849_();
        if (this.parent != null) {
            this.parent.postRender(mat);
        }
    }

    @Override
    public void preRender(PoseStack mat) {
        if (this.parent != null) {
            this.parent.preRender(mat);
        }
        mat.m_85836_();
        mat.m_85841_(this.preScale.x, this.preScale.y, this.preScale.z);
        mat.m_85837_(this.preTrans.x, this.preTrans.y, this.preTrans.z);
        this.preRot.glRotate(mat);
        mat.m_85837_(this.postTrans.x, this.postTrans.y, this.postTrans.z);
        this.postRot.glRotate(mat);
        mat.m_85841_(this.scale.x, this.scale.y, this.scale.z);
    }

    @Override
    public void render(PoseStack mat, VertexConsumer buffer) {
        if (this.isDisabled()) {
            return;
        }
        this.preRender(mat);
        for (Mesh s : this.shapes) {
            s.renderShape(mat, buffer, this.texturer);
        }
        this.postRender(mat);
    }

    @Override
    public void renderAll(PoseStack mat, VertexConsumer buffer) {
        this.renderAllExcept(mat, buffer, Collections.emptySet());
    }

    @Override
    public void renderAllExcept(PoseStack mat, VertexConsumer buffer, Collection<String> excludedGroupNames) {
        boolean skip = this.hidden;
        if (skip || excludedGroupNames.contains(this.name)) {
            return;
        }
        if (!skip) {
            for (String s : this.order) {
                IExtendedModelPart o = this.parts.get(s);
                o.renderAllExcept(mat, buffer, excludedGroupNames);
            }
            this.render(mat, buffer);
        }
    }

    @Override
    public void renderOnly(PoseStack mat, VertexConsumer buffer, Collection<String> groupNames) {
        if (groupNames.contains(this.name)) {
            this.render(mat, buffer);
            return;
        }
        for (String s : this.order) {
            IExtendedModelPart o = this.parts.get(s);
            o.renderOnly(mat, buffer, groupNames);
        }
    }

    @Override
    public void renderPart(PoseStack mat, VertexConsumer buffer, String partName) {
        if (partName.equalsIgnoreCase(this.name)) {
            this.render(mat, buffer);
            return;
        }
        for (String s : this.order) {
            IExtendedModelPart o = this.parts.get(s);
            if (!s.equalsIgnoreCase(partName)) continue;
            o.render(mat, buffer);
        }
    }

    @Override
    public void resetToInit() {
        this.preRot.set(this.rotations.x, this.rotations.y, this.rotations.z, this.rotations.w);
        this.postRot.set(0.0f, 0.0f, 0.0f, 1.0f);
        this.preTrans.set(this.offset);
        this.postTrans.clear();
        this.hidden = false;
    }

    @Override
    public void setAnimationChanger(IAnimationChanger changer) {
        this.changer = changer;
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            IRetexturableModel tex = (IRetexturableModel)((Object)part);
            tex.setAnimationChanger(changer);
        }
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        for (IExtendedModelPart part : this.parts.values()) {
            part.setHidden(hidden);
        }
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setParent(IExtendedModelPart parent) {
        this.parent = parent;
    }

    @Override
    public void setPostRotations(Vector4 angles) {
        this.postRot = angles;
    }

    @Override
    public void setPostTranslations(Vector3 point) {
        this.postTrans.set(point);
    }

    @Override
    public void setPreRotations(Vector4 angles) {
        this.preRot.mul(this.rotations, angles);
    }

    @Override
    public void setPreScale(Vector3 scale) {
        this.preScale.x = (float)scale.x;
        this.preScale.y = (float)scale.y;
        this.preScale.z = (float)scale.z;
    }

    @Override
    public void setPreTranslations(Vector3 point) {
        this.preTrans.set(this.offset).addTo(point);
    }

    @Override
    public void setRGBABrO(@Nullable Predicate<Material> material, int r, int g, int b, int a, int br, int o) {
        if (br != Integer.MIN_VALUE) {
            this.brightness = br;
            this.overlay = o;
        }
        if (material != null && !Mesh.debug) {
            this.materials.forEach(m -> {
                if (m == null) {
                    return;
                }
                if (material.test((Material)m)) {
                    m.rgbabro[0] = r;
                    m.rgbabro[1] = g;
                    m.rgbabro[2] = b;
                    m.rgbabro[3] = a;
                    m.rgbabro[4] = this.brightness;
                    m.rgbabro[5] = this.overlay;
                }
            });
        } else {
            this.shapes.forEach(m -> {
                if (m == null) {
                    return;
                }
                m.rgbabro[0] = r;
                m.rgbabro[1] = g;
                m.rgbabro[2] = b;
                m.rgbabro[3] = a;
                m.rgbabro[4] = this.brightness;
                m.rgbabro[5] = this.overlay;
            });
        }
    }

    @Override
    public void setTexturer(IPartTexturer texturer) {
        this.texturer = texturer;
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            IRetexturableModel tex = (IRetexturableModel)((Object)part);
            tex.setTexturer(texturer);
        }
    }

    @Override
    public void updateMaterial(AnimationXML.Mat mat, Material material) {
        String[] parts = mat.name.split(":");
        if (mat.meshs == null) {
            mat.meshs = "";
        }
        for (String s : parts) {
            for (Mesh mesh : this.shapes) {
                if (mesh.name == null) {
                    mesh.name = this.getName();
                }
                if (!mesh.name.equals(ThutCore.trim(s)) && !mesh.name.equals(mat.name) && !mat.meshs.contains(mesh.name)) continue;
                mesh.setMaterial(material);
            }
        }
        for (Material m : this.materials) {
            if (!m.name.equals(mat.name)) continue;
            this.matcache.remove(m);
            this.materials.remove(m);
            this.namedMaterials.remove(m.name);
            break;
        }
        if (material == null) {
            ThutCore.LOGGER.error("Error loading a material, trying to set it to null: {}", (Object)JsonUtil.gson.toJson((Object)mat));
            ThutCore.LOGGER.error((Object)new IllegalAccessException());
        }
        this.matcache.add(material);
        this.materials.add(material);
        this.namedMaterials.put(material.name, material);
    }

    @Override
    public IAnimated.IAnimationHolder getAnimationHolder() {
        return this.currentHolder;
    }

    @Override
    public void setAnimationHolder(IAnimated.IAnimationHolder holder) {
        this.currentHolder = holder;
    }

    @Override
    public List<String> getRenderOrder() {
        return this.order;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }
}

