/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import thut.api.maths.Vector3;
import thut.api.maths.vecmath.Vec3f;
import thut.api.particle.ParticleBase;
import thut.api.particle.ParticleNoGravity;
import thut.api.particle.ThutParticles;

@OnlyIn(value=Dist.CLIENT)
public class ParticleFactories {
    public static final RenderType TYPE = new RenderType();
    public static final ParticleProvider<ParticleBase> GENERICFACTORY = (type, world, x, y, z, vx, vy, vz) -> {
        type = ThutParticles.clone(type);
        type.setVelocity(new Vector3().set(vx, vy, vz));
        type.setPosition(new Vector3().set(x, y, z));
        return new ThutParticle((Level)world, (ParticleBase)type);
    };

    public static class ThutParticle
    extends Particle {
        final ParticleBase particle;
        final Level world;

        protected ThutParticle(Level worldIn, ParticleBase particleIn) {
            super((ClientLevel)worldIn, particleIn.position.x, particleIn.position.y, particleIn.position.z);
            this.particle = particleIn;
            this.world = worldIn;
            if (this.particle instanceof ParticleNoGravity) {
                this.f_107226_ = 0.0f;
            }
            this.f_107215_ = this.particle.velocity.x;
            this.f_107216_ = this.particle.velocity.z;
            this.f_107217_ = this.particle.velocity.y;
            this.m_107257_(this.particle.lifetime);
        }

        public int m_107273_() {
            return this.particle.lifetime;
        }

        public ParticleRenderType m_7556_() {
            return TYPE;
        }

        public boolean m_107276_() {
            return this.particle.getDuration() >= 0;
        }

        public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
            Vec3 vec3d = renderInfo.m_90583_();
            float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
            float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
            float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
            Vec3f source = new Vec3f(x, y, z);
            if (this.f_107231_ == 0.0f) {
                Quaternion quaternion = renderInfo.m_90591_();
            } else {
                Quaternion quaternion = new Quaternion(renderInfo.m_90591_());
                float f3 = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
                quaternion.m_80148_(Vector3f.f_122227_.m_122270_(f3));
            }
            this.particle.renderParticle(buffer, renderInfo, partialTicks, source);
        }

        public void m_5989_() {
            this.f_107224_ = 0;
            super.m_5989_();
            this.particle.setDuration(this.particle.getDuration() - 1);
            this.particle.setLastTick(this.world.m_46467_());
            if (this.particle.getDuration() < 0) {
                this.particle.kill();
                this.m_107274_();
            }
        }
    }

    public static class RenderType
    implements ParticleRenderType {
        public void m_6505_(BufferBuilder builder, TextureManager textures) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)ParticleBase.TEXTUREMAP);
            RenderSystem.m_157427_(GameRenderer::m_172835_);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        }

        public void m_6294_(Tesselator tes) {
            tes.m_85914_();
        }
    }
}

