/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.texturing;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import thut.api.ThutCaps;
import thut.api.entity.IMobTexturable;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.states.Colour;
import thut.core.client.render.texturing.states.RandomFixed;
import thut.core.client.render.texturing.states.RandomState;
import thut.core.client.render.texturing.states.Sequence;
import thut.core.common.ThutCore;
import thut.lib.RegHelper;

public class TextureHelper
implements IPartTexturer {
    protected IMobTexturable mob;
    Map<String, String> texNames = new Object2ObjectOpenHashMap();
    Map<String, Map<String, String>> texNames2 = new Object2ObjectOpenHashMap();
    public ResourceLocation default_tex;
    String default_path;
    boolean default_flat = true;
    Map<String, ResourceLocation> texMap = new Object2ObjectOpenHashMap();
    Map<String, TexState> texStates = new Object2ObjectOpenHashMap();
    Map<String, Set<RandomFixed>> fixedOffsets = new Object2ObjectOpenHashMap();
    Map<String, Set<Colour>> colours = new Object2ObjectOpenHashMap();
    Map<String, String> formeMap = new Object2ObjectOpenHashMap();

    @Override
    public void reset() {
        this.texNames.clear();
        this.texNames2.clear();
        this.texStates.clear();
        this.formeMap.clear();
        this.texMap.clear();
        this.fixedOffsets.clear();
        this.colours.clear();
        this.default_flat = true;
        this.default_path = null;
        this.default_tex = null;
    }

    @Override
    public void init(AnimationXML.CustomTex customTex) {
        Set<Object> set;
        Object s;
        String name;
        if (customTex == null) {
            return;
        }
        if (customTex.defaults != null) {
            this.default_path = customTex.defaults;
        }
        if (customTex.smoothing != null) {
            boolean flat;
            this.default_flat = flat = !customTex.smoothing.equalsIgnoreCase("smooth");
        }
        this.clear();
        for (AnimationXML.TexAnim texAnim : customTex.anims) {
            name = ThutCore.trim(texAnim.part);
            String trigger = texAnim.trigger.trim();
            String[] diffs = texAnim.diffs.trim().split(",");
            TexState states = this.texStates.get(name);
            if (states == null) {
                states = new TexState();
                this.texStates.put(name, states);
            }
            states.addState(trigger, diffs);
        }
        for (AnimationXML.TexPart texPart : customTex.parts) {
            name = ThutCore.trim(texPart.name);
            String partTex = texPart.tex;
            this.addMapping(name, partTex);
        }
        for (AnimationXML.TexCustom texCustom : customTex.custom) {
            name = ThutCore.trim(texCustom.part);
            String state = ThutCore.trim(texCustom.state);
            String partTex = texCustom.tex;
            this.addCustomMapping(name, state, partTex);
        }
        for (AnimationXML.TexForm texForm : customTex.forme) {
            name = ThutCore.trim(texForm.name);
            String tex = texForm.tex;
            this.formeMap.put(name, tex);
        }
        for (AnimationXML.RNGFixed rNGFixed : customTex.rngfixeds) {
            s = new RandomFixed();
            ((RandomFixed)s).seedModifier = rNGFixed.seed;
            set = this.fixedOffsets.get(rNGFixed.material);
            if (set == null) {
                set = Sets.newHashSet();
                this.fixedOffsets.put(rNGFixed.material, (Set<RandomFixed>)set);
            }
            set.add((RandomFixed)s);
        }
        for (AnimationXML.ColourTex colourTex : customTex.colours) {
            s = new Colour();
            ((Colour)s).alpha = colourTex.alpha;
            ((Colour)s).red = colourTex.red;
            ((Colour)s).green = colourTex.green;
            ((Colour)s).blue = colourTex.blue;
            ((Colour)s).forme = colourTex.forme;
            set = this.colours.get(colourTex.material);
            if (set == null) {
                set = Sets.newHashSet();
                this.colours.put(colourTex.material, (Set<Colour>)set);
            }
            set.add(s);
        }
    }

    private void clear() {
        this.texMap.clear();
        this.texStates.clear();
        this.formeMap.clear();
        this.texNames.clear();
        this.texNames2.clear();
    }

    @Override
    public void modifiyRGBA(String part, int[] rgbaIn) {
        for (Colour state : this.colours.getOrDefault(part, Collections.emptySet())) {
            state.apply(rgbaIn, this.mob);
        }
    }

    @Override
    public void addCustomMapping(String part, String state, String tex) {
        Object2ObjectOpenHashMap partMap = this.texNames2.get(part);
        if (partMap == null) {
            partMap = new Object2ObjectOpenHashMap();
            this.texNames2.put(part, (Map<String, String>)partMap);
        }
        partMap.put(state, tex);
    }

    @Override
    public void addMapping(String part, String tex) {
        this.texNames.put(part, tex);
    }

    @Override
    public ResourceLocation getTexture(String part, ResourceLocation default_) {
        String texMod;
        String texName;
        if (this.mob == null) {
            return default_;
        }
        ResourceLocation tex = this.bindPerState(part);
        if (tex != null) {
            return tex;
        }
        String defaults = this.formeMap.getOrDefault(this.mob.getForm(), this.default_path);
        String string = texName = this.texNames.containsKey(part) ? this.texNames.get(part) : defaults;
        if (texName == null || texName.trim().isEmpty()) {
            this.texNames.put(part, defaults);
        }
        tex = this.getResource(texName);
        TexState state = this.texStates.get(part);
        if (state != null && (texMod = state.modifyTexture(this.mob)) != null) {
            tex = this.getResource(tex.m_135815_() + texMod);
        }
        tex = this.mob.preApply(tex);
        return tex;
    }

    @Override
    public void bindObject(Object thing) {
        this.mob = null;
        if (thing instanceof ICapabilityProvider) {
            ICapabilityProvider cap = (ICapabilityProvider)thing;
            this.mob = (IMobTexturable)cap.getCapability(ThutCaps.MOBTEX_CAP).orElse(null);
        }
        if (this.mob == null && thing instanceof Entity) {
            final Entity e = (Entity)thing;
            this.mob = new IMobTexturable(){
                Entity entity;
                String modid;
                Map<ResourceLocation, ResourceLocation> remapped;
                {
                    this.entity = e;
                    this.modid = RegHelper.getKey(this.entity.m_6095_()).m_135827_();
                    this.remapped = new Object2ObjectOpenHashMap();
                }

                @Override
                public Entity getEntity() {
                    return this.entity;
                }

                @Override
                public String getModId() {
                    return this.modid;
                }

                @Override
                public ResourceLocation preApply(ResourceLocation in) {
                    if (this.remapped.containsKey(in)) {
                        return this.remapped.get(in);
                    }
                    if (!in.m_135815_().contains(".png")) {
                        ResourceLocation updated = new ResourceLocation(in.m_135827_(), "entity/textures/" + in.m_135815_() + ".png");
                        this.remapped.put(in, updated);
                    }
                    return this.remapped.getOrDefault(in, IMobTexturable.super.preApply(in));
                }
            };
        }
        if (this.mob != null) {
            String form = this.mob.getForm();
            String defaults = this.formeMap.getOrDefault(form, this.default_path);
            this.default_tex = this.getResource(defaults);
            this.default_path = this.default_tex.m_135815_();
        }
    }

    private ResourceLocation bindPerState(String part) {
        Map<String, String> partNames = this.texNames2.get(part);
        if (partNames == null || this.mob == null) {
            return null;
        }
        List<String> states = this.mob.getTextureStates();
        for (String key : partNames.keySet()) {
            String texMod;
            if (!states.contains(key)) continue;
            String texKey = part + key;
            Object tex = this.texNames.get(texKey);
            if (tex == null) {
                tex = partNames.get(key);
                this.texNames.put(texKey, (String)tex);
            }
            TexState state = this.texStates.get(part);
            if (state != null && (texMod = state.modifyTexture(this.mob)) != null) {
                tex = (String)tex + texMod;
            }
            return this.getResource((String)tex);
        }
        return null;
    }

    private ResourceLocation getResource(String tex) {
        if (tex == null) {
            return this.mob.getTexture(null);
        }
        if (tex.contains(":")) {
            return new ResourceLocation(tex);
        }
        return new ResourceLocation(this.mob.getModId(), tex);
    }

    @Override
    public boolean hasMapping(String part) {
        return this.texNames.containsKey(part) || this.default_tex != null;
    }

    @Override
    public boolean shiftUVs(String part, double[] toFill) {
        toFill[1] = 0.0;
        toFill[0] = 0.0;
        if (this.mob == null) {
            return false;
        }
        Set offsets = this.fixedOffsets.getOrDefault(part, Collections.emptySet());
        for (RandomFixed state : offsets) {
            state.applyState(toFill, this.mob);
        }
        if (offsets.size() > 0) {
            return true;
        }
        TexState state = this.texStates.get(part);
        if (state != null) {
            return state.applyState(toFill, this.mob);
        }
        return false;
    }

    @Override
    public void applyTexturePhase(AnimationXML.Phase phase) {
        if (this.mob != null) {
            this.mob.applyTexturePhase(phase);
        }
    }

    private static class TexState {
        Map<String, double[]> infoStates = new Object2ObjectOpenHashMap();
        Set<RandomState> randomStates = Sets.newHashSet();
        Sequence sequence = null;
        Map<Integer, RandomState> running = new Object2ObjectOpenHashMap();
        Map<Integer, Integer> setTimes = new Object2ObjectOpenHashMap();

        private TexState() {
        }

        void addState(String trigger, String[] diffs) {
            double[] arr = new double[diffs.length];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = Double.parseDouble(diffs[i].trim());
            }
            if (trigger.contains("random")) {
                this.randomStates.add(new RandomState(trigger, arr));
            } else if (trigger.equals("sequence") || trigger.equals("time")) {
                this.sequence = new Sequence(arr);
            } else if (!this.parseState(trigger, arr)) {
                new NullPointerException("No Template found for " + trigger).printStackTrace();
            }
        }

        boolean applyState(double[] toFill, IMobTexturable mob) {
            double dx = 0.0;
            double dy = 0.0;
            toFill[0] = dx;
            toFill[1] = dy;
            List<String> states = mob.getTextureStates();
            for (String string : states) {
                if (!this.infoStates.containsKey(string)) continue;
                double[] arr = this.infoStates.get(string);
                dx = arr[0];
                dy = arr[1];
                toFill[0] = dx;
                toFill[1] = dy;
                return true;
            }
            if (this.running.containsKey(mob.getEntity().m_19879_())) {
                RandomState run = this.running.get(mob.getEntity().m_19879_());
                double[] dArray = run.arr;
                dx = dArray[0];
                dy = dArray[1];
                toFill[0] = dx;
                toFill[1] = dy;
                if (mob.getEntity().f_19797_ > this.setTimes.get(mob.getEntity().m_19879_()) + run.duration) {
                    this.running.remove(mob.getEntity().m_19879_());
                    this.setTimes.remove(mob.getEntity().m_19879_());
                }
                return true;
            }
            for (RandomState randomState : this.randomStates) {
                if (!randomState.apply(toFill, mob)) continue;
                this.running.put(mob.getEntity().m_19879_(), randomState);
                this.setTimes.put(mob.getEntity().m_19879_(), mob.getEntity().f_19797_);
                return true;
            }
            if (this.sequence != null && this.sequence.shift) {
                int tick = mob.getEntity().f_19797_ % (this.sequence.arr.length / 2);
                dx = this.sequence.arr[tick * 2];
                dy = this.sequence.arr[tick * 2 + 1];
                toFill[0] = dx;
                toFill[1] = dy;
                return true;
            }
            return false;
        }

        String modifyTexture(IMobTexturable mob) {
            if (this.sequence != null && !this.sequence.shift) {
                int tick = mob.getEntity().f_19797_ % (this.sequence.arr.length / 2);
                int dx = (int)this.sequence.arr[tick * 2];
                return "" + dx;
            }
            return null;
        }

        private boolean parseState(String trigger, double[] arr) {
            if (trigger == null) {
                return false;
            }
            trigger = ThutCore.trim(trigger);
            this.infoStates.put(trigger, arr);
            return true;
        }
    }
}

