/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.wrappers;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import thut.api.ModelHolder;
import thut.api.entity.IAnimated;
import thut.api.entity.IMobColourable;
import thut.api.entity.animation.Animation;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.AnimationHelper;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IModelCustom;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.model.ModelFactory;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.IRetexturableModel;
import thut.core.client.render.texturing.TextureHelper;
import thut.core.common.mobs.DefaultColourable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="thutcore", value={Dist.CLIENT})
public class ModelWrapper<T extends Entity>
extends EntityModel<T>
implements IModel {
    private static final Set<ModelWrapper<?>> WRAPPERS = Sets.newHashSet();
    public final ModelHolder model;
    public final IModelRenderer<?> renderer;
    public IModel imodel;
    private T entityIn;
    protected float rotationPointX = 0.0f;
    protected float rotationPointY = 0.0f;
    protected float rotationPointZ = 0.0f;
    protected float rotateAngleX = 0.0f;
    protected float rotateAngleY = 0.0f;
    protected float rotateAngleZ = 0.0f;
    protected float rotateAngle = 0.0f;
    public long lastInit = -1L;
    public boolean debugMode = false;
    private final int[] tmp = new int[4];
    private final IModelRenderer.Vector5 rots = new IModelRenderer.Vector5();

    @SubscribeEvent
    public static void onTextureReload(TextureStitchEvent.Post event) {
        WRAPPERS.forEach(w -> {
            w.imodel = null;
        });
    }

    public ModelWrapper(ModelHolder model, IModelRenderer<?> renderer) {
        this.model = model;
        this.renderer = renderer;
        WRAPPERS.add(this);
        Arrays.fill(this.tmp, 255);
    }

    public void setEntity(T entity) {
        this.entityIn = entity;
    }

    @Override
    public void applyAnimation(Entity entity, IModelRenderer<?> renderer, float partialTicks, float limbSwing) {
        if (!this.isLoaded()) {
            return;
        }
        this.imodel.applyAnimation(entity, renderer, partialTicks, limbSwing);
    }

    @Override
    public Set<String> getHeadParts() {
        if (this.imodel == null) {
            return Collections.emptySet();
        }
        return this.imodel.getHeadParts();
    }

    @Override
    public Map<String, IExtendedModelPart> getParts() {
        if (!this.isLoaded()) {
            return Collections.emptyMap();
        }
        return this.imodel.getParts();
    }

    @Override
    public boolean isValid() {
        if (this.imodel == null) {
            return true;
        }
        return this.imodel.isValid();
    }

    @Override
    public boolean isLoaded() {
        if (this.imodel == null) {
            return false;
        }
        return this.imodel.isLoaded();
    }

    @Override
    public void preProcessAnimations(Collection<Animation> collection) {
        if (!this.isLoaded()) {
            return;
        }
        this.imodel.preProcessAnimations(collection);
    }

    private void initColours(IExtendedModelPart parent, T entity, int brightness, int overlay) {
        IAnimationChanger animChanger;
        IMobColourable poke;
        if (this.debugMode) {
            return;
        }
        int red = 255;
        int green = 255;
        int blue = 255;
        int alpha = 255;
        IMobColourable iMobColourable = poke = entity == null ? null : (IMobColourable)entity.getCapability(DefaultColourable.CAPABILITY).orElse(null);
        if (poke != null) {
            red = poke.getRGBA()[0];
            green = poke.getRGBA()[1];
            blue = poke.getRGBA()[2];
            alpha = poke.getRGBA()[3];
        }
        if ((animChanger = this.renderer.getAnimationChanger()) != null && animChanger.modifyColourForPart(parent.getName(), (Entity)entity, this.tmp)) {
            red = this.tmp[0];
            green = this.tmp[1];
            blue = this.tmp[2];
            alpha = this.tmp[3];
        }
        parent.setRGBABrO(red, green, blue, alpha, brightness, overlay);
        for (String partName : parent.getRenderOrder()) {
            IExtendedModelPart part = (IExtendedModelPart)parent.getSubParts().get(partName);
            this.initColours(part, entity, brightness, overlay);
        }
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.isLoaded()) {
            return;
        }
        this.setEntity(entityIn);
        IPartTexturer texer = this.renderer.getTexturer();
        if (texer != null) {
            texer.bindObject(this.entityIn);
        }
        IAnimated.HeadInfo info = this.renderer.getAnimationHolder().getHeadInfo();
        if (!info.fixed) {
            info.headPitch = headPitch;
            info.headYaw = netHeadYaw;
        }
        info.currentTick = ((Entity)entityIn).f_19797_;
        IAnimationChanger animChanger = this.renderer.getAnimationChanger();
        this.imodel.getParts().forEach((partName, part) -> {
            if (animChanger != null) {
                animChanger.isPartHidden((String)partName, (Entity)entityIn, false);
            }
            if (part instanceof IRetexturableModel) {
                IRetexturableModel tex = (IRetexturableModel)((Object)part);
                tex.setTexturer(texer);
            }
        });
        if (info != null) {
            info.lastTick = ((Entity)entityIn).f_19797_;
        }
    }

    public void m_7695_(PoseStack mat, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.entityIn == null) {
            return;
        }
        if (this.imodel == null) {
            this.imodel = ModelFactory.create(this.model);
        }
        if (!this.isLoaded()) {
            return;
        }
        mat.m_85836_();
        this.transformGlobal(mat, buffer, this.renderer.getAnimation((Entity)this.entityIn), (Entity)this.entityIn, Minecraft.m_91087_().m_91296_());
        HashSet excluded = Sets.newHashSet();
        this.imodel.getParts().forEach((partName, part) -> {
            if (part.isHidden()) {
                excluded.add(partName);
                excluded.addAll(part.getRecursiveChildNames());
            }
            if (part.getParent() == null) {
                this.initColours((IExtendedModelPart)part, this.entityIn, packedLightIn, packedOverlayIn);
            }
        });
        IModel iModel = this.imodel;
        if (iModel instanceof IModelCustom) {
            IModelCustom cmodel = (IModelCustom)((Object)iModel);
            cmodel.renderAllExcept(mat, buffer, excluded);
        } else {
            for (String partName2 : this.imodel.getRenderOrder()) {
                IExtendedModelPart part2 = this.imodel.getParts().get(partName2);
                if (part2 == null || part2.getParent() != null) continue;
                mat.m_85836_();
                this.initColours(part2, this.entityIn, packedLightIn, packedOverlayIn);
                part2.renderAllExcept(mat, buffer, this.renderer, excluded);
                mat.m_85849_();
            }
        }
        mat.m_85849_();
    }

    protected void rotate(PoseStack mat) {
        Vector3f axis = new Vector3f(this.rotateAngleX, this.rotateAngleY, this.rotateAngleZ);
        mat.m_85845_(new Quaternion(axis, this.rotateAngle, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMob(T entity, MultiBufferSource bufferIn, ResourceLocation default_) {
        Object lock;
        Object object = lock = this.imodel == null ? this.renderer : this.imodel;
        synchronized (object) {
            IPartTexturer texer = this.renderer.getTexturer();
            if (texer != null) {
                texer.bindObject(entity);
                if (texer instanceof TextureHelper) {
                    TextureHelper helper = (TextureHelper)texer;
                    default_ = helper.default_tex;
                }
                ResourceLocation defs = default_;
                this.getParts().forEach((n, p) -> p.applyTexture(bufferIn, defs, texer));
            }
            this.setEntity(entity);
        }
    }

    public void m_6839_(T entityIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        if (this.imodel == null) {
            this.imodel = ModelFactory.create(this.model);
        }
        if (!this.isLoaded()) {
            return;
        }
        this.setEntity(entityIn);
        IAnimated.IAnimationHolder holder = AnimationHelper.getHolder(entityIn);
        holder.preRun();
        this.renderer.setAnimationHolder(holder);
        if (this.renderer.getAnimationChanger() != null) {
            this.renderer.setAnimation((Entity)entityIn, partialTickTime);
        }
        this.applyAnimation((Entity)entityIn, this.renderer, partialTickTime, limbSwing);
        holder.postRun();
    }

    @Override
    public void setOffset(Vector3 point) {
        this.setRotationPoint((float)point.x, (float)point.y, (float)point.z);
    }

    public void setRotationAngles(Vector4 rotations) {
        this.rotateAngle = rotations.w;
        this.rotateAngleX = rotations.x;
        this.rotateAngleY = rotations.y;
        this.rotateAngleZ = rotations.z;
    }

    public void setRotationPoint(float par1, float par2, float par3) {
        this.rotationPointX = par1;
        this.rotationPointY = par2;
        this.rotationPointZ = par3;
    }

    protected void transformGlobal(PoseStack mat, VertexConsumer buffer, String currentPhase, Entity entity, float partialTick) {
        IModelRenderer.Vector5 rotations = this.renderer.getRotations();
        if (rotations == null) {
            rotations = this.rots;
        }
        this.setRotationAngles(rotations.rotations);
        this.setOffset(this.renderer.getRotationOffset());
        this.rotate(mat);
        this.imodel.globalFix(mat, this.rotationPointX, this.rotationPointY, this.rotationPointZ);
        this.translate(mat);
        this.renderer.scaleEntity(mat, entity, this, partialTick);
    }

    private void translate(PoseStack mat) {
        mat.m_85837_((double)this.rotationPointX, (double)this.rotationPointY, (double)this.rotationPointZ);
    }

    @Override
    public void updateMaterial(AnimationXML.Mat mat) {
        this.imodel.updateMaterial(mat);
        IModel.super.updateMaterial(mat);
    }

    @Override
    public List<String> getRenderOrder() {
        return this.imodel.getRenderOrder();
    }
}

