/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.x3d;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import thut.api.entity.animation.Animation;
import thut.api.entity.animation.Animators;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.model.BaseModel;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.x3d.X3dMesh;
import thut.core.client.render.x3d.X3dPart;
import thut.core.client.render.x3d.X3dXML;
import thut.core.common.ThutCore;
import thut.lib.ResourceHelper;

public class X3dModel
extends BaseModel {
    public X3dModel() {
    }

    public X3dModel(ResourceLocation l) {
        super(l);
    }

    private void addChildren(Set<X3dXML.Transform> allTransforms, X3dXML.Transform transform) {
        for (X3dXML.Transform f : transform.transforms) {
            if (f.DEF.contains("ifs_TRANSFORM")) continue;
            allTransforms.add(f);
            this.addChildren(allTransforms, f);
        }
    }

    private Material getMaterial(X3dXML.Appearance appearance) {
        if (appearance == null) {
            return null;
        }
        X3dXML.Material mat = appearance.material;
        if (mat == null) {
            return null;
        }
        String matName = mat.DEF;
        boolean isDef = matName != null;
        matName = matName == null ? mat.USE.substring(3) : matName.substring(3);
        Material material = (Material)this.mats.get(matName = ThutCore.trim(matName));
        if (material == null || isDef) {
            String texName;
            if (appearance.tex != null && appearance.tex.DEF != null) {
                texName = appearance.tex.DEF.substring(3);
                if (texName.contains("_png")) {
                    texName = texName.substring(0, texName.lastIndexOf("_png"));
                }
                texName = ThutCore.trim(texName);
            } else {
                texName = null;
            }
            if (material == null) {
                material = new Material(matName, texName, mat.getDiffuse(), mat.getSpecular(), mat.getEmissive(), mat.ambientIntensity, mat.shininess);
            }
            if (isDef) {
                if (material.texture == null) {
                    material.texture = texName;
                }
                material.ambientIntensity = mat.ambientIntensity;
                material.shininess = mat.shininess;
                material.emissiveColor = mat.getEmissive();
                material.specularColor = mat.getSpecular();
                material.diffuseColor = mat.getDiffuse();
                material.emissiveMagnitude = Math.min(1.0f, (float)((double)mat.getEmissive().length() / Math.sqrt(3.0)) / 0.8f);
            }
            this.mats.put(matName, material);
        }
        return material;
    }

    @Override
    public void loadModel(ResourceLocation model) {
        block3: {
            this.valid = true;
            try {
                InputStream stream = ResourceHelper.getStream(model, Minecraft.m_91087_().m_91098_());
                this.last_loaded = model;
                if (stream == null) {
                    this.valid = false;
                    return;
                }
                X3dXML xml = new X3dXML(stream);
                stream.close();
                this.makeObjects(xml);
            }
            catch (Exception e) {
                this.valid = false;
                if (e instanceof FileNotFoundException) break block3;
                ThutCore.LOGGER.error("error loading " + model, (Throwable)e);
            }
        }
    }

    private void makeObjects(X3dXML xml) throws Exception {
        HashMap childMap = Maps.newHashMap();
        HashSet allTransforms = Sets.newHashSet();
        for (X3dXML.Transform transform : xml.model.scene.transforms) {
            allTransforms.add(transform);
            this.addChildren(allTransforms, transform);
        }
        for (X3dXML.Transform transform : allTransforms) {
            String[] offset = transform.translation.split(" ");
            Vector3 translation = new Vector3().set(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]));
            offset = transform.scale.split(" ");
            Vertex scale = new Vertex(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]));
            offset = transform.rotation.split(" ");
            Vector3f axis = new Vector3f(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]));
            Quaternion quat = new Quaternion(axis, Float.parseFloat(offset[3]), false);
            Vector4 rotations = new Vector4(quat);
            Set<String> children = transform.getChildNames();
            X3dXML.Transform transform2 = transform.getIfsTransform();
            if (transform2 == null) continue;
            X3dXML.Group group = transform2.group;
            String name = ThutCore.trim(transform2.getGroupName());
            ArrayList shapes = Lists.newArrayList();
            for (X3dXML.Shape shape : group.shapes) {
                X3dXML.IndexedTriangleSet triangleSet = shape.triangleSet;
                X3dMesh renderShape = new X3dMesh(triangleSet.getOrder(), triangleSet.getVertices(), triangleSet.getNormals(), triangleSet.getTexture());
                shapes.add(renderShape);
                X3dXML.Appearance appearance = shape.appearance;
                Material material = this.getMaterial(appearance);
                renderShape.name = name;
                if (material == null) continue;
                renderShape.setMaterial(material);
            }
            X3dPart o = new X3dPart(name);
            o.setShapes(shapes);
            o.rotations.set(rotations.x, rotations.y, rotations.z, rotations.w);
            o.offset.set(translation);
            o.scale = scale;
            this.parts.put(name, o);
            childMap.put(name, children);
        }
        for (Map.Entry entry : childMap.entrySet()) {
            String key = (String)entry.getKey();
            if (this.parts.get(key) == null) continue;
            IExtendedModelPart part = (IExtendedModelPart)this.parts.get(key);
            for (String s : (Set)entry.getValue()) {
                if (this.parts.get(s) == null || this.parts.get(s) == part) continue;
                part.addChild((IExtendedModelPart)this.parts.get(s));
            }
        }
    }

    @Override
    public void preProcessAnimations(Collection<Animation> animations) {
        animations.forEach(a -> a.sets.forEach((s, anim) -> {
            if (anim instanceof Animators.KeyframeAnimator) {
                Animators.KeyframeAnimator a2 = (Animators.KeyframeAnimator)anim;
                a2.components.forEach(comp -> {
                    double d0 = comp.posOffset[0] / 16.0;
                    double d1 = comp.posOffset[1] / 16.0;
                    double d2 = comp.posOffset[2] / 16.0;
                    comp.posOffset[0] = -d0;
                    comp.posOffset[1] = d2;
                    comp.posOffset[2] = -d1;
                    d0 = comp.posChange[0] / 16.0;
                    d1 = comp.posChange[1] / 16.0;
                    d2 = comp.posChange[2] / 16.0;
                    comp.posChange[0] = -d0;
                    comp.posChange[1] = d2;
                    comp.posChange[2] = -d1;
                });
            }
        }));
    }
}

