/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.x3d;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import thut.api.maths.vecmath.Vec3f;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.texturing.TextureCoordinate;
import thut.core.client.render.x3d.ModelFormatException;
import thut.core.common.ThutCore;
import thut.core.xml.bind.Factory;
import thut.core.xml.bind.annotation.XmlAttribute;
import thut.core.xml.bind.annotation.XmlElement;
import thut.core.xml.bind.annotation.XmlRootElement;

public class X3dXML {
    public X3D model;

    private static Vec3f fromString(String vect) {
        if (vect == null) {
            vect = "0 0 0";
        }
        String[] var = vect.split(" ");
        return new Vec3f(Float.parseFloat(var[0]), Float.parseFloat(var[1]), Float.parseFloat(var[2]));
    }

    public X3dXML(InputStream stream) {
        try {
            this.model = Factory.make(stream, X3D.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @XmlRootElement(name="X3D")
    public static class X3D {
        @XmlElement(name="Scene")
        Scene scene;
    }

    @XmlRootElement(name="Transform")
    public static class Transform {
        @XmlAttribute(name="DEF")
        String DEF;
        @XmlAttribute(name="translation")
        String translation;
        @XmlAttribute(name="scale")
        String scale;
        @XmlAttribute(name="rotation")
        String rotation;
        @XmlElement(name="Transform")
        List<Transform> transforms = Lists.newArrayList();
        @XmlElement(name="Group")
        Group group;

        public Set<String> getChildNames() {
            HashSet ret = Sets.newHashSet();
            for (Transform t : this.transforms) {
                if (t.getGroupName() == null) continue;
                ret.add(ThutCore.trim(t.getGroupName()));
            }
            return ret;
        }

        public String getGroupName() {
            if (this.group == null && this.getIfsTransform() != this) {
                return this.getIfsTransform().getGroupName();
            }
            if (this.group == null || this.group.DEF == null) {
                return this.getIfsTransform().DEF.replace("_ifs_TRANSFORM", "");
            }
            return this.group.DEF.substring("group_ME_".length());
        }

        public Transform getIfsTransform() {
            if (this.DEF.endsWith("ifs_TRANSFORM")) {
                return this;
            }
            for (Transform t : this.transforms) {
                if (!t.DEF.equals(this.DEF.replace("_TRANSFORM", "_ifs_TRANSFORM"))) continue;
                return t;
            }
            return null;
        }

        public String toString() {
            return this.DEF + " " + this.transforms;
        }
    }

    @XmlRootElement(name="TextureTransform")
    public static class TextureTransform {
        @XmlAttribute(name="translation")
        String translation;
        @XmlAttribute(name="scale")
        String scale;
        @XmlAttribute(name="rotation")
        float rotation;
    }

    @XmlRootElement(name="Shape")
    public static class Shape {
        @XmlElement(name="Appearance")
        Appearance appearance;
        @XmlElement(name="IndexedTriangleSet")
        IndexedTriangleSet triangleSet;
    }

    @XmlRootElement(name="Scene")
    public static class Scene {
        @XmlElement(name="Transform")
        List<Transform> transforms = Lists.newArrayList();
    }

    @XmlRootElement(name="Material")
    public static class Material {
        @XmlAttribute(name="DEF")
        String DEF;
        @XmlAttribute(name="USE")
        String USE;
        @XmlAttribute(name="diffuseColor")
        private String diffuseColor;
        @XmlAttribute(name="specularColor")
        private String specularColor;
        @XmlAttribute(name="emissiveColor")
        private String emissiveColor;
        @XmlAttribute(name="ambientIntensity")
        float ambientIntensity;
        @XmlAttribute(name="shininess")
        float shininess;
        @XmlAttribute(name="transparency")
        float transparency;
        private Vec3f diffuse;
        private Vec3f specular;
        private Vec3f emissive;

        public Vec3f getDiffuse() {
            if (this.diffuse == null) {
                this.diffuse = X3dXML.fromString(this.diffuseColor);
            }
            return this.diffuse;
        }

        public Vec3f getEmissive() {
            if (this.emissive == null) {
                this.emissive = X3dXML.fromString(this.emissiveColor);
            }
            return this.emissive;
        }

        public Vec3f getSpecular() {
            if (this.specular == null) {
                this.specular = X3dXML.fromString(this.specularColor);
            }
            return this.specular;
        }
    }

    @XmlRootElement(name="IndexedTriangleSet")
    public static class IndexedTriangleSet {
        @XmlAttribute(name="solid")
        boolean solid;
        @XmlAttribute(name="normalPerVertex")
        boolean normalPerVertex;
        @XmlAttribute(name="index")
        String index;
        @XmlElement(name="Coordinate")
        Coordinate points;
        @XmlElement(name="Normal")
        Normal normals;
        @XmlElement(name="TextureCoordinate")
        TextureCoordinate textures;

        private static Vertex[] parseVertices(String line) throws ModelFormatException {
            ArrayList<Vertex> ret = new ArrayList<Vertex>();
            String[] points = line.split(" ");
            if (points.length % 3 != 0) {
                throw new ModelFormatException("Invalid number of elements in the points string");
            }
            for (int i = 0; i < points.length; i += 3) {
                Vertex toAdd = new Vertex(Float.parseFloat(points[i]), Float.parseFloat(points[i + 1]), Float.parseFloat(points[i + 2]));
                ret.add(toAdd);
            }
            return ret.toArray(new Vertex[ret.size()]);
        }

        public Vertex[] getNormals() {
            return this.normals.getNormals();
        }

        public Integer[] getOrder() {
            String[] offset = this.index.split(" ");
            Integer[] order = new Integer[offset.length];
            for (int i = 0; i < offset.length; ++i) {
                String s1 = offset[i];
                order[i] = Integer.parseInt(s1);
            }
            return order;
        }

        public thut.core.client.render.texturing.TextureCoordinate[] getTexture() {
            if (this.textures == null) {
                return null;
            }
            return this.textures.getTexture();
        }

        public Vertex[] getVertices() {
            return this.points.getVertices();
        }

        @XmlRootElement(name="Normal")
        public static class Normal {
            @XmlAttribute(name="vector")
            String vector;

            public Vertex[] getNormals() {
                return IndexedTriangleSet.parseVertices(this.vector);
            }
        }

        @XmlRootElement(name="TextureCoordinate")
        public static class TextureCoordinate {
            @XmlAttribute(name="point")
            String point;

            public thut.core.client.render.texturing.TextureCoordinate[] getTexture() {
                ArrayList<thut.core.client.render.texturing.TextureCoordinate> ret = new ArrayList<thut.core.client.render.texturing.TextureCoordinate>();
                String[] points = this.point.split(" ");
                if (points.length % 2 != 0) {
                    throw new ModelFormatException("Invalid number of elements in the points string " + points.length);
                }
                for (int i = 0; i < points.length; i += 2) {
                    thut.core.client.render.texturing.TextureCoordinate toAdd = new thut.core.client.render.texturing.TextureCoordinate(Float.parseFloat(points[i]), 1.0f - Float.parseFloat(points[i + 1]));
                    ret.add(toAdd);
                }
                return ret.toArray(new thut.core.client.render.texturing.TextureCoordinate[ret.size()]);
            }
        }

        @XmlRootElement(name="Coordinate")
        public static class Coordinate {
            @XmlAttribute(name="point")
            String point;

            public Vertex[] getVertices() {
                return IndexedTriangleSet.parseVertices(this.point);
            }
        }
    }

    @XmlRootElement(name="ImageTexture")
    public static class ImageTexture {
        @XmlAttribute(name="DEF")
        String DEF;
    }

    @XmlRootElement(name="Group")
    public static class Group {
        @XmlAttribute(name="DEF")
        String DEF;
        @XmlElement(name="Shape")
        List<Shape> shapes = Lists.newArrayList();
    }

    @XmlRootElement(name="Appearance")
    public static class Appearance {
        @XmlElement(name="ImageTexture")
        ImageTexture tex;
        @XmlElement(name="Material")
        Material material;
        @XmlElement(name="TextureTransform")
        TextureTransform texTransform;
    }
}

