/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.FileAppender;
import thut.api.AnimatedCaps;
import thut.api.LinkableCaps;
import thut.api.ThutCaps;
import thut.api.Tracker;
import thut.api.block.flowing.functions.LootLayerFunction;
import thut.api.entity.BreedableCaps;
import thut.api.entity.CopyCaps;
import thut.api.entity.IMultiplePassengerEntity;
import thut.api.entity.ShearableCaps;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.BlockEntityInventory;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.terrain.StructureManager;
import thut.api.util.PermNodes;
import thut.core.common.Proxy;
import thut.core.common.config.Config;
import thut.core.common.handlers.ConfigHandler;
import thut.core.common.network.CapabilitySync;
import thut.core.common.network.EntityUpdate;
import thut.core.common.network.GeneralUpdate;
import thut.core.common.network.PacketHandler;
import thut.core.common.network.PacketPartInteract;
import thut.core.common.network.PartSync;
import thut.core.common.network.TerrainUpdate;
import thut.core.common.network.TileUpdate;
import thut.core.common.terrain.CapabilityTerrainAffected;
import thut.core.common.world.mobs.data.PacketDataSync;
import thut.core.init.RegistryObjects;
import thut.core.proxy.ClientProxy;
import thut.core.proxy.CommonProxy;
import thut.crafts.ThutCrafts;

@Mod(value="thutcore")
public class ThutCore {
    public static final Logger LOGGER = LogManager.getLogger((String)"thutcore");
    public static final String MODID = "thutcore";
    private static final String NETVERSION = "1.1.0";
    public static final PacketHandler packets = new PacketHandler(new ResourceLocation("thutcore", "comms"), "1.1.0");
    public static ThutCore instance;
    public static final Proxy proxy;
    public static final ConfigHandler conf;
    public static ItemStack THUTICON;
    public static final CreativeModeTab THUTITEMS;
    private static Map<String, String> trimmed;

    public static synchronized String trim(String name) {
        if (name == null) {
            return null;
        }
        return trimmed.computeIfAbsent(name, ThutCore::_trim);
    }

    private static String _trim(String name) {
        String trim = name;
        trim = trim.toLowerCase(Locale.ROOT).trim();
        trim = trim.replaceAll("([^a-z0-9 /_-])", "");
        trim = trim.replaceAll(" ", "_");
        return trim;
    }

    public static Random newRandom() {
        return new Random(System.nanoTime());
    }

    public ThutCore() {
        instance = this;
        File logfile = FMLPaths.GAMEDIR.get().resolve("logs").resolve("thutcore.log").toFile();
        if (logfile.exists()) {
            logfile.delete();
        }
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LOGGER;
        FileAppender appender = ((FileAppender.Builder)FileAppender.newBuilder().withFileName(logfile.getAbsolutePath()).setName(MODID)).build();
        logger.addAppender((Appender)appender);
        appender.start();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        RegistryEvents.LOOTTYPE.register(modEventBus);
        RegistryEvents.RECIPETYPE.register(modEventBus);
        RegistryEvents.MENUS.register(modEventBus);
        RegistryEvents.PARTICLES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(PermNodes::gatherPerms);
        Tracker.init();
        LootLayerFunction.init();
        RegistryObjects.init();
        Config.setupConfigs(conf, MODID, MODID);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        proxy.setupClient(event);
    }

    @SubscribeEvent
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
        LOGGER.debug("Clearing terrain cache");
        StructureManager.clear();
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Setup");
        if (THUTICON.m_41619_()) {
            THUTICON = new ItemStack((ItemLike)ThutCrafts.CRAFTMAKER.get());
        }
        packets.registerMessage(EntityUpdate.class, EntityUpdate::new);
        packets.registerMessage(TileUpdate.class, TileUpdate::new);
        packets.registerMessage(TerrainUpdate.class, TerrainUpdate::new);
        packets.registerMessage(PacketDataSync.class, PacketDataSync::new);
        packets.registerMessage(GeneralUpdate.class, GeneralUpdate::new);
        packets.registerMessage(CapabilitySync.class, CapabilitySync::new);
        packets.registerMessage(PacketPartInteract.class, PacketPartInteract::new);
        packets.registerMessage(PartSync.class, PartSync::new);
        GeneralUpdate.init();
        CapabilitySync.init();
        CapabilityTerrainAffected.init();
        LinkableCaps.setup();
        ShearableCaps.setup();
        BreedableCaps.setup();
        AnimatedCaps.setup();
        CopyCaps.setup();
        proxy.setup(event);
        event.enqueueWork(() -> {
            EntityDataSerializers.m_135050_(IMultiplePassengerEntity.SEATSERIALIZER);
            EntityDataSerializers.m_135050_(BlockEntityBase.VEC3DSER);
        });
    }

    public static ConfigHandler getConfig() {
        return conf;
    }

    static {
        proxy = (Proxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        conf = new ConfigHandler();
        THUTICON = ItemStack.f_41583_;
        THUTITEMS = new CreativeModeTab("thut"){

            public ItemStack m_6976_() {
                return THUTICON;
            }
        };
        trimmed = new Object2ObjectOpenHashMap();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="thutcore")
    public static class RegistryEvents {
        public static final DeferredRegister<RecipeType<?>> RECIPETYPE = DeferredRegister.create((ResourceKey)Registry.f_122914_, (String)"thutcore");
        public static final DeferredRegister<LootItemFunctionType> LOOTTYPE = DeferredRegister.create((ResourceKey)Registry.f_122816_, (String)"thutcore");
        public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"thutcore");
        public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"thutcore");

        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            ThutCaps.registerCapabilities(event);
        }
    }

    public static class MobEvents {
        private static final ResourceLocation CAPID = new ResourceLocation("thutcore", "inventory");

        @SubscribeEvent
        public static void onMobCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
            if (event.getCapabilities().containsKey(CAPID)) {
                return;
            }
            if (!(event.getObject() instanceof IBlockEntity)) {
                return;
            }
            event.addCapability(CAPID, (ICapabilityProvider)new BlockEntityInventory((IBlockEntity)event.getObject()));
        }

        public static EntityHitResult rayTraceEntities(Entity shooter, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double distance) {
            Level world = shooter.f_19853_;
            double d0 = distance;
            Entity entity = null;
            Vec3 vector3d = null;
            for (Entity entity1 : world.m_6249_(shooter, boundingBox, filter)) {
                Vec3 vector3d1;
                double d1;
                AABB axisalignedbb = entity1.m_20191_().m_82400_((double)entity1.m_6143_());
                Optional optional = axisalignedbb.m_82371_(startVec, endVec);
                if (axisalignedbb.m_82390_(startVec)) {
                    if (!(d0 >= 0.0)) continue;
                    entity = entity1;
                    vector3d = optional.orElse(startVec);
                    d0 = 0.0;
                    continue;
                }
                if (!optional.isPresent() || !((d1 = startVec.m_82557_(vector3d1 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
                if (entity1.m_20201_() == shooter.m_20201_() && !entity1.canRiderInteract()) {
                    if (d0 != 0.0) continue;
                    entity = entity1;
                    vector3d = vector3d1;
                    continue;
                }
                entity = entity1;
                vector3d = vector3d1;
                d0 = d1;
            }
            return entity == null ? null : new EntityHitResult(entity, vector3d);
        }

        @SubscribeEvent
        public static void interact(PlayerInteractEvent.RightClickBlock event) {
            AABB box;
            Vec3 look;
            Vec3 face;
            Player player;
            EntityHitResult var;
            if (event.getLevel().m_46859_(event.getPos()) && (var = MobEvents.rayTraceEntities((Entity)(player = event.getEntity()), face = event.getEntity().m_20299_(0.0f), look = event.getEntity().m_20154_(), box = event.getEntity().m_20191_().m_82377_(3.0, 3.0, 3.0), e -> e instanceof IBlockEntity, 3.0)) != null && var.m_6662_() == HitResult.Type.ENTITY) {
                IBlockEntity entity = (IBlockEntity)var.m_82443_();
                if (entity.getInteractor().processInitialInteract(event.getEntity(), event.getItemStack(), event.getHand()) != InteractionResult.PASS) {
                    event.setCanceled(true);
                    return;
                }
                if (entity.getInteractor().interactInternal(event.getEntity(), event.getPos(), event.getItemStack(), event.getHand()) != InteractionResult.PASS) {
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }
}

