/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import thut.api.util.PermNodes;
import thut.core.common.ThutCore;
import thut.core.common.commands.CommandTools;
import thut.core.common.config.Config;
import thut.lib.TComponent;

public class CommandConfigs {
    protected static int execute(Config.ConfigData data, CommandSourceStack source, String field) {
        try {
            Field f = data.getClass().getField(field);
            Object value = f.get(data);
            source.m_81354_((Component)TComponent.translatable("thutcore.command.settings.check", field, value), true);
        }
        catch (Exception e) {
            throw new CommandRuntimeException((Component)TComponent.literal("Error with field name " + field));
        }
        return 0;
    }

    protected static int execute(Config.ConfigData data, CommandSourceStack source, String field, String message) {
        Field f = null;
        Object value = null;
        try {
            f = data.getClass().getField(field);
            value = f.get(data);
        }
        catch (Exception e) {
            ThutCore.LOGGER.error((Object)e);
            throw new CommandRuntimeException((Component)TComponent.literal("Error with field name " + field));
        }
        String[] args = message.split(" ");
        Object val = args[0];
        if (((String)val).equals("!set")) {
            CommandConfigs.handleSet(data, args, value, f);
            source.m_81354_((Component)TComponent.translatable("thutcore.command.settings.array.set", field, value), true);
            return 0;
        }
        if (((String)val).equals("!add")) {
            CommandConfigs.handleAdd(data, args, value, f);
            source.m_81354_((Component)TComponent.translatable("thutcore.command.settings.array.add", field, value), true);
            return 0;
        }
        if (((String)val).equals("!remove")) {
            CommandConfigs.handleRemove(data, args, value, f);
            source.m_81354_((Component)TComponent.translatable("thutcore.command.settings.array.remove", field, value), true);
            return 0;
        }
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                val = (String)val + " " + args[i];
            }
        }
        try {
            data.updateField(f, val);
            value = f.get(data);
        }
        catch (Exception e) {
            throw new CommandRuntimeException((Component)TComponent.literal("Error with setting field name " + field));
        }
        source.m_81354_((Component)TComponent.translatable("thutcore.command.settings.set", field, value), true);
        return 0;
    }

    static void handleAdd(Config.ConfigData data, String[] args, Object o, Field field) throws CommandRuntimeException {
        Object value = args[1];
        for (int i = 3; i < args.length; ++i) {
            value = (String)value + " " + args[i];
        }
        Object[] toSet = null;
        if (o instanceof String[]) {
            int len = ((String[])o).length;
            toSet = Arrays.copyOf((String[])o, len + 1);
            toSet[len] = value;
        } else if (o instanceof int[]) {
            int len = ((int[])o).length;
            toSet = Arrays.copyOf((int[])o, len + 1);
            ((int[])toSet)[len] = CommandConfigs.parseInt((String)value);
        } else {
            throw new CommandRuntimeException((Component)TComponent.literal("This can only by done for arrays."));
        }
        try {
            data.updateField(field, toSet);
        }
        catch (Exception e) {
            throw new CommandRuntimeException((Component)TComponent.literal("Error with setting field name " + field));
        }
    }

    static void handleRemove(Config.ConfigData data, String[] args, Object o, Field field) throws CommandRuntimeException {
        Object value = args[1];
        for (int i = 3; i < args.length; ++i) {
            value = (String)value + " " + args[i];
        }
        Object[] toSet = null;
        if (o instanceof String[]) {
            Object[] arr = (String[])o;
            ArrayList values = Lists.newArrayList((Object[])arr);
            int index = values.indexOf(value);
            if (index != -1) {
                values.remove(index);
            }
            toSet = values.toArray(new String[values.size()]);
        } else if (o instanceof int[]) {
            int[] arr = (int[])o;
            int arg = CommandConfigs.parseInt((String)value);
            ArrayList values = Lists.newArrayList();
            for (int element : arr) {
                values.add(element);
            }
            int index = values.indexOf(arg);
            if (index != -1) {
                values.remove(index);
            }
            arr = new int[values.size()];
            toSet = arr;
            for (int i = 0; i < values.size(); ++i) {
                arr[i] = (Integer)values.get(i);
            }
        } else {
            throw new CommandRuntimeException((Component)TComponent.literal("This can only by done for arrays."));
        }
        try {
            data.updateField(field, toSet);
        }
        catch (Exception e) {
            throw new CommandRuntimeException((Component)TComponent.literal("Error with setting field name " + field));
        }
    }

    static void handleSet(Config.ConfigData data, String[] args, Object o, Field field) throws CommandRuntimeException {
        int num = CommandConfigs.parseInt(args[1]);
        Object value = args[2];
        for (int i = 4; i < args.length; ++i) {
            value = (String)value + " " + args[i];
        }
        Object toSet = null;
        if (o instanceof String[]) {
            String[] arr = (String[])o;
            arr[num] = value;
            toSet = arr.clone();
        } else if (o instanceof int[]) {
            int[] arr = (int[])o;
            arr[num] = CommandConfigs.parseInt((String)value);
            toSet = arr.clone();
        } else {
            throw new CommandRuntimeException((Component)TComponent.literal("This can only by done for arrays."));
        }
        try {
            data.updateField(field, toSet);
        }
        catch (Exception e) {
            throw new CommandRuntimeException((Component)TComponent.literal("Error with setting field name " + field));
        }
    }

    public static SuggestionProvider<CommandSourceStack> MakeProvider(Config.ConfigData data) {
        ArrayList values = Lists.newArrayList();
        for (Field f : data.commonValues.keySet()) {
            values.add(f.getName());
        }
        for (Field f : data.serverValues.keySet()) {
            values.add(f.getName());
        }
        for (Field f : data.clientValues.keySet()) {
            values.add(f.getName());
        }
        return (ctx, sb) -> SharedSuggestionProvider.m_82970_((Iterable)values, (SuggestionsBuilder)sb);
    }

    public static int parseInt(String input) throws CommandRuntimeException {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException var2) {
            throw new CommandRuntimeException((Component)TComponent.translatable("commands.generic.num.invalid", input));
        }
    }

    public static void register(Config.ConfigData data, CommandDispatcher<CommandSourceStack> commandDispatcher, String prefix) {
        String name = "";
        name = prefix;
        String perm1 = "command." + name + ".check";
        PermNodes.registerBooleanNode("thutcore", perm1, PermNodes.DefaultPermissionLevel.ALL, "Is the player allowed to check configs for " + data.MODID);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)name).requires(cs -> CommandTools.hasPerm(cs, perm1))).then(Commands.m_82129_((String)"option", (ArgumentType)StringArgumentType.string()).suggests(CommandConfigs.MakeProvider(data)).executes(ctx -> CommandConfigs.execute(data, (CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"))));
        commandDispatcher.register(command);
        String perm2 = "command." + name + ".set";
        PermNodes.registerBooleanNode("thutcore", perm2, PermNodes.DefaultPermissionLevel.OP, "Is the player allowed to set configs for " + data.MODID);
        command = (LiteralArgumentBuilder)Commands.m_82127_((String)name).then(Commands.m_82129_((String)"option", (ArgumentType)StringArgumentType.string()).suggests(CommandConfigs.MakeProvider(data)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).requires(cs -> CommandTools.hasPerm(cs, perm2))).executes(ctx -> CommandConfigs.execute(data, (CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"), StringArgumentType.getString((CommandContext)ctx, (String)"value")))));
        commandDispatcher.register(command);
    }
}

