/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.commands;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import thut.api.util.PermNodes;
import thut.lib.TComponent;

public class CommandTools {
    public static boolean hasPerm(CommandSourceStack source, String permission) {
        try {
            ServerPlayer player = source.m_81375_();
            return CommandTools.hasPerm(player, permission);
        }
        catch (CommandSyntaxException e) {
            return true;
        }
    }

    public static boolean hasPerm(ServerPlayer player, String permission) {
        return PermNodes.getBooleanPerm(player, permission);
    }

    public static Component makeError(String text) {
        return CommandTools.makeTranslatedMessage(text, "red:italic", new Object[0]);
    }

    public static Component makeTranslatedMessage(String key, String formatting, Object ... args) {
        if (formatting == null) {
            formatting = "";
        }
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof String)) continue;
            args[i] = TComponent.translatable((String)args[i]);
        }
        MutableComponent translated = TComponent.translatable(key, args);
        if (!formatting.isEmpty()) {
            String[] args2 = formatting.split(":");
            String colour = args2[0].toUpperCase(Locale.ROOT);
            Style style = translated.m_7383_();
            style = style.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.m_126657_((String)colour)));
            if (args2.length > 1) {
                for (int i1 = 1; i1 < args2.length; ++i1) {
                    String arg = args2[i1];
                    if (arg.equalsIgnoreCase("italic")) {
                        style = style.m_131155_(Boolean.valueOf(true));
                    }
                    if (arg.equalsIgnoreCase("bold")) {
                        style = style.m_131136_(Boolean.valueOf(true));
                    }
                    if (arg.equalsIgnoreCase("underlined")) {
                        style = style.m_131162_(Boolean.valueOf(true));
                    }
                    if (arg.equalsIgnoreCase("strikethrough")) {
                        style = style.m_178522_(Boolean.valueOf(true));
                    }
                    if (!arg.equalsIgnoreCase("obfuscated")) continue;
                    style = style.m_178524_(Boolean.valueOf(true));
                }
            }
            translated.m_6270_(style);
        }
        return translated;
    }

    public static void sendBadArgumentsMissingArg(CommandSource sender) {
        sender.m_213846_(CommandTools.makeError("pokecube.command.invalidmissing"));
    }

    public static void sendBadArgumentsTryTab(CommandSource sender) {
        sender.m_213846_(CommandTools.makeError("pokecube.command.invalidtab"));
    }

    public static void sendError(CommandSourceStack sender, String text) {
        sender.m_81352_(CommandTools.makeError(text));
    }

    public static void sendError(CommandSource sender, String text) {
        sender.m_213846_(CommandTools.makeError(text));
    }

    public static void sendMessage(CommandSource sender, String text) {
        Component message = CommandTools.makeTranslatedMessage(text, null, new Object[0]);
        sender.m_213846_(message);
    }

    public static void sendNoPermissions(CommandSource sender) {
        sender.m_213846_(CommandTools.makeError("pokecube.command.noperms"));
    }
}

