/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.genetics;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import thut.api.entity.genetics.Alleles;
import thut.api.entity.genetics.Gene;
import thut.api.entity.genetics.IMobGenetics;
import thut.core.common.ThutCore;

public class DefaultGenetics
implements IMobGenetics {
    Random rand = ThutCore.newRandom();
    Map<ResourceLocation, Alleles<?, ?>> genetics = Maps.newHashMap();
    Set<Alleles<?, ?>> epigenes;

    @Override
    public Map<ResourceLocation, Alleles<?, ?>> getAlleles() {
        return this.genetics;
    }

    @Override
    public Collection<ResourceLocation> getKeys() {
        return this.genetics.keySet();
    }

    @Override
    public <T, GENE extends Gene<T>> Alleles<T, GENE> getAlleles(ResourceLocation key) {
        return this.genetics.get(key);
    }

    @Override
    public Set<Alleles<?, ?>> getEpigenes() {
        if (this.epigenes == null) {
            this.epigenes = Sets.newHashSet();
            for (Alleles<?, ?> a : this.genetics.values()) {
                if (!(a.getExpressed().getEpigeneticRate() > 0.0f)) continue;
                this.epigenes.add(a);
            }
        }
        return this.epigenes;
    }

    @Override
    public void setFromParents(IMobGenetics parent1, IMobGenetics parent2) {
        Map<ResourceLocation, Alleles<?, ?>> genetics1 = parent1.getAlleles();
        Map<ResourceLocation, Alleles<?, ?>> genetics2 = parent2.getAlleles();
        for (Alleles<?, ?> a1 : genetics1.values()) {
            Object gene1 = a1.getExpressed();
            Alleles<?, ?> a2 = genetics2.get(gene1.getKey());
            if (a2 == null) continue;
            Object gene2 = a2.getExpressed();
            gene1 = gene1.getEpigeneticRate() > this.rand.nextFloat() ? gene1 : a1.getAllele(this.rand.nextInt(2));
            Object object = gene2 = gene2.getEpigeneticRate() > this.rand.nextFloat() ? gene2 : a2.getAllele(this.rand.nextInt(2));
            if (gene1.getMutationRate() > this.rand.nextFloat()) {
                gene1 = gene1.mutate(parent1, parent2);
            }
            if (gene2.getMutationRate() > this.rand.nextFloat()) {
                gene2 = gene2.mutate(parent1, parent2);
            }
            Alleles allele = new Alleles(gene1, gene2);
            this.getAlleles().put(gene1.getKey(), allele);
        }
    }

    public ListTag serializeNBT() {
        ListTag genes = new ListTag();
        ArrayList keys = Lists.newArrayList(this.getKeys());
        Collections.sort(keys);
        for (ResourceLocation key : keys) {
            CompoundTag tag = new CompoundTag();
            Alleles gene = this.getAlleles(key);
            tag.m_128359_("K", key.toString());
            tag.m_128365_("V", (Tag)gene.save());
            genes.add((Object)tag);
        }
        return genes;
    }

    public void deserializeNBT(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            Alleles alleles = new Alleles();
            ResourceLocation key = new ResourceLocation(tag.m_128461_("K"));
            try {
                alleles.load(tag.m_128469_("V"));
                this.getAlleles().put(key, alleles);
                continue;
            }
            catch (Exception e) {
                ThutCore.LOGGER.error("Error loading gene for key: " + key, (Throwable)e);
            }
        }
    }
}

