/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.handlers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import thut.api.boom.ExplosionCustom;
import thut.api.entity.blockentity.BlockEntityUpdater;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.maths.Cruncher;
import thut.api.terrain.TerrainChecker;
import thut.api.terrain.TerrainSegment;
import thut.core.common.config.Config;
import thut.core.common.config.Configure;
import thut.core.common.terrain.ConfigTerrainBuilder;
import thut.core.common.terrain.ConfigTerrainChecker;

public class ConfigHandler
extends Config.ConfigData {
    private static final String BOOMS = "explosions";
    private static final String BIOMES = "biomes";
    private static final String BLOCKENTITY = "blockentity";
    private static final String MISC = "misc";
    private static final String CLIENT = "client";
    private static final String WORLD = "generation";
    private static final String DEBUG = "debug";
    @Configure(category="generation", comment="Structures listed here will have the relevant subbiome applied for if minecraft thinks that the block is inside the structure.")
    public List<String> structure_subbiomes = Lists.newArrayList((Object[])new String[]{"{\"struct\":\"#pokecube_world:village\",\"subbiome\":\"village\"}", "{\"struct\":\"#pokecube_world:town\",\"subbiome\":\"village\"}", "{\"struct\":\"#minecraft:village\",\"subbiome\":\"village\"}", "{\"struct\":\"#minecraft:on_ocean_explorer_maps\",\"subbiome\":\"monument\"}"});
    @Configure(category="generation", comment="Does a blanket \"plant material\" check for cuttable and edible plants, rather than relying entirely on the block tags. [Default: true]")
    public boolean autoPopulateLists = true;
    @Configure(category="explosions")
    public int maxMsPerTick = 25;
    @Configure(category="explosions")
    public int explosionRadius = 127;
    @Configure(category="explosions")
    public double minBlastEffect = 0.25;
    @Configure(category="explosions")
    public boolean affectAir = true;
    @Configure(category="explosions")
    public boolean generateCache = true;
    @Configure(category="biomes")
    public boolean resetAllTerrain = false;
    @Configure(category="biomes")
    public List<String> customBiomeMappings = Lists.newArrayList();
    @Configure(category="blockentity")
    public List<String> teblacklist = Lists.newArrayList();
    @Configure(category="blockentity")
    public List<String> blockblacklist = Lists.newArrayList((Object[])new String[]{"minecraft:bedrock"});
    @Configure(category="blockentity")
    public boolean autoBlacklistErroredTEs = true;
    @Configure(category="misc")
    public boolean supress_warns = false;
    @Configure(category="client")
    public boolean asyncModelLoads = true;
    @Configure(category="client")
    public double modelCullThreshold = 0.1;
    @Configure(category="debug")
    public boolean debug = false;
    @Configure(category="debug")
    public boolean debug_data = false;
    @Configure(category="debug")
    public boolean debug_models = false;

    public ConfigHandler() {
        super("thutcore");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdated() {
        ExplosionCustom.MAX_RADIUS = this.explosionRadius;
        ExplosionCustom.AFFECTINAIR = this.affectAir;
        ExplosionCustom.MAXPERTICK = this.maxMsPerTick;
        ExplosionCustom.MINBLASTDAMAGE = (float)this.minBlastEffect;
        TerrainSegment.noLoad = this.resetAllTerrain;
        IBlockEntity.TEBLACKLIST.clear();
        BlockEntityUpdater.autoBlacklist = this.autoBlacklistErroredTEs;
        for (String string : this.teblacklist) {
            void var2_2;
            if (!string.contains(":")) {
                String string2 = "minecraft:" + string;
            }
            IBlockEntity.TEBLACKLIST.add((String)var2_2);
            IBlockEntity.TEBLACKLIST.add(var2_2.toLowerCase(Locale.ENGLISH));
        }
        for (String string : this.blockblacklist) {
            IBlockEntity.BLOCKBLACKLIST.add(new ResourceLocation(string));
        }
        TerrainSegment.biomeCheckers.removeIf(t -> t instanceof ConfigTerrainChecker);
        ConfigTerrainBuilder.process(this.customBiomeMappings);
        if (this.generateCache) {
            Cruncher.init();
        }
        TerrainChecker.initStructMap();
    }
}

