/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.handlers;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.core.common.ThutCore;

public class PlayerDataHandler {
    private static Set<Class<? extends PlayerData>> dataMap = Sets.newHashSet();
    private static Set<String> dataIds = Sets.newHashSet();
    private static PlayerDataHandler INSTANCESERVER;
    private static PlayerDataHandler INSTANCECLIENT;
    private final Map<String, PlayerDataManager> data = Maps.newHashMap();

    public static void clear() {
        if (INSTANCECLIENT != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCECLIENT);
        }
        if (INSTANCESERVER != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCESERVER);
        }
        INSTANCESERVER = null;
        INSTANCECLIENT = null;
    }

    public static Set<String> getDataIDs() {
        if (dataIds.size() != dataMap.size()) {
            for (Class<? extends PlayerData> type : dataMap) {
                try {
                    PlayerData toAdd = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                    dataIds.add(toAdd.getIdentifier());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dataIds;
    }

    public static File getFileForUUID(String uuid, String fileName) {
        MinecraftServer server = ThutCore.proxy.getServer();
        Path path = server.m_129843_(new LevelResource("thutcore"));
        path = path.resolve(uuid);
        File dir = path.toFile();
        File file = (path = path.resolve(fileName + ".dat")).toFile();
        if (!file.exists()) {
            dir.mkdirs();
        }
        return file;
    }

    public static PlayerDataHandler getInstance() {
        if (ThutCore.proxy.isClientSide()) {
            return INSTANCECLIENT != null ? INSTANCECLIENT : (INSTANCECLIENT = new PlayerDataHandler());
        }
        return INSTANCESERVER != null ? INSTANCESERVER : (INSTANCESERVER = new PlayerDataHandler());
    }

    public static void register(Class<? extends PlayerData> data) {
        dataMap.add(data);
    }

    public static void saveCustomData(Player player) {
        PlayerDataHandler.saveCustomData(player.m_20149_());
    }

    public static void saveCustomData(String cachedUniqueIdString) {
        PlayerDataHandler.getInstance().save(cachedUniqueIdString, "misc");
    }

    public PlayerDataHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void cleanupOfflineData(LevelEvent.Save event) {
        HashSet toUnload = Sets.newHashSet();
        MinecraftServer server = ThutCore.proxy.getServer();
        for (String uuid : this.data.keySet()) {
            ServerPlayer player = server.m_6846_().m_11259_(UUID.fromString(uuid));
            if (player != null) continue;
            toUnload.add(uuid);
        }
        for (String s : toUnload) {
            this.save(s);
            this.data.remove(s);
        }
    }

    public PlayerDataManager getPlayerData(Player player) {
        return this.getPlayerData(player.m_20149_());
    }

    public PlayerDataManager getPlayerData(String uuid) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager == null) {
            manager = this.load(uuid);
        }
        return manager;
    }

    public PlayerDataManager getPlayerData(UUID uniqueID) {
        return this.getPlayerData(uniqueID.toString());
    }

    public PlayerDataManager load(String uuid) {
        PlayerDataManager manager = new PlayerDataManager(uuid);
        if (this == INSTANCESERVER) {
            for (PlayerData data : manager.data.values()) {
                String fileName = data.dataFileName();
                File file = null;
                try {
                    file = PlayerDataHandler.getFileForUUID(uuid, fileName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (file == null || !file.exists()) continue;
                try {
                    FileInputStream fileinputstream = new FileInputStream(file);
                    CompoundTag CompoundNBT = NbtIo.m_128939_((InputStream)fileinputstream);
                    fileinputstream.close();
                    data.readFromNBT(CompoundNBT.m_128469_("Data"));
                }
                catch (Exception e) {
                    ThutCore.LOGGER.error("Warning, Data for {} [} was corrupted while trying to load!", (Object)uuid, (Object)fileName, (Object)e);
                    e.printStackTrace();
                }
            }
        }
        this.data.put(uuid, manager);
        return manager;
    }

    public void save(String uuid) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager != null && this == INSTANCESERVER) {
            for (PlayerData data : manager.data.values()) {
                String fileName = data.dataFileName();
                File file = PlayerDataHandler.getFileForUUID(uuid, fileName);
                if (file == null) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                data.writeToNBT(CompoundNBT);
                CompoundTag CompoundNBT1 = new CompoundTag();
                CompoundNBT1.m_128365_("Data", (Tag)CompoundNBT);
                try {
                    FileOutputStream fileoutputstream = new FileOutputStream(file);
                    NbtIo.m_128947_((CompoundTag)CompoundNBT1, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
                catch (Exception e) {
                    ThutCore.LOGGER.error("Warning, Data for {} [} was corrupted while trying to save!", (Object)uuid, (Object)fileName, (Object)e);
                    e.printStackTrace();
                }
            }
        }
    }

    public void save(String uuid, String dataType) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager != null && this == INSTANCESERVER) {
            for (PlayerData data : manager.data.values()) {
                String fileName;
                File file;
                if (!data.getIdentifier().equals(dataType) || (file = PlayerDataHandler.getFileForUUID(uuid, fileName = data.dataFileName())) == null) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                data.writeToNBT(CompoundNBT);
                CompoundTag CompoundNBT1 = new CompoundTag();
                CompoundNBT1.m_128365_("Data", (Tag)CompoundNBT);
                try {
                    FileOutputStream fileoutputstream = new FileOutputStream(file);
                    NbtIo.m_128947_((CompoundTag)CompoundNBT1, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
                catch (Exception e) {
                    ThutCore.LOGGER.error("Warning, Data for {} [} was corrupted while trying to save!", (Object)uuid, (Object)fileName, (Object)e);
                    e.printStackTrace();
                }
            }
        }
    }

    public static abstract class PlayerData
    implements IPlayerData {
        @Override
        public void readSync(ByteBuf data) {
        }

        @Override
        public void writeSync(ByteBuf data) {
        }
    }

    public static class PlayerDataManager {
        public Map<Class<? extends PlayerData>, PlayerData> data = Maps.newHashMap();
        Map<String, PlayerData> idMap = Maps.newHashMap();
        final String uuid;

        public PlayerDataManager(String uuid) {
            this.uuid = uuid;
            for (Class<? extends PlayerData> type : dataMap) {
                try {
                    PlayerData toAdd = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.data.put(type, toAdd);
                    this.idMap.put(toAdd.getIdentifier(), toAdd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public <T extends PlayerData> T getData(Class<T> type) {
            return (T)this.data.get(type);
        }

        public PlayerData getData(String dataType) {
            return this.idMap.get(dataType);
        }
    }

    private static interface IPlayerData {
        public String dataFileName();

        public String getIdentifier();

        public void readFromNBT(CompoundTag var1);

        public void readSync(ByteBuf var1);

        public boolean shouldSync();

        public void writeSync(ByteBuf var1);

        public void writeToNBT(CompoundTag var1);

        default public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        }

        default public void onPlayerUpdate(LivingEvent.LivingTickEvent event) {
        }

        default public boolean canTick() {
            return false;
        }
    }
}

