/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import thut.core.common.ThutCore;
import thut.core.common.network.nbtpacket.NBTPacket;
import thut.core.common.network.nbtpacket.PacketAssembly;
import thut.lib.RegHelper;

public class CapabilitySync
extends NBTPacket {
    private static Method GETMOBCAPS;
    private static Field CAPWRITERS;
    private static Field CAPNAMES;
    public static final Set<String> TO_SYNC;
    public static final PacketAssembly<CapabilitySync> ASSEMBLER;

    private static CapabilitySync makePacket(Entity entity, Set<String> toSync) {
        if (entity.m_9236_().f_46443_) {
            ThutCore.LOGGER.error("Packet sent on wrong side!", (Throwable)new IllegalArgumentException());
            return null;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("id", entity.m_19879_());
        CompoundTag nbt = new CompoundTag();
        try {
            CapabilityDispatcher disp = (CapabilityDispatcher)GETMOBCAPS.invoke((Object)entity, new Object[0]);
            INBTSerializable[] writers = (INBTSerializable[])CAPWRITERS.get(disp);
            String[] names = (String[])CAPNAMES.get(disp);
            for (int x = 0; x < writers.length; ++x) {
                if (!toSync.contains(names[x])) continue;
                nbt.m_128365_(names[x], writers[x].serializeNBT());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (nbt.m_128456_()) {
            return null;
        }
        tag.m_128365_("tag", (Tag)nbt);
        return new CapabilitySync(tag);
    }

    public static void sendUpdate(Entity entity) {
        CapabilitySync.sendUpdate(entity, TO_SYNC);
    }

    public static void sendUpdate(Entity entity, Set<String> toSync) {
        CapabilitySync message = CapabilitySync.makePacket(entity, toSync);
        if (message != null) {
            ASSEMBLER.sendToTracking(message, entity);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ASSEMBLER.sendTo(message, player);
            }
        }
    }

    private static void onJoinWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.getLevel() instanceof ServerLevel) {
            CapabilitySync.sendUpdate(event.getEntity());
        }
    }

    private static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CapabilitySync message = CapabilitySync.makePacket(event.getTarget(), TO_SYNC);
            if (message != null) {
                ASSEMBLER.sendTo(message, player2);
            }
        }
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(CapabilitySync::onStartTracking);
        MinecraftForge.EVENT_BUS.addListener(CapabilitySync::onJoinWorld);
    }

    private static void readMob(Entity mob, CompoundTag tag) {
        try {
            CapabilityDispatcher disp = (CapabilityDispatcher)GETMOBCAPS.invoke((Object)mob, new Object[0]);
            if (disp != null) {
                disp.deserializeNBT(tag);
            }
        }
        catch (Exception e) {
            ThutCore.LOGGER.error("Error Loading Caps for: {}", (Object)RegHelper.getKey(mob));
            ThutCore.LOGGER.error((Object)e);
        }
        mob.m_6210_();
    }

    public CapabilitySync() {
    }

    public CapabilitySync(CompoundTag tag) {
        super(tag);
    }

    public CapabilitySync(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void onCompleteClient() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        int id = this.getTag().m_128451_("id");
        Entity mob = world.m_6815_(id);
        if (mob != null) {
            CapabilitySync.readMob(mob, this.getTag().m_128469_("tag"));
        }
    }

    static {
        try {
            GETMOBCAPS = CapabilityProvider.class.getDeclaredMethod("getCapabilities", new Class[0]);
            GETMOBCAPS.setAccessible(true);
            CAPWRITERS = CapabilityDispatcher.class.getDeclaredField("writers");
            CAPWRITERS.setAccessible(true);
            CAPNAMES = CapabilityDispatcher.class.getDeclaredField("names");
            CAPNAMES.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TO_SYNC = Sets.newHashSet();
        ASSEMBLER = PacketAssembly.registerAssembler(CapabilitySync.class, CapabilitySync::new, ThutCore.packets);
    }
}

