/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import thut.api.item.ItemList;
import thut.core.common.ThutCore;
import thut.core.common.network.nbtpacket.NBTPacket;
import thut.core.common.network.nbtpacket.PacketAssembly;
import thut.lib.RegHelper;

public class EntityUpdate
extends NBTPacket {
    public static final ResourceLocation NOREAD = new ResourceLocation("thutcore", "additional_only_server");
    private static Set<EntityType<?>> errorSet = Sets.newHashSet();
    public static Method GETMOBCAPS;
    public static final PacketAssembly<EntityUpdate> ASSEMBLER;

    public static void sendEntityUpdate(Entity entity) {
        if (entity.m_9236_().f_46443_) {
            ThutCore.LOGGER.error("Packet sent on wrong side!", (Throwable)new IllegalArgumentException());
            return;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("id", entity.m_19879_());
        CompoundTag mobtag = new CompoundTag();
        entity.m_20240_(mobtag);
        tag.m_128365_("tag", (Tag)mobtag);
        EntityUpdate message = new EntityUpdate(tag);
        ASSEMBLER.sendToTracking(message, entity);
    }

    public static void readMob(Entity mob, CompoundTag tag) {
        if (!(!(mob.m_9236_() instanceof ServerLevel) && ItemList.is(NOREAD, mob) || errorSet.contains(mob.m_6095_()))) {
            try {
                mob.m_20258_(tag);
                mob.m_6210_();
                return;
            }
            catch (Exception e) {
                ThutCore.LOGGER.error("Error loading " + RegHelper.getKey(mob) + " on client side!");
                errorSet.add(mob.m_6095_());
            }
        }
        if (tag.m_128425_("CustomName", 8)) {
            String s = tag.m_128461_("CustomName");
            try {
                mob.m_6593_((Component)Component.Serializer.m_130701_((String)s));
            }
            catch (Exception exception) {
                ThutCore.LOGGER.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
            }
        }
        if (tag.m_128425_("ForgeCaps", 10)) {
            try {
                CapabilityDispatcher disp = (CapabilityDispatcher)GETMOBCAPS.invoke((Object)mob, new Object[0]);
                if (disp != null) {
                    disp.deserializeNBT(tag.m_128469_("ForgeCaps"));
                }
            }
            catch (Exception e) {
                ThutCore.LOGGER.error("Error Loading Caps for: {}", (Object)RegHelper.getKey(mob));
                ThutCore.LOGGER.error((Object)e);
            }
        }
        mob.m_6210_();
    }

    public EntityUpdate() {
    }

    public EntityUpdate(CompoundTag tag) {
        super(tag);
    }

    public EntityUpdate(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void onCompleteClient() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        int id = this.getTag().m_128451_("id");
        Entity mob = world.m_6815_(id);
        if (mob != null) {
            EntityUpdate.readMob(mob, this.getTag().m_128469_("tag"));
        }
    }

    static {
        try {
            GETMOBCAPS = CapabilityProvider.class.getDeclaredMethod("getCapabilities", new Class[0]);
            GETMOBCAPS.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ASSEMBLER = PacketAssembly.registerAssembler(EntityUpdate.class, EntityUpdate::new, ThutCore.packets);
    }
}

