/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import thut.api.Tracker;
import thut.core.common.ThutCore;
import thut.core.common.network.nbtpacket.NBTPacket;
import thut.core.common.network.nbtpacket.PacketAssembly;

public class GeneralUpdate
extends NBTPacket {
    public static final PacketAssembly<GeneralUpdate> ASSEMBLER = PacketAssembly.registerAssembler(GeneralUpdate.class, GeneralUpdate::new, ThutCore.packets);

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(GeneralUpdate::onTick);
        MinecraftForge.EVENT_BUS.addListener(GeneralUpdate::onLogin);
    }

    private static void onTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (event.player.f_19797_ % 1000 == 0 && event.phase == TickEvent.Phase.END) {
                GeneralUpdate.sendUpdate(player2);
            }
        }
    }

    private static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            GeneralUpdate.sendUpdate(player2);
        }
    }

    private static void sendUpdate(ServerPlayer player) {
        CompoundTag tag = Tracker.write();
        ASSEMBLER.sendTo(new GeneralUpdate(tag), player);
    }

    public GeneralUpdate() {
    }

    public GeneralUpdate(CompoundTag tag) {
        super(tag);
    }

    public GeneralUpdate(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    protected void onCompleteClient() {
        Tracker.read(this.getTag());
    }
}

