/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import thut.core.common.network.Packet;
import thut.core.common.network.PacketAssembly;

public abstract class NBTPacket
extends Packet {
    protected CompoundTag tag = new CompoundTag();
    final PacketAssembly<?> assembler = PacketAssembly.ASSEMBLERS.get(this.getClass());

    public NBTPacket() {
    }

    public NBTPacket(CompoundTag tag) {
        this();
        this.tag = tag;
    }

    public NBTPacket(FriendlyByteBuf buffer) {
        this();
        this.tag = buffer.m_130260_();
        if (this.assembler != null) {
            this.assembler.onRead(this.getTag());
        }
    }

    @Override
    public final void write(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.getTag());
    }

    public final void setTag(CompoundTag tag) {
        this.tag = tag;
    }

    @Override
    public final void handleServer(ServerPlayer player) {
        CompoundTag complete = this.assembler.onRead(this.getTag());
        if (complete != null) {
            this.tag = complete;
            if (complete != null) {
                this.onCompleteServer(player);
            }
        }
    }

    @Override
    public final void handleClient() {
        CompoundTag complete = this.assembler.onRead(this.getTag());
        if (complete != null) {
            this.tag = complete;
            this.onCompleteClient();
        }
    }

    protected void onCompleteClient() {
    }

    protected void onCompleteServer(ServerPlayer player) {
    }

    public final CompoundTag getTag() {
        return this.tag;
    }
}

