/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;
import thut.core.common.ThutCore;
import thut.core.common.network.NBTPacket;
import thut.core.common.network.PacketHandler;

public final class PacketAssembly<T extends NBTPacket> {
    public static final Map<Class<? extends NBTPacket>, PacketAssembly<?>> ASSEMBLERS = new HashMap();
    private final HashMap<UUID, byte[]> buffer = new HashMap();
    private byte[] serverBuf = null;
    private static final int bufSize = 20480;
    private final Factory<T> factory;
    private final PacketHandler handler;

    public static <K extends NBTPacket> PacketAssembly<K> registerAssembler(Class<K> clazz, Factory<K> factory, PacketHandler handler) {
        PacketAssembly<K> assembler = new PacketAssembly<K>(factory, handler);
        ASSEMBLERS.put(clazz, assembler);
        return assembler;
    }

    public PacketAssembly(Factory<T> factory, PacketHandler handler) {
        this.factory = factory;
        this.handler = handler;
    }

    public void sendTo(T packet, ServerPlayer player) {
        this.sendTo(packet, PacketDistributor.PLAYER.with(() -> player));
    }

    public void sendToTracking(T message, Entity entity) {
        this.sendTo(message, PacketDistributor.TRACKING_ENTITY.with(() -> entity));
    }

    public void sendTo(T packet, PacketDistributor.PacketTarget target) {
        UUID id = UUID.randomUUID();
        List<CompoundTag> tags = this.splitPacket(id, ((NBTPacket)packet).getTag());
        for (CompoundTag tag : tags) {
            NBTPacket newPacket = (NBTPacket)this.factory.create();
            newPacket.setTag(tag);
            this.handler.channel().send(target, (Object)newPacket);
        }
    }

    public void sendToServer(T packet) {
        UUID id = UUID.randomUUID();
        List<CompoundTag> tags = this.splitPacket(id, ((NBTPacket)packet).getTag());
        for (CompoundTag tag : tags) {
            NBTPacket newPacket = (NBTPacket)this.factory.create();
            newPacket.setTag(tag);
            this.handler.channel().sendToServer((Object)newPacket);
        }
    }

    protected CompoundTag onRead(CompoundTag tag) {
        UUID id = tag.m_128342_("id");
        CompoundTag made = this.assemblePacket(id, tag);
        return made;
    }

    private List<CompoundTag> splitPacket(UUID id, CompoundTag tags) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            NbtIo.m_128947_((CompoundTag)tags, (OutputStream)baos);
            baos.flush();
            byte[] data = baos.toByteArray();
            baos.close();
            int req = Mth.m_14167_((float)((float)data.length / 20480.0f));
            ArrayList<CompoundTag> pkts = new ArrayList<CompoundTag>(req);
            for (int p = 0; p < req; ++p) {
                int idx = p * 20480;
                int s = Math.min(data.length - idx, 20480);
                CompoundTag container = new CompoundTag();
                byte[] part = new byte[s];
                System.arraycopy(data, idx, part, 0, s);
                container.m_128405_("size", data.length);
                container.m_128405_("start", idx);
                container.m_128379_("end", p == req - 1);
                container.m_128365_("data", (Tag)new ByteArrayTag(part));
                container.m_128362_("id", id);
                pkts.add(container);
            }
            return pkts;
        }
        catch (Exception e) {
            ThutCore.LOGGER.error("Unable to split build packet!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private CompoundTag assemblePacket(UUID id, CompoundTag tags) {
        int size = tags.m_128451_("size");
        int index = tags.m_128451_("start");
        boolean end = tags.m_128471_("end");
        byte[] data = tags.m_128463_("data");
        byte[] tmp = this.getBuffer(id);
        if (tmp == null) {
            tmp = new byte[size];
            this.setBuffer(id, tmp);
        } else if (tmp.length != size) {
            ThutCore.LOGGER.error("Unexpected change in ThutCore packet byte length: " + size + " > " + tmp.length);
            this.clearBuffer(id);
            return null;
        }
        System.arraycopy(data, 0, tmp, index, data.length);
        if (end) {
            this.clearBuffer(id);
            try {
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(tmp))));
                CompoundTag tag = NbtIo.m_128934_((DataInput)dis, (NbtAccounter)NbtAccounter.f_128917_);
                dis.close();
                return tag;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to assemble BQ packet", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBuffer(UUID id) {
        if (id == null) {
            return this.serverBuf;
        }
        HashMap<UUID, byte[]> hashMap = this.buffer;
        synchronized (hashMap) {
            return this.buffer.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBuffer(UUID id, byte[] value) {
        if (id == null) {
            this.serverBuf = value;
        } else {
            HashMap<UUID, byte[]> hashMap = this.buffer;
            synchronized (hashMap) {
                if (this.buffer.containsKey(id)) {
                    throw new IllegalStateException("Attepted to start more than one ThutCore packet assembly for UUID " + id.toString());
                }
                this.buffer.put(id, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBuffer(UUID id) {
        if (id == null) {
            this.serverBuf = null;
        } else {
            HashMap<UUID, byte[]> hashMap = this.buffer;
            synchronized (hashMap) {
                this.buffer.remove(id);
            }
        }
    }

    public static interface Factory<T> {
        public T create();
    }
}

