/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import com.google.common.base.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import thut.core.common.network.Packet;

public class PacketHandler {
    private final SimpleChannel INSTANCE;
    private int ID = 0;

    private static boolean canClientConnect(String versionClient, String versionServer) {
        return versionClient.equals(versionServer);
    }

    private static boolean canServerConnect(String versionClient, String versionServer) {
        return versionClient.equals(versionServer);
    }

    public PacketHandler(ResourceLocation channel, String version) {
        this.INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)channel, () -> version, s -> PacketHandler.canClientConnect(version, s), s -> PacketHandler.canServerConnect(s, version));
    }

    public SimpleChannel channel() {
        return this.INSTANCE;
    }

    private int nextID() {
        return this.ID++;
    }

    public <MSG extends Packet> void registerMessage(Class<MSG> clazz, Function<FriendlyByteBuf, MSG> decoder) {
        this.INSTANCE.registerMessage(this.nextID(), clazz, Packet::write, decoder, Packet::handle);
    }

    public void sendTo(Packet message, ServerPlayer target) {
        this.channel().send(PacketDistributor.PLAYER.with(() -> target), (Object)message);
    }

    public void sendToServer(Packet message) {
        this.channel().sendToServer((Object)message);
    }

    public void sendToTracking(Packet message, Entity tracked) {
        this.channel().send(PacketDistributor.TRACKING_ENTITY.with(() -> tracked), (Object)message);
    }

    public void sendToTracking(Packet message, ChunkAccess tracked) {
        if (tracked instanceof LevelChunk) {
            this.channel().send(PacketDistributor.TRACKING_CHUNK.with(() -> (LevelChunk)tracked), (Object)message);
        }
    }
}

