/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import thut.api.entity.multipart.GenericPartEntity;
import thut.core.common.network.Packet;

public class PacketPartInteract
extends Packet {
    int entityId;
    boolean sneaking;
    private Vec3 hitVec;
    private ServerboundInteractPacket.ActionType action;
    private InteractionHand hand;
    private String id;

    public PacketPartInteract() {
        super(null);
    }

    public PacketPartInteract(String name, Entity entityIn, boolean sneak) {
        this.entityId = entityIn.m_19879_();
        this.action = ServerboundInteractPacket.ActionType.ATTACK;
        this.sneaking = sneak;
        this.id = name;
    }

    public PacketPartInteract(String name, Entity entityIn, InteractionHand handIn, boolean sneak) {
        this.entityId = entityIn.m_19879_();
        this.action = ServerboundInteractPacket.ActionType.INTERACT;
        this.hand = handIn;
        this.sneaking = sneak;
        this.id = name;
    }

    public PacketPartInteract(String name, Entity entityIn, InteractionHand handIn, Vec3 hitVecIn, boolean sneak) {
        this.entityId = entityIn.m_19879_();
        this.action = ServerboundInteractPacket.ActionType.INTERACT_AT;
        this.hand = handIn;
        this.hitVec = hitVecIn;
        this.sneaking = sneak;
        this.id = name;
    }

    public PacketPartInteract(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.action = (ServerboundInteractPacket.ActionType)buf.m_130066_(ServerboundInteractPacket.ActionType.class);
        if (this.action == ServerboundInteractPacket.ActionType.INTERACT_AT) {
            this.hitVec = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
        }
        if (this.action == ServerboundInteractPacket.ActionType.INTERACT || this.action == ServerboundInteractPacket.ActionType.INTERACT_AT) {
            this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        }
        this.sneaking = buf.readBoolean();
        this.id = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130068_((Enum)this.action);
        if (this.action == ServerboundInteractPacket.ActionType.INTERACT_AT) {
            buf.writeFloat((float)this.hitVec.f_82479_);
            buf.writeFloat((float)this.hitVec.f_82480_);
            buf.writeFloat((float)this.hitVec.f_82481_);
        }
        if (this.action == ServerboundInteractPacket.ActionType.INTERACT || this.action == ServerboundInteractPacket.ActionType.INTERACT_AT) {
            buf.m_130068_((Enum)this.hand);
        }
        buf.writeBoolean(this.sneaking);
        buf.m_130070_(this.id);
    }

    @Nullable
    public Entity getEntityFromWorld(Level worldIn) {
        return worldIn.m_6815_(this.entityId);
    }

    public ServerboundInteractPacket.ActionType getAction() {
        return this.action;
    }

    @Nullable
    public InteractionHand getHand() {
        return this.hand;
    }

    public Vec3 getHitVec() {
        return this.hitVec;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public void handleServer(ServerPlayer player) {
        ServerLevel serverworld = player.m_9236_();
        Entity entity = this.getEntityFromWorld((Level)serverworld);
        player.m_9243_();
        player.m_20260_(this.isSneaking());
        if (entity != null) {
            if (entity.isMultipartEntity()) {
                for (PartEntity p : entity.getParts()) {
                    if (!(p instanceof GenericPartEntity)) continue;
                    GenericPartEntity p2 = (GenericPartEntity)p;
                    if (!p2.f_19848_.equals(this.id)) continue;
                    entity = p;
                    break;
                }
            }
            double d0 = 36.0;
            if (player.m_20280_(entity) < 36.0) {
                InteractionHand hand = this.getHand();
                ItemStack itemstack = hand != null ? player.m_21120_(hand).m_41777_() : ItemStack.f_41583_;
                Optional<Object> optional = Optional.empty();
                if (this.getAction() == ServerboundInteractPacket.ActionType.INTERACT) {
                    optional = Optional.of(player.m_36157_(entity, hand));
                } else if (this.getAction() == ServerboundInteractPacket.ActionType.INTERACT_AT) {
                    if (ForgeHooks.onInteractEntityAt((Player)player, (Entity)entity, (Vec3)this.getHitVec(), (InteractionHand)hand) != null) {
                        return;
                    }
                    optional = Optional.of(entity.m_7111_((Player)player, this.getHitVec(), hand));
                } else if (this.getAction() == ServerboundInteractPacket.ActionType.ATTACK) {
                    player.m_5706_(entity);
                }
                if (optional.isPresent() && ((InteractionResult)optional.get()).m_19077_()) {
                    CriteriaTriggers.f_10565_.m_61494_(player, itemstack, entity);
                    if (((InteractionResult)optional.get()).m_19080_()) {
                        player.m_21011_(hand, true);
                    }
                }
            }
        }
    }
}

