/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import thut.api.entity.multipart.GenericPartEntity;
import thut.api.entity.multipart.IMultpart;
import thut.core.common.ThutCore;
import thut.core.common.network.nbtpacket.NBTPacket;
import thut.core.common.network.nbtpacket.PacketAssembly;

public class PartSync
extends NBTPacket {
    public static final PacketAssembly<PartSync> ASSEMBLER = PacketAssembly.registerAssembler(PartSync.class, PartSync::new, ThutCore.packets);

    public static void sendUpdate(Entity mob) {
        if (!(mob.f_19853_ instanceof ServerLevel)) {
            return;
        }
        if (!(mob instanceof IMultpart)) {
            return;
        }
        PartSync.sendUpdate(mob, !mob.m_6084_() || !mob.isAddedToWorld());
    }

    public static void sendUpdate(Entity mob, boolean remove) {
        CompoundTag tag = PartSync.makePacket(mob, remove);
        if (tag != null) {
            ASSEMBLER.sendToTracking(new PartSync(tag), mob);
        }
    }

    private static CompoundTag makePacket(Entity mob, boolean remove) {
        Level level = mob.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!(mob instanceof IMultpart)) {
            return null;
        }
        IMultpart parts = (IMultpart)mob;
        if (parts.getHolder().allParts().isEmpty()) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("i", mob.m_19879_());
        tag.m_128379_("r", remove);
        if (remove) {
            int[] arr = new int[parts.getHolder().allParts().size()];
            int i = 0;
            for (GenericPartEntity part : parts.getHolder().allParts()) {
                arr[i++] = part.m_19879_();
            }
            tag.m_128385_("p", arr);
            return tag;
        }
        int[] arr = new int[parts.getHolder().getParts().length];
        Int2ObjectMap partMap = (Int2ObjectMap)ObfuscationReflectionHelper.getPrivateValue(ServerLevel.class, (Object)level2, (String)"f_143247_");
        for (GenericPartEntity part : parts.getHolder().allParts()) {
            partMap.remove(part.m_19879_());
        }
        for (int i = 0; i < arr.length; ++i) {
            GenericPartEntity part;
            part = parts.getHolder().getParts()[i];
            arr[i] = part.m_19879_();
            partMap.put(arr[i], (Object)part);
        }
        tag.m_128385_("p", arr);
        return tag;
    }

    private static void onStopTracking(PlayerEvent.StopTracking event) {
        Player player;
        CompoundTag tag = PartSync.makePacket(event.getTarget(), true);
        if (tag != null && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ASSEMBLER.sendTo(new PartSync(tag), player2);
        }
    }

    private static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player;
        CompoundTag tag = PartSync.makePacket(event.getTarget(), false);
        if (tag != null && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ASSEMBLER.sendTo(new PartSync(tag), player2);
        }
    }

    public PartSync() {
    }

    public PartSync(CompoundTag tag) {
        super(tag);
    }

    public PartSync(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    protected void onCompleteClient() {
        int id = this.getTag().m_128451_("i");
        int[] arr = this.getTag().m_128465_("p");
        boolean remove = this.getTag().m_128471_("r");
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (remove) {
            Int2ObjectMap partMap = (Int2ObjectMap)ObfuscationReflectionHelper.getPrivateValue(ClientLevel.class, (Object)world, (String)"partEntities");
            ArrayList<PartEntity> list = new ArrayList<PartEntity>();
            for (int i : arr) {
                list.add((PartEntity)partMap.remove(i));
            }
            partMap.clear();
            return;
        }
        Entity mob = world.m_6815_(id);
        if (!(mob instanceof IMultpart)) {
            return;
        }
        IMultpart parts = (IMultpart)mob;
        Int2ObjectMap partMap = (Int2ObjectMap)ObfuscationReflectionHelper.getPrivateValue(ClientLevel.class, (Object)world, (String)"partEntities");
        for (GenericPartEntity part : parts.getHolder().allParts()) {
            partMap.remove(part.m_19879_());
        }
        if (remove) {
            return;
        }
        for (int i = 0; i < Math.min(parts.getHolder().getParts().length, arr.length); ++i) {
            GenericPartEntity part;
            part = parts.getHolder().getParts()[i];
            part.m_20234_(arr[i]);
            partMap.put(arr[i], (Object)part);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(PartSync::onStopTracking);
        MinecraftForge.EVENT_BUS.addListener(PartSync::onStartTracking);
    }
}

