/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import thut.api.ThutCaps;
import thut.api.terrain.CapabilityTerrain;
import thut.core.common.ThutCore;
import thut.core.common.network.nbtpacket.NBTPacket;
import thut.core.common.network.nbtpacket.PacketAssembly;

public class TerrainUpdate
extends NBTPacket {
    public static final PacketAssembly<TerrainUpdate> ASSEMBLER = PacketAssembly.registerAssembler(TerrainUpdate.class, TerrainUpdate::new, ThutCore.packets);

    public static void sendTerrainToClient(ChunkPos pos, ServerPlayer player) {
        ServerLevel world = (ServerLevel)player.f_19853_;
        if (!world.m_201916_(pos)) {
            return;
        }
        CapabilityTerrain.ITerrainProvider provider = (CapabilityTerrain.ITerrainProvider)world.m_6325_(pos.f_45578_, pos.f_45579_).getCapability(ThutCaps.TERRAIN_PROVIDER, null).orElse(null);
        CompoundTag terrainData = (CompoundTag)provider.serializeNBT();
        terrainData.m_128405_("c_x", pos.f_45578_);
        terrainData.m_128405_("c_z", pos.f_45579_);
        TerrainUpdate message = new TerrainUpdate(terrainData);
        ASSEMBLER.sendTo(message, player);
    }

    public TerrainUpdate() {
    }

    public TerrainUpdate(CompoundTag nbt) {
        super(nbt);
    }

    public TerrainUpdate(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void onCompleteClient() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        CompoundTag nbt = this.tag;
        LevelChunk chunk = world.m_6325_(nbt.m_128451_("c_x"), nbt.m_128451_("c_z"));
        CapabilityTerrain.ITerrainProvider terrain = (CapabilityTerrain.ITerrainProvider)chunk.getCapability(ThutCaps.TERRAIN_PROVIDER, null).orElse(null);
        terrain.deserializeNBT((Tag)this.tag);
    }
}

