/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import thut.core.common.ThutCore;
import thut.core.common.network.nbtpacket.NBTPacket;
import thut.core.common.network.nbtpacket.PacketAssembly;

public class TileUpdate
extends NBTPacket {
    public static final PacketAssembly<TileUpdate> ASSEMBLER = PacketAssembly.registerAssembler(TileUpdate.class, TileUpdate::new, ThutCore.packets);

    public static void sendUpdate(BlockEntity tile) {
        LevelChunk lchunk;
        if (tile.m_58904_().f_46443_) {
            ThutCore.LOGGER.error("Packet sent on wrong side!");
            return;
        }
        CompoundTag tag = new CompoundTag();
        CompoundTag pos = NbtUtils.m_129224_((BlockPos)tile.m_58899_());
        tag.m_128365_("pos", (Tag)pos);
        CompoundTag mobtag = tile.m_5995_();
        tag.m_128365_("tag", (Tag)mobtag);
        TileUpdate message = new TileUpdate(tag);
        ChunkAccess chunk = tile.m_58904_().m_46865_(tile.m_58899_());
        if (chunk instanceof LevelChunk && (lchunk = (LevelChunk)chunk).m_62953_().m_7726_() instanceof ServerChunkCache) {
            ASSEMBLER.sendTo(message, PacketDistributor.TRACKING_CHUNK.with(() -> lchunk));
        }
    }

    public TileUpdate() {
    }

    public TileUpdate(CompoundTag tag) {
        this.tag = tag;
    }

    public TileUpdate(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void onCompleteClient() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)this.tag.m_128469_("pos"));
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null) {
            tile.handleUpdateTag(this.tag.m_128469_("tag"));
        }
    }
}

