/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network.bigpacket;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import thut.core.common.network.Packet;
import thut.core.common.network.bigpacket.PacketAssembly;

public abstract class BigPacket
extends Packet {
    protected CompoundTag tag = new CompoundTag();
    protected byte[] data = null;
    final PacketAssembly<?> assembler = PacketAssembly.ASSEMBLERS.get(this.getClass());

    public BigPacket() {
    }

    public BigPacket(CompoundTag tag) {
        this();
        this.tag = tag;
    }

    public BigPacket(FriendlyByteBuf buffer) {
        this();
        this.tag = buffer.m_130260_();
        if (this.assembler != null) {
            this.assembler.onRead(this.getTag());
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public final void write(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.getTag());
    }

    public final void setTag(CompoundTag tag) {
        this.tag = tag;
    }

    @Override
    public final void handleServer(ServerPlayer player) {
        byte[] complete = this.assembler.onRead(this.getTag());
        if (complete != null) {
            this.setData(complete);
            this.onCompleteServer(player);
        }
    }

    @Override
    public final void handleClient() {
        byte[] complete = this.assembler.onRead(this.getTag());
        if (complete != null) {
            this.setData(complete);
            this.onCompleteClient();
        }
    }

    protected void onCompleteClient() {
    }

    protected void onCompleteServer(ServerPlayer player) {
    }

    public final CompoundTag getTag() {
        return this.tag;
    }
}

