/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.terrain;

import java.util.Collection;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import thut.api.ThutCaps;
import thut.api.terrain.ITerrainAffected;
import thut.api.terrain.TerrainEffectEvent;
import thut.api.terrain.TerrainManager;
import thut.api.terrain.TerrainSegment;

public class CapabilityTerrainAffected {
    private static final ResourceLocation TERRAINEFFECTCAP = new ResourceLocation("thutcore", "terrain_effects");

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(CapabilityTerrainAffected::EntityUpdate);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CapabilityTerrainAffected::onEntityCapabilityAttach);
    }

    private static void EntityUpdate(LivingEvent.LivingTickEvent evt) {
        ITerrainAffected effects = (ITerrainAffected)evt.getEntity().getCapability(ThutCaps.TERRAIN_AFFECTED, null).orElse(null);
        if (effects != null) {
            effects.onTerrainTick();
        }
    }

    private static void onEntityCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        LivingEntity living;
        block3: {
            block2: {
                Object object = event.getObject();
                if (!(object instanceof LivingEntity)) break block2;
                living = (LivingEntity)object;
                if (!event.getCapabilities().containsKey(TERRAINEFFECTCAP)) break block3;
            }
            return;
        }
        DefaultAffected effects = new DefaultAffected();
        effects.attach(living);
        event.addCapability(TERRAINEFFECTCAP, (ICapabilityProvider)effects);
    }

    public static class DefaultAffected
    implements ITerrainAffected,
    ICapabilityProvider {
        private final LazyOptional<ITerrainAffected> holder = LazyOptional.of(() -> this);
        private LivingEntity theMob;
        private TerrainSegment terrain;
        private Collection<TerrainSegment.ITerrainEffect> effects;

        @Override
        public void attach(LivingEntity mob) {
            this.theMob = mob;
        }

        @Override
        public LivingEntity getAttached() {
            return this.theMob;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            return ThutCaps.TERRAIN_AFFECTED.orEmpty(capability, this.holder);
        }

        public void onTerrainEntry(TerrainSegment entered) {
            if (entered == this.terrain || this.theMob == null) {
                return;
            }
            this.terrain = entered;
            this.effects = this.terrain.getEffects();
            for (TerrainSegment.ITerrainEffect effect : this.effects) {
                TerrainEffectEvent event = new TerrainEffectEvent(this.theMob, effect.getIdentifier(), true);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) continue;
                effect.doEffect(this.theMob, true);
            }
        }

        @Override
        public void onTerrainTick() {
            if (this.theMob == null) {
                return;
            }
            TerrainSegment current = TerrainManager.getInstance().getTerrainForEntity((Entity)this.theMob);
            if (current != this.terrain) {
                this.onTerrainEntry(current);
                return;
            }
            if (this.effects == null) {
                return;
            }
            for (TerrainSegment.ITerrainEffect effect : this.effects) {
                TerrainEffectEvent event = new TerrainEffectEvent(this.theMob, effect.getIdentifier(), false);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) continue;
                effect.doEffect(this.theMob, false);
            }
        }
    }
}

