/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.terrain;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import thut.api.terrain.BiomeType;
import thut.api.terrain.TerrainSegment;
import thut.core.common.terrain.ConfigTerrainChecker;
import thut.lib.RegHelper;

public class ConfigTerrainBuilder {
    private static void addToList(List<Predicate<BlockState>> list, String ... conts) {
        if (conts == null) {
            return;
        }
        if (conts.length < 1) {
            return;
        }
        for (String s : conts) {
            Predicate<BlockState> b = ConfigTerrainBuilder.getState(s);
            if (b == null) continue;
            list.add(b);
        }
    }

    private static void generateConfigTerrain(String[] blocks, BiomeType subbiome) {
        ArrayList list = Lists.newArrayList();
        ConfigTerrainBuilder.addToList(list, blocks);
        if (!list.isEmpty()) {
            ConfigTerrainChecker checker = new ConfigTerrainChecker(list, subbiome);
            TerrainSegment.biomeCheckers.add(checker);
        }
    }

    public static Predicate<BlockState> getState(String arguments) {
        String[] args = arguments.split(" ");
        String[] resource = args[0].split(":");
        final String modid = resource[0];
        final String blockName = resource[1];
        String keyTemp = null;
        String valTemp = null;
        if (args.length > 1) {
            String[] state = args[1].split("=");
            keyTemp = state[0];
            valTemp = state[1];
        }
        final String key = keyTemp;
        final String val = valTemp;
        return new Predicate<BlockState>(){
            final Pattern modidPattern;
            final Pattern blockPattern;
            Map<ResourceLocation, Boolean> checks;
            {
                this.modidPattern = Pattern.compile(modid);
                this.blockPattern = Pattern.compile(blockName);
                this.checks = Maps.newHashMap();
            }

            public boolean apply(BlockState input) {
                if (input == null || input.m_60734_() == null) {
                    return false;
                }
                Block block = input.m_60734_();
                ResourceLocation name = RegHelper.getKey(block);
                if (this.checks.containsKey(name) && !this.checks.get(name).booleanValue()) {
                    return false;
                }
                if (!this.checks.containsKey(name)) {
                    if (!this.modidPattern.matcher(name.m_135827_()).matches()) {
                        this.checks.put(name, false);
                        return false;
                    }
                    if (!this.blockPattern.matcher(name.m_135815_()).matches()) {
                        this.checks.put(name, false);
                        return false;
                    }
                    this.checks.put(name, true);
                }
                if (key == null) {
                    return true;
                }
                for (Property prop : input.m_61147_()) {
                    if (!prop.m_61708_().equals(key)) continue;
                    Comparable inputVal = input.m_61143_(prop);
                    return inputVal.toString().equalsIgnoreCase(val);
                }
                return false;
            }
        };
    }

    public static void process(List<String> values) {
        HashMap types = Maps.newHashMap();
        for (String s : values) {
            try {
                String[] args = s.split("->");
                String id = args[0];
                String val = args[1];
                ArrayList list = (ArrayList)types.get(id);
                if (list == null) {
                    list = Lists.newArrayList();
                    types.put(id, list);
                }
                list.add(val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String type : types.keySet()) {
            BiomeType subbiome = BiomeType.getBiome(type, true);
            ConfigTerrainBuilder.generateConfigTerrain(((ArrayList)types.get(type)).toArray(new String[0]), subbiome);
        }
    }
}

