/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.terrain;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import thut.api.maths.Vector3;
import thut.api.terrain.BiomeType;
import thut.api.terrain.TerrainSegment;

public class ConfigTerrainChecker
implements TerrainSegment.ISubBiomeChecker {
    private final List<Predicate<BlockState>> list;
    private final BiomeType subbiome;

    public ConfigTerrainChecker(List<Predicate<BlockState>> list, BiomeType subbiome) {
        this.list = list;
        this.subbiome = subbiome;
    }

    private boolean apply(BlockState state) {
        if (state.m_60767_() == Material.f_76296_) {
            return false;
        }
        for (Predicate<BlockState> predicate : this.list) {
            if (!predicate.apply((Object)state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BiomeType getSubBiome(LevelAccessor world, Vector3 v, TerrainSegment segment, boolean caveAdjusted) {
        if (caveAdjusted) {
            Vector3 temp1 = new Vector3();
            int x0 = segment.chunkX * 16;
            int y0 = segment.chunkY * 16;
            int z0 = segment.chunkZ * 16;
            int dx = (v.intX() - x0) / 4 * 4;
            int dy = (v.intY() - y0) / 4 * 4;
            int dz = (v.intZ() - z0) / 4 * 4;
            int x1 = x0 + dx;
            int y1 = y0 + dy;
            int z1 = z0 + dz;
            for (int i = x1; i < x1 + 4; ++i) {
                for (int j = y1; j < y1 + 4; ++j) {
                    for (int k = z1; k < z1 + 4; ++k) {
                        temp1.set(i, j, k);
                        if (!this.apply(temp1.getBlockState((BlockGetter)world))) continue;
                        return this.subbiome;
                    }
                }
            }
        }
        return BiomeType.NONE;
    }
}

