/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.world.mobs.data;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import thut.api.ThutCaps;
import thut.api.world.mobs.data.Data;
import thut.api.world.mobs.data.DataSync;
import thut.core.common.ThutCore;
import thut.core.common.world.mobs.data.types.Data_Byte;
import thut.core.common.world.mobs.data.types.Data_Float;
import thut.core.common.world.mobs.data.types.Data_Int;
import thut.core.common.world.mobs.data.types.Data_ItemStack;
import thut.core.common.world.mobs.data.types.Data_String;
import thut.core.common.world.mobs.data.types.Data_UUID;

public class DataSync_Impl
implements DataSync,
ICapabilityProvider {
    public static Int2ObjectArrayMap<Class<? extends Data<?>>> REGISTRY = new Int2ObjectArrayMap();
    private Int2ObjectArrayMap<Data<?>> data = new Int2ObjectArrayMap();
    private Int2ObjectArrayMap<Data<?>> readCache = new Int2ObjectArrayMap();
    private final LazyOptional<DataSync> holder = LazyOptional.of(() -> this);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock r = this.lock.readLock();
    private final Lock w = this.lock.writeLock();
    private long tick;
    private boolean syncNow = false;
    private int offset = ThutCore.newRandom().nextInt();

    public static void addMapping(Class<? extends Data<?>> dataType) {
        REGISTRY.put(REGISTRY.size(), dataType);
    }

    public static int getID(Data<?> data) {
        if (data.getUID() != -1) {
            return data.getUID();
        }
        for (Map.Entry entry : REGISTRY.entrySet()) {
            if (entry.getValue() != data.getClass()) continue;
            data.setUID((Integer)entry.getKey());
            return data.getUID();
        }
        throw new NullPointerException("Datatype not found for " + data);
    }

    public static <T> T makeData(int id) throws Exception {
        Class dataType = (Class)REGISTRY.get(id);
        if (dataType == null) {
            throw new NullPointerException("No type registered for ID: " + id);
        }
        Data data = (Data)dataType.getConstructor(new Class[0]).newInstance(new Object[0]);
        DataSync_Impl.getID(data);
        return (T)data;
    }

    @Override
    public <T> T get(int key) {
        return ((Data)this.readCache.get(key)).get();
    }

    @Override
    public List<Data<?>> getAll() {
        ArrayList list = null;
        this.r.lock();
        for (Data value : this.data.values()) {
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.add(value);
        }
        this.r.unlock();
        this.syncNow = false;
        return list;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        return ThutCaps.DATASYNC.orEmpty(capability, this.holder);
    }

    @Override
    public List<Data<?>> getDirty() {
        ArrayList list = null;
        this.r.lock();
        for (Data value : this.data.values()) {
            if (!value.dirty()) continue;
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.add(value);
        }
        this.r.unlock();
        this.syncNow = false;
        return list;
    }

    @Override
    public <T> int register(Data<T> data, T value) {
        data.set(value);
        int id = this.data.size();
        data.setID(id);
        DataSync_Impl.getID(data);
        this.data.put(id, data);
        this.readCache.put(id, data);
        return id;
    }

    @Override
    public <T> void set(int key, T value) {
        this.w.lock();
        Data type = (Data)this.data.get(key);
        type.set(value);
        if (type.isRealtime() && type.dirty()) {
            this.syncNow = true;
        }
        this.w.unlock();
    }

    @Override
    public void update(List<Data<?>> values) {
        this.w.lock();
        for (Data<?> value : values) {
            int uid2;
            if (!this.data.containsKey(value.getID())) continue;
            Data old = (Data)this.data.get(value.getID());
            int uid1 = value.getUID();
            if (uid1 != (uid2 = old.getUID())) continue;
            this.data.put(value.getID(), value);
            this.readCache.put(value.getID(), value);
        }
        this.w.unlock();
    }

    @Override
    public long getTick() {
        return this.tick;
    }

    @Override
    public void setTick(long tick) {
        this.tick = tick;
    }

    @Override
    public int tickOffset() {
        return this.offset;
    }

    @Override
    public boolean syncNow() {
        return this.syncNow;
    }

    static {
        DataSync_Impl.addMapping(Data_Byte.class);
        DataSync_Impl.addMapping(Data_Int.class);
        DataSync_Impl.addMapping(Data_Float.class);
        DataSync_Impl.addMapping(Data_String.class);
        DataSync_Impl.addMapping(Data_UUID.class);
        DataSync_Impl.addMapping(Data_ItemStack.class);
    }
}

