/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.world.mobs.data;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.ThutCaps;
import thut.api.Tracker;
import thut.api.world.mobs.data.DataSync;
import thut.core.common.world.mobs.data.PacketDataSync;

public class SyncHandler {
    @SubscribeEvent
    public static void EntityUpdate(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        DataSync data = SyncHandler.getData((Entity)event.getEntity());
        if (data == null) {
            return;
        }
        long tick = Tracker.instance().getTick();
        if (tick == data.getTick()) {
            return;
        }
        data.setTick(tick);
        if (!data.syncNow() && tick % (long)data.tickRate() != (long)(data.tickOffset() % data.tickRate())) {
            return;
        }
        PacketDataSync.sync((Entity)event.getEntity(), data, event.getEntity().m_19879_(), false);
    }

    public static DataSync getData(Entity mob) {
        return (DataSync)mob.getCapability(ThutCaps.DATASYNC, null).orElse(null);
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget().m_9236_().f_46443_) {
            return;
        }
        DataSync data = SyncHandler.getData(event.getTarget());
        if (data == null) {
            return;
        }
        PacketDataSync.sync((ServerPlayer)event.getEntity(), data, event.getTarget().m_19879_(), true);
    }
}

