/*
 * Decompiled with CFR 0.152.
 */
package thut.core.init;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import thut.api.entity.CopyCaps;
import thut.api.entity.ICopyMob;
import thut.api.maths.Vector3;
import thut.api.particle.ThutParticles;
import thut.api.terrain.BiomeType;
import thut.api.terrain.StructureManager;
import thut.api.terrain.TerrainManager;
import thut.api.terrain.TerrainSegment;
import thut.core.client.gui.NpcScreen;
import thut.core.client.render.particle.ParticleFactories;
import thut.core.client.render.wrappers.ModelWrapper;
import thut.core.init.RegistryObjects;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientInit {
    public static void line(VertexConsumer builder, Matrix4f positionMatrix, float dx1, float dy1, float dz1, float dx2, float dy2, float dz2, float r, float g, float b, float a) {
        builder.m_85982_(positionMatrix, dx1, dy1, dz1).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(positionMatrix, dx2, dy2, dz2).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void line(VertexConsumer builder, Matrix4f positionMatrix, Vector3f start, Vector3f end, float r, float g, float b, float a) {
        ClientInit.line(builder, positionMatrix, start.m_122239_(), start.m_122260_(), start.m_122269_(), end.m_122239_(), end.m_122260_(), end.m_122269_(), r, g, b, a);
    }

    @SubscribeEvent
    public static void textOverlay(CustomizeGuiOverlayEvent.DebugText event) {
        boolean debug = Minecraft.m_91087_().f_91066_.f_92063_;
        if (!debug) {
            return;
        }
        TerrainSegment t = TerrainManager.getInstance().getTerrainForEntity((Entity)Minecraft.m_91087_().f_91074_);
        Vector3 v = new Vector3().set(Minecraft.m_91087_().f_91074_);
        BiomeType type = t.getBiome(v);
        String msg = "Sub-Biome: " + I18n.m_118938_((String)type.readableName, (Object[])new Object[0]) + " (" + type.name + ")";
        if (event.getLeft().contains(msg)) {
            return;
        }
        event.getLeft().add("");
        event.getLeft().add(msg);
        event.getLeft().add("");
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Optional regi = level.m_5962_().m_6632_(Registry.f_235725_);
        Set<StructureManager.StructureInfo> structures = StructureManager.getNear((ResourceKey<Level>)level.m_46472_(), v.getPos(), 5);
        if (regi.isPresent()) {
            for (StructureManager.StructureInfo info : structures) {
                List tags = ((Registry)regi.get()).m_206081_((ResourceKey)((Registry)regi.get()).m_7854_((Object)info.feature).get()).m_203616_().toList();
                ArrayList keys = Lists.newArrayList();
                for (TagKey tag : tags) {
                    if (tag.toString().contains(":mixin_")) continue;
                    keys.add(tag.f_203868_());
                }
                event.getLeft().add(info.getName() + " " + keys);
            }
        }
        if (Screen.m_96639_()) {
            event.getLeft().add("");
            Holder holder = level.m_204166_(v.getPos());
            List tags = holder.getTagKeys().toList();
            ArrayList msgs = Lists.newArrayList();
            for (TagKey tag : tags) {
                msgs.add(tag.f_203868_());
            }
            for (TagKey tag : msgs) {
                event.getLeft().add("" + (ResourceLocation)tag);
            }
        }
    }

    static BiomeType getSubbiome(ItemStack held) {
        if (held.m_41786_().getString().toLowerCase(Locale.ROOT).startsWith("subbiome->")) {
            String[] args = held.m_41786_().getString().split("->");
            if (args.length != 2) {
                return null;
            }
            return BiomeType.getBiome(args[1].trim());
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void renderMob(RenderLivingEvent.Pre<?, ?> event) {
        LivingEntityRenderer renderer;
        EntityModel entityModel;
        LivingEntity living = event.getEntity();
        ICopyMob copied = CopyCaps.get((ICapabilityProvider)living);
        if (copied != null && copied.getCopiedMob() != null) {
            LivingEntity entity = copied.getCopiedMob();
            boolean backup = event.getRenderer().f_114476_.f_114358_.m_90593_();
            event.getRenderer().f_114476_.m_114468_(false);
            event.getRenderer().f_114476_.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
            event.getRenderer().f_114476_.m_114468_(backup);
            event.setCanceled(true);
        }
        if ((entityModel = (renderer = event.getRenderer()).m_7200_()) instanceof ModelWrapper) {
            ModelWrapper wrap = (ModelWrapper)entityModel;
            ResourceLocation tex = renderer.m_5478_((Entity)living);
            wrap.setMob(living, event.getMultiBufferSource(), tex);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void renderHand(RenderHandEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ICopyMob copied = CopyCaps.get((ICapabilityProvider)player);
        if (copied != null && copied.getCopiedMob() != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderBounds(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack held = player.m_21205_();
        if (!held.m_41619_() || !(held = player.m_21206_()).m_41619_()) {
            Minecraft mc = Minecraft.m_91087_();
            if (ClientInit.getSubbiome(held) != null && held.m_41783_() != null && held.m_41783_().m_128441_("min")) {
                Vec3 projectedView = mc.f_91063_.m_109153_().m_90583_();
                Vec3 pointed = new Vec3(projectedView.f_82479_, projectedView.f_82480_, projectedView.f_82481_).m_82549_(mc.f_91074_.m_20252_(event.getPartialTick()));
                if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult result = (BlockHitResult)mc.f_91077_;
                    pointed = new Vec3((double)result.m_82425_().m_123341_(), (double)result.m_82425_().m_123342_(), (double)result.m_82425_().m_123343_());
                }
                Vector3 v = Vector3.readFromNBT(held.m_41783_().m_128469_("min"), "");
                AABB one = new AABB(v.getPos());
                AABB two = new AABB(new BlockPos(pointed));
                double minX = Math.min(one.f_82288_, two.f_82288_);
                double minY = Math.min(one.f_82289_, two.f_82289_);
                double minZ = Math.min(one.f_82290_, two.f_82290_);
                double maxX = Math.max(one.f_82291_, two.f_82291_);
                double maxY = Math.max(one.f_82292_, two.f_82292_);
                double maxZ = Math.max(one.f_82293_, two.f_82293_);
                AABB box = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
                PoseStack matrix = event.getPoseStack();
                MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
                VertexConsumer builder = buffer.m_6299_((RenderType)RenderType.f_110371_);
                Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                matrix.m_85836_();
                matrix.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
                LevelRenderer.m_109646_((PoseStack)matrix, (VertexConsumer)builder, (AABB)box, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                matrix.m_85849_();
                buffer.m_109912_((RenderType)RenderType.f_110371_);
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="thutcore", value={Dist.CLIENT})
    public static class ModInit {
        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent event) {
            MenuScreens.m_96206_((MenuType)((MenuType)RegistryObjects.NPC_MENU.get()), NpcScreen::new);
        }

        @SubscribeEvent
        public static void registerParticles(RegisterParticleProvidersEvent event) {
            event.register((ParticleType)ThutParticles.AURORA, ParticleFactories.GENERICFACTORY);
            event.register((ParticleType)ThutParticles.MISC, ParticleFactories.GENERICFACTORY);
            event.register((ParticleType)ThutParticles.STRING, ParticleFactories.GENERICFACTORY);
            event.register((ParticleType)ThutParticles.LEAF, ParticleFactories.GENERICFACTORY);
            event.register((ParticleType)ThutParticles.POWDER, ParticleFactories.GENERICFACTORY);
        }
    }
}

