/*
 * Decompiled with CFR 0.152.
 */
package thut.core.init;

import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thut.api.TickHandler;
import thut.api.Tracker;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.maths.Vector3;
import thut.api.terrain.BiomeType;
import thut.api.terrain.StructureManager;
import thut.api.terrain.TerrainManager;
import thut.api.util.PermNodes;
import thut.core.common.ThutCore;
import thut.core.common.network.EntityUpdate;
import thut.core.common.world.mobs.data.SyncHandler;
import thut.crafts.ThutCrafts;
import thut.crafts.entity.EntityCraft;
import thut.lib.ChatHelper;
import thut.lib.TComponent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonInit {
    public static final String SET_SUBBIOME = "thutcore.subbiome.set";

    static BiomeType getSubbiome(ServerPlayer player, ItemStack held) {
        if (!PermNodes.getBooleanPerm(player, SET_SUBBIOME)) {
            return null;
        }
        if (held.m_41786_().getString().toLowerCase(Locale.ROOT).startsWith("subbiome->")) {
            String[] args = held.m_41786_().getString().split("->");
            if (args.length != 2) {
                return null;
            }
            return BiomeType.getBiome(args[1].trim());
        }
        return null;
    }

    protected static boolean isSubbiomeEditor(ServerPlayer player, ItemStack held) {
        return CommonInit.getSubbiome(player, held) != null;
    }

    private static void trySubbiomeEditor(PlayerInteractEvent.RightClickBlock evt) {
        ServerPlayer player;
        block9: {
            block8: {
                Player player2;
                if (evt.getHand() == InteractionHand.OFF_HAND || !((player2 = evt.getEntity()) instanceof ServerPlayer)) break block8;
                player = (ServerPlayer)player2;
                if (!evt.getItemStack().m_41619_() && evt.getEntity().m_6144_() && CommonInit.isSubbiomeEditor(player, evt.getItemStack())) break block9;
            }
            return;
        }
        ItemStack itemstack = evt.getItemStack();
        Player playerIn = evt.getEntity();
        Level worldIn = evt.getLevel();
        BlockPos pos = evt.getPos();
        if (itemstack.m_41782_() && playerIn.m_6144_() && itemstack.m_41783_().m_128441_("min")) {
            CompoundTag minTag = itemstack.m_41783_().m_128469_("min");
            BlockPos min = pos;
            BlockPos max = Vector3.readFromNBT(minTag, "").getPos();
            if (!worldIn.f_46443_) {
                BiomeType subbiome = CommonInit.getSubbiome(player, itemstack);
                BoundingBox box = BoundingBox.m_162375_((Vec3i)min, (Vec3i)max);
                Stream poses = BlockPos.m_121886_((int)box.f_162356_, (int)box.f_162357_, (int)box.f_162358_, (int)box.f_162359_, (int)box.f_162360_, (int)box.f_162361_);
                poses.forEach(p -> TerrainManager.getInstance().getTerrain((LevelAccessor)worldIn, (BlockPos)p).setBiome((BlockPos)p, subbiome));
                String message = "msg.subbiome.set";
                ChatHelper.sendSystemMessage(playerIn, (Component)TComponent.translatable("msg.subbiome.set", subbiome.name));
            }
            itemstack.m_41783_().m_128473_("min");
            evt.setCanceled(true);
        } else {
            if (!itemstack.m_41782_()) {
                itemstack.m_41751_(new CompoundTag());
            }
            CompoundTag min = new CompoundTag();
            new Vector3().set(pos).writeToNBT(min, "");
            itemstack.m_41783_().m_128365_("min", (Tag)min);
            String message = "msg.subbiome.setcorner";
            if (!worldIn.f_46443_) {
                ChatHelper.sendSystemMessage(playerIn, (Component)TComponent.translatable("msg.subbiome.setcorner", pos));
            }
            evt.setCanceled(true);
            itemstack.m_41783_().m_128356_("time", Tracker.instance().getTick());
        }
    }

    private static void trySubbiomeEditor(PlayerInteractEvent.RightClickItem evt) {
        ServerPlayer player;
        block6: {
            block5: {
                Player player2;
                if (evt.getHand() == InteractionHand.OFF_HAND || !((player2 = evt.getEntity()) instanceof ServerPlayer)) break block5;
                player = (ServerPlayer)player2;
                if (!evt.getItemStack().m_41619_() && evt.getEntity().m_6144_() && CommonInit.isSubbiomeEditor(player, evt.getItemStack())) break block6;
            }
            return;
        }
        ItemStack itemstack = evt.getItemStack();
        Player playerIn = evt.getEntity();
        Level worldIn = evt.getLevel();
        long now = Tracker.instance().getTick();
        if (itemstack.m_41782_() && playerIn.m_6144_() && itemstack.m_41783_().m_128441_("min") && itemstack.m_41783_().m_128454_("time") != now) {
            BlockPos pos;
            CompoundTag minTag = itemstack.m_41783_().m_128469_("min");
            Vec3 loc = playerIn.m_20182_().m_82520_(0.0, (double)playerIn.m_20192_(), 0.0).m_82549_(playerIn.m_20154_().m_82490_(2.0));
            BlockPos min = pos = new BlockPos(loc);
            BlockPos max = Vector3.readFromNBT(minTag, "").getPos();
            if (!worldIn.f_46443_) {
                BiomeType subbiome = CommonInit.getSubbiome(player, itemstack);
                BoundingBox box = BoundingBox.m_162375_((Vec3i)min, (Vec3i)max);
                Stream poses = BlockPos.m_121886_((int)box.f_162356_, (int)box.f_162357_, (int)box.f_162358_, (int)box.f_162359_, (int)box.f_162360_, (int)box.f_162361_);
                poses.forEach(p -> TerrainManager.getInstance().getTerrain((LevelAccessor)worldIn, (BlockPos)p).setBiome((BlockPos)p, subbiome));
                String message = "msg.subbiome.set";
                ChatHelper.sendSystemMessage(playerIn, (Component)TComponent.translatable("msg.subbiome.set", subbiome.name));
            }
            itemstack.m_41783_().m_128473_("min");
        }
    }

    private static void tryCraftMaker(PlayerInteractEvent.RightClickBlock evt) {
        if (evt.getHand() == InteractionHand.OFF_HAND || evt.getLevel().f_46443_ || evt.getItemStack().m_41619_() || !evt.getEntity().m_6144_() || evt.getItemStack().m_41720_() != ThutCrafts.CRAFTMAKER.get()) {
            return;
        }
        ItemStack itemstack = evt.getItemStack();
        Player playerIn = evt.getEntity();
        Level worldIn = evt.getLevel();
        BlockPos pos = evt.getPos();
        if (itemstack.m_41782_() && playerIn.m_6144_() && itemstack.m_41783_().m_128441_("min")) {
            CompoundTag minTag = itemstack.m_41783_().m_128469_("min");
            BlockPos min = pos;
            BlockPos max = Vector3.readFromNBT(minTag, "").getPos();
            AABB box = new AABB(min, max);
            min = new BlockPos(box.f_82288_, box.f_82289_, box.f_82290_);
            max = new BlockPos(box.f_82291_, box.f_82292_, box.f_82293_);
            BlockPos mid = min;
            min = min.m_121996_((Vec3i)mid);
            max = max.m_121996_((Vec3i)mid);
            int dw = Math.max(max.m_123341_() - min.m_123341_(), max.m_123343_() - min.m_123343_());
            if (max.m_123342_() - min.m_123342_() > 30 || dw > 41) {
                String message = "msg.craft.toobig";
                if (!worldIn.f_46443_) {
                    ChatHelper.sendSystemMessage(playerIn, (Component)TComponent.translatable("msg.craft.toobig"));
                }
                return;
            }
            if (!worldIn.f_46443_) {
                EntityCraft craft = (EntityCraft)IBlockEntity.BlockEntityFormer.makeBlockEntity(evt.getLevel(), min, max, mid, (EntityType)ThutCrafts.CRAFTTYPE.get());
                String message = craft != null ? "msg.craft.create" : "msg.craft.fail";
                ChatHelper.sendSystemMessage(playerIn, (Component)TComponent.translatable(message));
            }
            itemstack.m_41783_().m_128473_("min");
            evt.setCanceled(true);
        } else {
            if (!itemstack.m_41782_()) {
                itemstack.m_41751_(new CompoundTag());
            }
            CompoundTag min = new CompoundTag();
            new Vector3().set(pos).writeToNBT(min, "");
            itemstack.m_41783_().m_128365_("min", (Tag)min);
            String message = "msg.craft.setcorner";
            if (!worldIn.f_46443_) {
                ChatHelper.sendSystemMessage(playerIn, (Component)TComponent.translatable("msg.craft.setcorner", pos));
            }
            evt.setCanceled(true);
            itemstack.m_41783_().m_128356_("time", Tracker.instance().getTick());
        }
    }

    private static void tryCraftMaker(PlayerInteractEvent.RightClickItem evt) {
        if (evt.getHand() == InteractionHand.OFF_HAND || evt.getLevel().f_46443_ || evt.getItemStack().m_41619_() || !evt.getEntity().m_6144_() || evt.getItemStack().m_41720_() != ThutCrafts.CRAFTMAKER.get()) {
            return;
        }
        ItemStack itemstack = evt.getItemStack();
        Player playerIn = evt.getEntity();
        Level worldIn = evt.getLevel();
        long now = Tracker.instance().getTick();
        if (itemstack.m_41782_() && playerIn.m_6144_() && itemstack.m_41783_().m_128441_("min") && itemstack.m_41783_().m_128454_("time") != now) {
            BlockPos pos;
            CompoundTag minTag = itemstack.m_41783_().m_128469_("min");
            Vec3 loc = playerIn.m_20182_().m_82520_(0.0, (double)playerIn.m_20192_(), 0.0).m_82549_(playerIn.m_20154_().m_82490_(2.0));
            BlockPos min = pos = new BlockPos(loc);
            BlockPos max = Vector3.readFromNBT(minTag, "").getPos();
            AABB box = new AABB(min, max);
            min = new BlockPos(box.f_82288_, box.f_82289_, box.f_82290_);
            max = new BlockPos(box.f_82291_, box.f_82292_, box.f_82293_);
            BlockPos mid = min;
            min = min.m_121996_((Vec3i)mid);
            max = max.m_121996_((Vec3i)mid);
            int dw = Math.max(max.m_123341_() - min.m_123341_(), max.m_123343_() - min.m_123343_());
            if (max.m_123342_() - min.m_123342_() > 30 || dw > 41) {
                String message = "msg.craft.toobig";
                if (!worldIn.f_46443_) {
                    ChatHelper.sendSystemMessage(playerIn, (Component)TComponent.translatable("msg.craft.toobig"));
                }
                return;
            }
            if (!worldIn.f_46443_) {
                EntityCraft craft = (EntityCraft)IBlockEntity.BlockEntityFormer.makeBlockEntity(evt.getLevel(), min, max, mid, (EntityType)ThutCrafts.CRAFTTYPE.get());
                String message = craft != null ? "msg.craft.create" : "msg.craft.fail";
                ChatHelper.sendSystemMessage(playerIn, (Component)TComponent.translatable(message));
            }
            itemstack.m_41783_().m_128473_("min");
        }
    }

    @SubscribeEvent
    public static void interactRightClickBlock(PlayerInteractEvent.RightClickBlock evt) {
        CommonInit.trySubbiomeEditor(evt);
        CommonInit.tryCraftMaker(evt);
    }

    @SubscribeEvent
    public static void interactRightClickBlock(PlayerInteractEvent.RightClickItem evt) {
        CommonInit.trySubbiomeEditor(evt);
        CommonInit.tryCraftMaker(evt);
    }

    @SubscribeEvent
    public static void logout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_20159_() && event.getEntity().m_20201_() instanceof EntityCraft) {
            event.getEntity().m_8127_();
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking evt) {
        if (evt.getTarget() instanceof IEntityAdditionalSpawnData && evt.getTarget() instanceof BlockEntityBase) {
            EntityUpdate.sendEntityUpdate(evt.getTarget());
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="thutcore")
    public static class RegistryEvents {
        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            TerrainManager.getInstance();
            MinecraftForge.EVENT_BUS.register(StructureManager.class);
            MinecraftForge.EVENT_BUS.register(TickHandler.class);
            MinecraftForge.EVENT_BUS.register(ThutCore.MobEvents.class);
            MinecraftForge.EVENT_BUS.register(SyncHandler.class);
            TerrainManager.init();
            PermNodes.registerBooleanNode("thutcore", CommonInit.SET_SUBBIOME, PermNodes.DefaultPermissionLevel.OP, "Able to set subbiomes via items");
        }
    }
}

