/*
 * Decompiled with CFR 0.152.
 */
package thut.core.xml.bind;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import thut.core.common.ThutCore;
import thut.core.xml.bind.annotation.XmlAnyAttribute;
import thut.core.xml.bind.annotation.XmlAttribute;
import thut.core.xml.bind.annotation.XmlElement;
import thut.core.xml.bind.annotation.XmlRootElement;

public class Factory<T> {
    private static Map<Class<?>, Map<String, Field>> knownElemMappins = Maps.newHashMap();
    private static Map<Class<?>, Map<String, Field>> knownAttrMappins = Maps.newHashMap();
    private static Map<Class<?>, Field> knownAnyAtrMappins = Maps.newHashMap();
    private static XMLReader XMLREADER;
    private static final DocumentBuilderFactory DOCFACTORY;
    final T toFill;

    public static <T> T make(InputStream stream, Class<T> clazz) throws Exception {
        InputSource inputSource = new InputSource(new InputStreamReader(stream));
        SAXSource source = new SAXSource(XMLREADER, inputSource);
        return Factory.makeForClass(clazz).make(source);
    }

    public static <T> Factory<T> makeForClass(Class<T> clazz) throws Exception {
        return new Factory<T>(clazz);
    }

    private Factory(Class<T> clazz) throws Exception {
        this.toFill = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private void apply(Node n, Object obj, int depth, Field field, String tabbing) {
        String name = n.getNodeName();
        String value = n.getNodeValue();
        if (field == null) {
            return;
        }
        Class<?> fclaz = field.getType();
        try {
            Object obj2 = field.get(obj);
            if (fclaz == String.class) {
                field.set(obj, value);
            } else if (fclaz == Float.TYPE || fclaz == Float.class || fclaz == Double.TYPE || fclaz == Double.class) {
                field.set(obj, Float.valueOf(Float.parseFloat(value)));
            } else if (fclaz == Integer.TYPE || fclaz == Integer.class) {
                field.set(obj, Integer.parseInt(value));
            } else if (fclaz == Byte.TYPE || fclaz == Byte.class) {
                field.set(obj, Byte.parseByte(value));
            } else if (fclaz == Boolean.TYPE || fclaz == Boolean.class) {
                field.set(obj, Boolean.parseBoolean(value));
            } else if (fclaz == List.class) {
                ParameterizedType pType = (ParameterizedType)field.getGenericType();
                Class clazz = (Class)pType.getActualTypeArguments()[0];
                List list = (List)obj2;
                if (clazz == String.class) {
                    obj2 = value;
                } else if (clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class) {
                    obj2 = Float.valueOf(Float.parseFloat(value));
                } else if (clazz == Integer.TYPE || clazz == Integer.class) {
                    obj2 = Integer.parseInt(value);
                } else if (clazz == Byte.TYPE || clazz == Byte.class) {
                    obj2 = Byte.parseByte(value);
                } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                    obj2 = Boolean.parseBoolean(value);
                } else if (clazz.getAnnotation(XmlRootElement.class) != null) {
                    obj2 = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.processNode(n, obj2, depth + 1);
                }
                list.add(obj2);
            } else if (fclaz == Map.class) {
                Map m = (Map)obj2;
                QName qn = new QName(name);
                m.put(qn, value);
            } else if (fclaz.getAnnotation(XmlRootElement.class) != null) {
                if (obj2 == null) {
                    obj2 = fclaz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    field.set(obj, obj2);
                }
                this.processNode(n, obj2, depth + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processNode(Node node, Object obj, int depth) {
        Object tabbing = "";
        for (int i = 0; i < depth; ++i) {
            tabbing = (String)tabbing + "   ";
        }
        String name = node.getNodeName();
        NodeList children = node.getChildNodes();
        NamedNodeMap attributes = node.getAttributes();
        if (name.equals("#text")) {
            return;
        }
        Class<?> clazz = obj.getClass();
        HashMap attrs = knownAttrMappins.get(clazz);
        HashMap elems = knownElemMappins.get(clazz);
        Field otherAttrs = knownAnyAtrMappins.get(clazz);
        if (attrs == null || elems == null) {
            attrs = Maps.newHashMap();
            knownAttrMappins.put(clazz, attrs);
            elems = Maps.newHashMap();
            knownAttrMappins.put(clazz, elems);
            for (Field field : obj.getClass().getDeclaredFields()) {
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                XmlAttribute atr = field.getAnnotation(XmlAttribute.class);
                XmlElement elem = field.getAnnotation(XmlElement.class);
                XmlAnyAttribute anyatr = field.getAnnotation(XmlAnyAttribute.class);
                if (atr != null) {
                    attrs.put(atr.name(), field);
                } else if (elem != null) {
                    elems.put(elem.name(), field);
                } else {
                    if (anyatr == null) continue;
                    otherAttrs = field;
                }
                field.setAccessible(true);
            }
            knownAnyAtrMappins.put(clazz, otherAttrs);
        }
        if (children != null && children.getLength() > 0) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node n = children.item(i);
                name = n.getNodeName();
                String value = n.getNodeValue();
                if (name.equals("#text")) {
                    if (value == null || ThutCore.trim(value).isEmpty() || !ThutCore.conf.debug) continue;
                    ThutCore.LOGGER.error("We do not handle this properly yet! {}: {}", (Object)name, (Object)value);
                    continue;
                }
                if (!elems.containsKey(name)) continue;
                this.apply(n, obj, depth, (Field)elems.get(name), (String)tabbing);
            }
        }
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node n = attributes.item(i);
                name = n.getNodeName();
                if (attrs.containsKey(name)) {
                    this.apply(n, obj, depth, (Field)attrs.get(name), (String)tabbing);
                    continue;
                }
                if (otherAttrs == null) continue;
                this.apply(n, obj, depth, otherAttrs, (String)tabbing);
            }
        }
    }

    public T make(SAXSource source) throws SAXException, IOException, ParserConfigurationException {
        Document d = DOCFACTORY.newDocumentBuilder().parse(source.getInputSource());
        Element root = d.getDocumentElement();
        this.processNode(root, this.toFill, 0);
        return this.toFill;
    }

    static {
        DOCFACTORY = DocumentBuilderFactory.newInstance();
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            XMLREADER = spf.newSAXParser().getXMLReader();
            XMLREADER.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            DOCFACTORY.setNamespaceAware(true);
            DOCFACTORY.setFeature("http://xml.org/sax/features/namespaces", false);
            DOCFACTORY.setFeature("http://xml.org/sax/features/validation", false);
            DOCFACTORY.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            DOCFACTORY.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }
}

