/*
 * Decompiled with CFR 0.152.
 */
package thut.crafts;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.block.TempBlock;
import thut.api.entity.blockentity.block.TempTile;
import thut.core.common.config.Config;
import thut.core.common.config.Configure;
import thut.core.common.network.PacketHandler;
import thut.crafts.entity.EntityCraft;
import thut.crafts.network.PacketCraftControl;

@Mod(value="thutcrafts")
public class ThutCrafts {
    public static final PacketHandler packets = new PacketHandler(new ResourceLocation("thutcrafts", "comms"), "1.0.0");
    public static final RegistryObject<EntityType<EntityCraft>> CRAFTTYPE;
    public static final RegistryObject<Item> CRAFTMAKER;
    public static final RegistryObject<TempBlock> CRAFTBLOCK;
    public static final RegistryObject<BlockEntityType<TempTile>> CRAFTTE;
    public static CraftsConfig conf;
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<BlockEntityType<?>> TILES;
    public static final DeferredRegister<EntityType<?>> ENTITIES;

    public ThutCrafts() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        ITEMS.register(bus);
        BLOCKS.register(bus);
        TILES.register(bus);
        ENTITIES.register(bus);
        Config.setupConfigs(conf, "thutcore", "thutcrafts");
    }

    private void setup(FMLCommonSetupEvent event) {
        packets.registerMessage(PacketCraftControl.class, PacketCraftControl::new);
        MinecraftForge.EVENT_BUS.register(ThutCrafts.class);
    }

    static {
        conf = new CraftsConfig();
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"thutcrafts");
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"thutcrafts");
        TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"thutcrafts");
        ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"thutcrafts");
        CRAFTTYPE = ENTITIES.register("craft", () -> new BlockEntityBase.BlockEntityType(EntityCraft::new));
        CRAFTMAKER = ITEMS.register("craftmaker", () -> new Item(new Item.Properties()));
        CRAFTBLOCK = BLOCKS.register("craft", () -> TempBlock.make());
        CRAFTTE = TILES.register("craft", () -> BlockEntityType.Builder.m_155273_(TempTile::new, (Block[])new Block[]{(Block)CRAFTBLOCK.get()}).m_58966_(null));
    }

    public static class CraftsConfig
    extends Config.ConfigData {
        @Configure(category="rotates", type=ModConfig.Type.SERVER, comment="Enables rotation for crafts. [Default: false]")
        public boolean canRotate = false;

        public CraftsConfig() {
            super("thutcrafts");
        }

        @Override
        public void onUpdated() {
        }
    }
}

