/*
 * Decompiled with CFR 0.152.
 */
package thut.crafts.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import thut.api.entity.IMultiplePassengerEntity;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.maths.vecmath.Vec3f;
import thut.crafts.entity.EntityCraft;
import thut.lib.ChatHelper;
import thut.lib.TComponent;

public class CraftInteractHandler
extends BlockEntityInteractHandler {
    final EntityCraft craft;

    public CraftInteractHandler(EntityCraft lift) {
        super(lift);
        this.craft = lift;
    }

    @Override
    public InteractionResult applyPlayerInteraction(Player player, Vec3 vec, ItemStack stack, InteractionHand hand) {
        if (player.m_6047_()) {
            return InteractionResult.PASS;
        }
        InteractionResult result = super.applyPlayerInteraction(player, vec, stack, hand);
        boolean passed = result == InteractionResult.SUCCESS;
        boolean bl = passed = passed || this.processInitialInteract(player, player.m_21120_(hand), hand) == InteractionResult.SUCCESS;
        if (passed) {
            return InteractionResult.SUCCESS;
        }
        if (this.interactInternal(player, new BlockPos(vec = vec.m_82546_(this.craft.m_20182_())), stack, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (this.craft.f_19857_ != 0.0f) {
            for (int i = 0; i < this.craft.getSeatCount(); ++i) {
                IMultiplePassengerEntity.Seat seat = this.craft.getSeat(i);
                if (this.craft.f_19853_.f_46443_ || !seat.getEntityId().equals(IMultiplePassengerEntity.Seat.BLANK)) continue;
                this.craft.setSeatID(i, player.m_20148_());
                player.m_20329_((Entity)this.craft);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult interactInternal(Player player, BlockPos pos, ItemStack stack, InteractionHand hand) {
        BlockState state = this.craft.getFakeWorld().getBlockRelative(pos);
        if (state != null && state.m_60734_() instanceof StairBlock) {
            if (this.craft.getSeatCount() == 0) {
                BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
                int sizeX = this.craft.getTiles().length;
                int sizeY = this.craft.getTiles()[0].length;
                int sizeZ = this.craft.getTiles()[0][0].length;
                for (int i = 0; i < sizeX; ++i) {
                    for (int j = 0; j < sizeY; ++j) {
                        for (int k = 0; k < sizeZ; ++k) {
                            pos1.m_122169_((double)i + this.craft.m_20185_(), (double)j + this.craft.m_20186_(), (double)k + this.craft.m_20189_());
                            BlockState state1 = this.craft.getFakeWorld().getBlock((BlockPos)pos1);
                            if (!(state1.m_60734_() instanceof StairBlock)) continue;
                            Vec3f seat = new Vec3f((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f);
                            this.craft.addSeat(seat);
                        }
                    }
                }
            }
            for (int i = 0; i < this.craft.getSeatCount(); ++i) {
                IMultiplePassengerEntity.Seat seat = this.craft.getSeat(i);
                Vec3f seatPos = seat.seat;
                BlockPos pos1 = new BlockPos((double)seatPos.x, (double)seatPos.y, (double)seatPos.z);
                if (!pos1.equals((Object)pos)) continue;
                if (player.m_9236_().f_46443_ || seat.getEntityId().equals(player.m_20148_())) break;
                this.craft.setSeatID(i, player.m_20148_());
                player.m_20329_((Entity)this.craft);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult processInitialInteract(Player player, @Nullable ItemStack stack, InteractionHand hand) {
        if (stack.m_41720_() == Items.f_42585_ && !player.f_19853_.f_46443_) {
            ChatHelper.sendSystemMessage(player, (Component)TComponent.translatable("msg.craft.killed"));
            this.craft.m_142687_(Entity.RemovalReason.KILLED);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

