/*
 * Decompiled with CFR 0.152.
 */
package thut.crafts.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.entity.IMultiplePassengerEntity;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.maths.Vector3;
import thut.api.maths.vecmath.Vec3f;
import thut.crafts.entity.CraftController;
import thut.crafts.entity.CraftInteractHandler;
import thut.crafts.entity.EventCraftConsumePower;

public class EntityCraft
extends BlockEntityBase
implements IMultiplePassengerEntity {
    static final EntityDataAccessor<IMultiplePassengerEntity.Seat>[] SEAT = new EntityDataAccessor[10];
    static final EntityDataAccessor<Integer> SEATCOUNT = SynchedEntityData.m_135353_(EntityCraft.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    static final EntityDataAccessor<Integer> MAINSEATDW = SynchedEntityData.m_135353_(EntityCraft.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static boolean ENERGYUSE;
    public static int ENERGYCOST;
    public CraftController controller = new CraftController(this);
    int energy = 0;
    public UUID owner;
    EntityDimensions size;

    public EntityCraft(EntityType<EntityCraft> type, Level par1World) {
        super(type, par1World);
    }

    @Override
    protected Vector3 getForceDirection() {
        this.updateForce();
        return this.F;
    }

    public void updateForce() {
        float destX;
        float destY;
        this.F.clear();
        this.f_19794_ = false;
        if (this.isServerWorld() && !this.consumePower()) {
            this.m_146884_(this.m_20182_());
            Vec3 v = this.getV();
            double v2 = v.m_82556_();
            if (v2 > 0.0) {
                if (v2 > 1.0E-4) {
                    this.m_20256_(v.m_82542_(0.5, 0.5, 0.5));
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
            }
            return;
        }
        this.toMoveX = this.controller.leftInputDown || this.controller.rightInputDown;
        this.toMoveZ = this.controller.backInputDown || this.controller.forwardInputDown;
        boolean bl = this.toMoveY = this.controller.upInputDown || this.controller.downInputDown;
        float f = this.toMoveY ? (this.controller.upInputDown ? 30.0f : -30.0f) : (destY = 0.0f);
        float f2 = this.toMoveX ? (this.controller.leftInputDown ? 30.0f : -30.0f) : (destX = 0.0f);
        float destZ = this.toMoveZ ? (this.controller.forwardInputDown ? 30.0f : -30.0f) : 0.0f;
        boolean dbug_move = true;
        this.toMoveY = true;
        destY = 1.0f;
        if (!(this.toMoveY || this.toMoveX || this.toMoveZ)) {
            Vec3 v = this.getV();
            double v2 = v.m_82556_();
            if (v2 > 0.0) {
                if (v2 > 1.0E-4) {
                    this.m_20256_(v.m_82542_(0.5, 0.5, 0.5));
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
            }
            return;
        }
        IMultiplePassengerEntity.Seat seat = null;
        for (int i = 0; i < this.getSeatCount(); ++i) {
            if (this.getSeat(i).getEntityId().equals(IMultiplePassengerEntity.Seat.BLANK)) continue;
            seat = this.getSeat(i);
            break;
        }
        float f3 = (float)Math.sqrt(destX * destX + destZ * destZ);
        float dx = 0.0f;
        float dz = 0.0f;
        if (this.controller.forwardInputDown) {
            dx = Mth.m_14031_((float)(-this.f_19857_ * ((float)Math.PI / 180)));
            dz = Mth.m_14089_((float)(this.f_19857_ * ((float)Math.PI / 180)));
        } else if (this.controller.backInputDown) {
            dx = -Mth.m_14031_((float)(-this.f_19857_ * ((float)Math.PI / 180)));
            dz = -Mth.m_14089_((float)(this.f_19857_ * ((float)Math.PI / 180)));
        } else if (this.controller.leftInputDown) {
            dx = Mth.m_14089_((float)(-this.f_19857_ * ((float)Math.PI / 180)));
            dz = Mth.m_14031_((float)(this.f_19857_ * ((float)Math.PI / 180)));
        } else if (this.controller.rightInputDown) {
            dx = -Mth.m_14089_((float)(-this.f_19857_ * ((float)Math.PI / 180)));
            dz = -Mth.m_14031_((float)(this.f_19857_ * ((float)Math.PI / 180)));
        }
        if (Mth.m_14033_((float)dx, (float)0.0f)) {
            dx = 0.0f;
        }
        if (Mth.m_14033_((float)dz, (float)0.0f)) {
            dz = 0.0f;
        }
        destX += dx * f3;
        destZ += dz * f3;
        if (seat != null) {
            Vector3 rel = new Vector3().addTo(seat.seat.x, seat.seat.y, seat.seat.z);
            BlockPos pos = rel.getPos();
            BlockState block = this.getFakeWorld().getBlockRelative(pos);
            if (block != null && block.m_61138_((Property)StairBlock.f_56841_)) {
                Vector3 dest = new Vector3().set(destX, destY, destZ);
                switch ((Direction)block.m_61143_((Property)StairBlock.f_56841_)) {
                    case DOWN: {
                        break;
                    }
                    case EAST: {
                        dest = dest.rotateAboutAngles(0.0, -1.5707963267948966, new Vector3(), new Vector3());
                        break;
                    }
                    case NORTH: {
                        break;
                    }
                    case SOUTH: {
                        dest = dest.rotateAboutAngles(0.0, Math.PI, new Vector3(), new Vector3());
                        break;
                    }
                    case UP: {
                        break;
                    }
                    case WEST: {
                        dest = dest.rotateAboutAngles(0.0, 1.5707963267948966, new Vector3(), new Vector3());
                        break;
                    }
                }
                destX = (float)dest.x;
                destY = (float)dest.y;
                destZ = (float)dest.z;
            }
        }
        this.toMoveY = true;
        this.speedUp = 0.5f;
        this.speedDown = -0.5f;
        this.acceleration = 0.25f;
        if (this.m_20186_() < -40.0) {
            this.energy = 10;
        }
        if (this.m_20186_() > 80.0) {
            this.energy = -10;
        }
        float f4 = destY = this.energy > 0 ? 10.0f : -10.0f;
        if (Mth.m_14033_((float)destX, (float)0.0f)) {
            destX = 0.0f;
        }
        if (Mth.m_14033_((float)destY, (float)0.0f)) {
            destY = 0.0f;
        }
        if (Mth.m_14033_((float)destZ, (float)0.0f)) {
            destZ = 0.0f;
        }
        this.F.set(destX, destY, destZ);
    }

    public void addSeat(Vec3f seat) {
        IMultiplePassengerEntity.Seat toSet = this.getSeat(this.getSeatCount());
        toSet.seat.set(seat);
        this.f_19804_.m_135381_(SEAT[this.getSeatCount()], (Object)toSet);
        this.setSeatCount(this.getSeatCount() + 1);
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < this.getSeatCount();
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    protected boolean checkAccelerationConditions() {
        this.consumePower();
        return true;
    }

    private boolean consumePower() {
        if (!ENERGYUSE) {
            return true;
        }
        boolean power = false;
        Vector3 bounds = new Vector3().set(this.boundMax.m_121996_((Vec3i)this.boundMin));
        double volume = bounds.x * bounds.y * bounds.z;
        float speed = 10.0f;
        double energyCost = (double)(Math.abs(10.0f) * (float)ENERGYCOST) * volume * 0.01;
        this.energy = (int)((double)this.energy - (energyCost = Math.max(energyCost, 1.0)));
        boolean bl = power = this.energy > 0;
        if (this.energy < 0) {
            this.energy = 0;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EventCraftConsumePower(this, (long)energyCost));
        if (!power) {
            this.toMoveY = false;
        }
        return power;
    }

    @Override
    protected BlockEntityInteractHandler createInteractHandler() {
        return new CraftInteractHandler(this);
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getMainSeat() {
        return (Integer)this.f_19804_.m_135370_(MAINSEATDW);
    }

    @Override
    public Entity getPassenger(Vec3f seatl) {
        UUID id = null;
        for (int i = 0; i < this.getSeatCount(); ++i) {
            IMultiplePassengerEntity.Seat seat = this.getSeat(i);
            if (!seat.seat.equals(seatl)) continue;
            id = seat.getEntityId();
        }
        if (id != null) {
            for (Entity e : this.m_20197_()) {
                if (!e.m_20148_().equals(id)) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public float getPitch() {
        return this.f_19858_;
    }

    @Override
    public float getPrevPitch() {
        return this.f_19860_;
    }

    @Override
    public float getPrevYaw() {
        return this.f_19859_;
    }

    @Override
    public Vec3f getSeat(Entity passenger) {
        Vec3f ret = null;
        for (int i = 0; i < this.getSeatCount(); ++i) {
            IMultiplePassengerEntity.Seat seat = this.getSeat(i);
            if (!seat.getEntityId().equals(passenger.m_20148_())) continue;
            return seat.seat;
        }
        return ret;
    }

    IMultiplePassengerEntity.Seat getSeat(int index) {
        return (IMultiplePassengerEntity.Seat)this.f_19804_.m_135370_(SEAT[index]);
    }

    int getSeatCount() {
        return (Integer)this.f_19804_.m_135370_(SEATCOUNT);
    }

    @Override
    public List<Vec3f> getSeats() {
        ArrayList ret = Lists.newArrayList();
        for (int i = 0; i < this.getSeatCount(); ++i) {
            IMultiplePassengerEntity.Seat seat = this.getSeat(i);
            ret.add(seat.seat);
        }
        return null;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.size == null) {
            this.size = EntityDimensions.m_20398_((float)(1 + this.getMax().m_123341_() - this.getMin().m_123341_()), (float)this.getMax().m_123342_());
        }
        return this.size;
    }

    @Override
    public float getYaw() {
        return this.f_19857_;
    }

    @Override
    protected void onGridAlign() {
    }

    @Override
    protected void preColliderTick() {
        this.controller.doServerTick(this.getFakeWorld());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.energy = nbt.m_128451_("energy");
        if (nbt.m_128441_("seats")) {
            ListTag seatsList = nbt.m_128437_("seats", 10);
            for (int i = 0; i < seatsList.size(); ++i) {
                CompoundTag nbt1 = seatsList.m_128728_(i);
                IMultiplePassengerEntity.Seat seat = IMultiplePassengerEntity.Seat.readFromNBT(nbt1);
                this.f_19804_.m_135381_(SEAT[i], (Object)seat);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAINSEATDW, (Object)-1);
        for (int i = 0; i < 10; ++i) {
            this.f_19804_.m_135372_(SEAT[i], (Object)new IMultiplePassengerEntity.Seat(new Vec3f(), null));
        }
        this.f_19804_.m_135372_(SEATCOUNT, (Object)0);
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (!this.f_19853_.f_46443_) {
            for (int i = 0; i < this.getSeatCount(); ++i) {
                if (!this.getSeat(i).getEntityId().equals(passenger.m_20148_())) continue;
                this.setSeatID(i, IMultiplePassengerEntity.Seat.BLANK);
                new DismountTicker(passenger, this, this.getSeat(i));
                break;
            }
        }
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public void setMainSeat(int seat) {
        this.f_19804_.m_135381_(MAINSEATDW, (Object)seat);
    }

    void setSeatCount(int count) {
        this.f_19804_.m_135381_(SEATCOUNT, (Object)count);
    }

    void setSeatID(int index, UUID id) {
        IMultiplePassengerEntity.Seat toSet = this.getSeat(index);
        UUID old = toSet.getEntityId();
        if (!old.equals(id)) {
            toSet = (IMultiplePassengerEntity.Seat)toSet.clone();
            toSet.setEntityId(id);
            this.f_19804_.m_135381_(SEAT[index], (Object)toSet);
        }
    }

    @Override
    public void setSize(EntityDimensions size) {
        this.size = size;
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            if (passenger.m_6144_()) {
                passenger.m_8127_();
            }
            IMultiplePassengerEntity.MultiplePassengerManager.managePassenger(passenger, this);
            passenger.m_6853_(true);
            passenger.m_142535_(passenger.f_19789_, 0.0f, DamageSource.f_19318_);
            passenger.f_19789_ = 0.0f;
            if (passenger instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)passenger;
                player.f_8906_.f_9739_ = 0;
                player.f_8906_.f_9737_ = 0;
            }
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Override
    public void updateSeat(int index, UUID id) {
        IMultiplePassengerEntity.Seat seat = (IMultiplePassengerEntity.Seat)this.getSeat(index).clone();
        seat.setEntityId(id);
        this.f_19804_.m_135381_(SEAT[index], (Object)seat);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("energy", this.energy);
        ListTag seats = new ListTag();
        for (int i = 0; i < this.getSeatCount(); ++i) {
            CompoundTag tag1 = new CompoundTag();
            this.getSeat(i).writeToNBT(tag1);
            seats.add((Object)tag1);
        }
        nbt.m_128365_("seats", (Tag)seats);
    }

    static {
        for (int i = 0; i < SEAT.length; ++i) {
            EntityCraft.SEAT[i] = SynchedEntityData.m_135353_(EntityCraft.class, IMultiplePassengerEntity.SEATSERIALIZER);
        }
        ENERGYUSE = false;
        ENERGYCOST = 100;
    }

    public static class DismountTicker {
        final Entity dismounted;
        final Entity craft;
        final IMultiplePassengerEntity.Seat seat;

        public DismountTicker(Entity dismounted, Entity craft, IMultiplePassengerEntity.Seat seat) {
            this.dismounted = dismounted;
            this.craft = craft;
            this.seat = seat;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void tick(TickEvent.LevelTickEvent event) {
            if (event.level != this.craft.f_19853_) {
                return;
            }
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            double x = this.craft.m_20185_() + (double)this.seat.seat.x;
            double y = this.craft.m_20186_() + (double)this.seat.seat.y;
            double z = this.craft.m_20189_() + (double)this.seat.seat.z;
            if (this.dismounted instanceof ServerPlayer) {
                ((ServerPlayer)this.dismounted).f_8906_.m_9774_(x, y, z, this.dismounted.f_19857_, this.dismounted.f_19858_);
            } else {
                this.dismounted.m_6034_(x, y, z);
            }
        }
    }
}

