/*
 * Decompiled with CFR 0.152.
 */
package thut.crafts.init;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import thut.api.entity.blockentity.render.RenderBlockEntity;
import thut.api.maths.Vector3;
import thut.crafts.ThutCrafts;
import thut.crafts.entity.CraftController;
import thut.crafts.entity.EntityCraft;
import thut.crafts.network.PacketCraftControl;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientInit {
    static KeyMapping UP;
    static KeyMapping DOWN;
    static KeyMapping ROTATERIGHT;
    static KeyMapping ROTATELEFT;

    @SubscribeEvent
    public static void clientTick(TickEvent.PlayerTickEvent event) {
        Entity e;
        if (event.phase == TickEvent.Phase.START || event.player != Minecraft.m_91087_().f_91074_) {
            return;
        }
        if (event.player.m_20159_() && Minecraft.m_91087_().f_91080_ == null && (e = event.player.m_20202_()) instanceof EntityCraft) {
            LocalPlayer player = (LocalPlayer)event.player;
            CraftController controller = ((EntityCraft)e).controller;
            if (controller != null) {
                controller.backInputDown = player.f_108618_.f_108569_;
                controller.forwardInputDown = player.f_108618_.f_108568_;
                controller.leftInputDown = player.f_108618_.f_108570_;
                controller.rightInputDown = player.f_108618_.f_108571_;
                controller.upInputDown = UP.m_90857_();
                controller.downInputDown = DOWN.m_90857_();
                if (ThutCrafts.conf.canRotate) {
                    controller.rightRotateDown = ROTATERIGHT.m_90857_();
                    controller.leftRotateDown = ROTATELEFT.m_90857_();
                }
                PacketCraftControl.sendControlPacket(e, controller);
            }
        }
    }

    @SubscribeEvent
    public static void RenderBounds(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack held = player.m_21205_();
        if (!held.m_41619_() || !(held = player.m_21206_()).m_41619_()) {
            if (held.m_41720_() != ThutCrafts.CRAFTMAKER.get()) {
                return;
            }
            if (held.m_41783_() != null && held.m_41783_().m_128441_("min")) {
                Minecraft mc = Minecraft.m_91087_();
                Vec3 projectedView = mc.f_91063_.m_109153_().m_90583_();
                Vec3 pointed = new Vec3(projectedView.f_82479_, projectedView.f_82480_, projectedView.f_82481_).m_82549_(mc.f_91074_.m_20252_(event.getPartialTick()));
                if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult result = (BlockHitResult)mc.f_91077_;
                    pointed = new Vec3((double)result.m_82425_().m_123341_(), (double)result.m_82425_().m_123342_(), (double)result.m_82425_().m_123343_());
                }
                Vector3 v = Vector3.readFromNBT(held.m_41783_().m_128469_("min"), "");
                AABB one = new AABB(v.getPos());
                AABB two = new AABB(new BlockPos(pointed));
                double minX = Math.min(one.f_82288_, two.f_82288_);
                double minY = Math.min(one.f_82289_, two.f_82289_);
                double minZ = Math.min(one.f_82290_, two.f_82290_);
                double maxX = Math.max(one.f_82291_, two.f_82291_);
                double maxY = Math.max(one.f_82292_, two.f_82292_);
                double maxZ = Math.max(one.f_82293_, two.f_82293_);
                AABB box = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
                PoseStack matrix = event.getPoseStack();
                MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
                VertexConsumer builder = buffer.m_6299_((RenderType)RenderType.f_110371_);
                Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                matrix.m_85836_();
                matrix.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
                LevelRenderer.m_109646_((PoseStack)matrix, (VertexConsumer)builder, (AABB)box, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                matrix.m_85849_();
                buffer.m_109912_((RenderType)RenderType.f_110371_);
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="thutcrafts", value={Dist.CLIENT})
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ThutCrafts.CRAFTTYPE.get(), RenderBlockEntity::new);
        }

        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent event) {
            UP = new KeyMapping("crafts.key.up", InputConstants.f_84822_.m_84873_(), "keys.crafts");
            DOWN = new KeyMapping("crafts.key.down", InputConstants.f_84822_.m_84873_(), "keys.crafts");
            KeyConflictContext inGame = KeyConflictContext.IN_GAME;
            UP.setKeyConflictContext((IKeyConflictContext)inGame);
            DOWN.setKeyConflictContext((IKeyConflictContext)inGame);
            ROTATERIGHT = new KeyMapping("crafts.key.left", InputConstants.f_84822_.m_84873_(), "keys.crafts");
            ROTATELEFT = new KeyMapping("crafts.key.right", InputConstants.f_84822_.m_84873_(), "keys.crafts");
            ROTATELEFT.setKeyConflictContext((IKeyConflictContext)inGame);
            ROTATERIGHT.setKeyConflictContext((IKeyConflictContext)inGame);
            event.register(UP);
            event.register(DOWN);
            event.register(ROTATELEFT);
            event.register(ROTATERIGHT);
        }
    }
}

