/*
 * Decompiled with CFR 0.152.
 */
package thut.lib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import thut.core.common.ThutCore;

public class CompatParser {

    public static class ClassFinder {
        private static final Map<String, ModFile> OPTIONS = Maps.newConcurrentMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void checkOptions() {
            if (!OPTIONS.isEmpty()) {
                return;
            }
            Map<String, ModFile> map = OPTIONS;
            synchronized (map) {
                FMLLoader.getLoadingModList().getMods().forEach(i -> {
                    Set classes = i.getOwningFile().getFile().getScanResult().getClasses();
                    classes.forEach(c -> OPTIONS.put(c.clazz().getClassName(), i.getOwningFile().getFile()));
                });
            }
        }

        public static List<Class<?>> find(String packageName) throws IOException {
            return ClassFinder.find(packageName, (i, n) -> true);
        }

        public static List<Class<?>> find(String packageName, BiFunction<ModFile, String, Boolean> valid) throws IOException {
            ClassFinder.checkOptions();
            ArrayList ret = Lists.newArrayList();
            OPTIONS.keySet().forEach(c -> {
                if (!c.startsWith(packageName)) {
                    return;
                }
                if (!((Boolean)valid.apply(OPTIONS.get(c), (String)c)).booleanValue()) {
                    return;
                }
                try {
                    ret.add(ClassFinder.washClass(c));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            if (ThutCore.conf.debug_data) {
                ThutCore.LOGGER.info("Found {} classes in package {}", (Object)ret.size(), (Object)packageName);
            }
            return ret;
        }

        public static <T> Class<T> washClass(String input) throws Exception {
            return ClassFinder.class.getClassLoader().loadClass(input);
        }
    }
}

