/*
 * Decompiled with CFR 0.152.
 */
package thut.lib;

import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemStackTools {
    public static boolean addItemStackToInventory(ItemStack itemStackIn, Container toAddTo, int minIndex, Direction face) {
        if (toAddTo instanceof WorldlyContainer) {
            WorldlyContainer container = (WorldlyContainer)toAddTo;
            if (face != null) {
                if (!itemStackIn.m_41619_()) {
                    try {
                        if (itemStackIn.m_41768_()) {
                            for (int i : container.m_7071_(face)) {
                                ItemStack s = container.m_8020_(i);
                                if (!s.m_41619_() || !container.m_7155_(i, itemStackIn, face)) continue;
                                container.m_6836_(i, itemStackIn.m_41777_());
                                itemStackIn.m_41764_(0);
                                return true;
                            }
                            return false;
                        }
                        int count = itemStackIn.m_41613_();
                        for (int i : container.m_7071_(face)) {
                            int num;
                            ItemStack s = container.m_8020_(i);
                            if (container.m_7155_(i, itemStackIn, face) && (s.m_41619_() || ItemStackTools.canMergeStacks(s, itemStackIn))) {
                                if (s.m_41619_()) {
                                    container.m_6836_(i, itemStackIn.m_41777_());
                                    itemStackIn.m_41764_(0);
                                    return true;
                                }
                                int total = s.m_41613_() + itemStackIn.m_41613_();
                                if (total <= s.m_41741_()) {
                                    s.m_41764_(total);
                                    itemStackIn.m_41764_(0);
                                    break;
                                }
                                int diff = s.m_41741_() - s.m_41613_();
                                s.m_41764_(s.m_41741_());
                                itemStackIn.m_41764_(itemStackIn.m_41613_() - diff);
                            }
                            if ((num = itemStackIn.m_41613_()) <= 0) break;
                        }
                        return itemStackIn.m_41613_() < count;
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Adding item to inventory");
                        crashreport.m_127514_("Item being added");
                        throw new ReportedException(crashreport);
                    }
                }
                return false;
            }
        }
        return ItemStackTools.addItemStackToInventory(itemStackIn, toAddTo, minIndex);
    }

    public static boolean addItemStackToInventory(ItemStack itemStackIn, Container toAddTo, int minIndex) {
        return ItemStackTools.addItemStackToInventory(itemStackIn, toAddTo, minIndex, toAddTo.m_6643_());
    }

    public static boolean addItemStackToInventory(ItemStack itemStackIn, Container toAddTo, int minIndex, int maxIndex) {
        return ItemStackTools.addItemStackToInventory(itemStackIn, (IItemHandlerModifiable)new InvWrapper(toAddTo), minIndex, maxIndex);
    }

    public static boolean addItemStackToInventory(ItemStack itemStackIn, IItemHandlerModifiable toAddTo, int minIndex) {
        return ItemStackTools.addItemStackToInventory(itemStackIn, toAddTo, minIndex, toAddTo.getSlots());
    }

    public static boolean addItemStackToInventory(ItemStack itemStackIn, IItemHandlerModifiable toAddTo, int minIndex, int maxIndex) {
        if (!itemStackIn.m_41619_()) {
            try {
                int count;
                int num;
                if (itemStackIn.m_41768_()) {
                    int slot = ItemStackTools.getFirstEmptyStack(toAddTo, minIndex, maxIndex);
                    if (slot >= minIndex) {
                        toAddTo.setStackInSlot(slot, itemStackIn.m_41777_());
                        toAddTo.getStackInSlot(slot).m_41754_(5);
                        itemStackIn.m_41764_(0);
                        return true;
                    }
                    return false;
                }
                do {
                    count = itemStackIn.m_41613_();
                    num = ItemStackTools.storePartialItemStack(itemStackIn, toAddTo, minIndex, maxIndex);
                    itemStackIn.m_41764_(num);
                } while (num > 0 && num < count);
                return itemStackIn.m_41613_() < count;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Adding item to inventory");
                crashreport.m_127514_("Item being added");
                throw new ReportedException(crashreport);
            }
        }
        return false;
    }

    private static boolean canMergeStacks(ItemStack stack1, ItemStack stack2) {
        return !stack1.m_41619_() && ItemStackTools.stackEqualExact(stack1, stack2) && stack1.m_41753_() && stack1.m_41613_() < stack1.m_41741_();
    }

    public static int getFirstEmptyStack(IItemHandlerModifiable inventory, int minIndex, int maxIndex) {
        maxIndex = Math.min(maxIndex, inventory.getSlots());
        for (int index = minIndex; index < maxIndex; ++index) {
            if (!inventory.getStackInSlot(index).m_41619_()) continue;
            return index;
        }
        return -1;
    }

    private static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41720_() == stack2.m_41720_() && ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    private static int storeItemStack(ItemStack itemStackIn, IItemHandlerModifiable inventory, int minIndex, int maxIndex) {
        maxIndex = Math.min(maxIndex, inventory.getSlots());
        for (int index = minIndex; index < inventory.getSlots(); ++index) {
            if (!ItemStackTools.canMergeStacks(inventory.getStackInSlot(index), itemStackIn)) continue;
            return index;
        }
        return -1;
    }

    private static int storePartialItemStack(ItemStack itemStackIn, IItemHandlerModifiable inventory, int minIndex, int maxIndex) {
        int count = itemStackIn.m_41613_();
        int index = ItemStackTools.storeItemStack(itemStackIn, inventory, minIndex, maxIndex);
        if (index < minIndex) {
            index = ItemStackTools.getFirstEmptyStack(inventory, minIndex, maxIndex);
        }
        if (index < minIndex) {
            return count;
        }
        ItemStack itemstack = inventory.getStackInSlot(index);
        if (itemstack.m_41619_()) {
            itemstack = itemStackIn.m_41777_();
            itemstack.m_41764_(0);
            if (itemStackIn.m_41782_()) {
                itemstack.m_41751_(itemStackIn.m_41783_().m_6426_());
            }
            inventory.setStackInSlot(index, itemstack);
        }
        int remainingCount = count;
        int size = inventory.getStackInSlot(index).m_41613_();
        if (count > inventory.getStackInSlot(index).m_41741_() - size) {
            remainingCount = inventory.getStackInSlot(index).m_41741_() - size;
        }
        if (remainingCount > inventory.getSlotLimit(index) - size) {
            remainingCount = inventory.getSlotLimit(index) - size;
        }
        if (remainingCount == 0) {
            return count;
        }
        inventory.getStackInSlot(index).m_41764_(size + remainingCount);
        inventory.getStackInSlot(index).m_41754_(5);
        return count -= remainingCount;
    }
}

