/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import thut.api.maths.Vector3;
import thut.tech.client.render.ControllerRenderer;
import thut.tech.client.render.RenderLift;
import thut.tech.common.TechCore;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="thuttech", value={Dist.CLIENT})
public class ClientHandler {
    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)TechCore.LIFTTYPE.get(), RenderLift::new);
        event.registerBlockEntityRenderer((BlockEntityType)TechCore.CONTROLTYPE.get(), ControllerRenderer::new);
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(BoundRenderer.class);
    }

    public static class BoundRenderer {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void RenderBounds(RenderLevelStageEvent event) {
            if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ItemStack held = player.m_21205_();
            if (!held.m_41619_() || !(held = player.m_21206_()).m_41619_()) {
                if (held.m_41720_() != TechCore.LIFT.get()) {
                    return;
                }
                if (held.m_41783_() != null && held.m_41783_().m_128441_("min")) {
                    Minecraft mc = Minecraft.m_91087_();
                    Vec3 projectedView = mc.f_91063_.m_109153_().m_90583_();
                    Vec3 pointed = new Vec3(projectedView.f_82479_, projectedView.f_82480_, projectedView.f_82481_).m_82549_(mc.f_91074_.m_20252_(event.getPartialTick()));
                    if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                        BlockHitResult result = (BlockHitResult)mc.f_91077_;
                        pointed = new Vec3((double)result.m_82425_().m_123341_(), (double)result.m_82425_().m_123342_(), (double)result.m_82425_().m_123343_());
                    }
                    Vector3 v = Vector3.readFromNBT((CompoundTag)held.m_41783_().m_128469_("min"), (String)"");
                    AABB one = new AABB(v.getPos());
                    AABB two = new AABB(new BlockPos(pointed));
                    double minX = Math.min(one.f_82288_, two.f_82288_);
                    double minY = Math.min(one.f_82289_, two.f_82289_);
                    double minZ = Math.min(one.f_82290_, two.f_82290_);
                    double maxX = Math.max(one.f_82291_, two.f_82291_);
                    double maxY = Math.max(one.f_82292_, two.f_82292_);
                    double maxZ = Math.max(one.f_82293_, two.f_82293_);
                    AABB box = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
                    PoseStack matrix = event.getPoseStack();
                    MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
                    VertexConsumer builder = buffer.m_6299_((RenderType)RenderType.f_110371_);
                    Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                    matrix.m_85836_();
                    matrix.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
                    LevelRenderer.m_109646_((PoseStack)matrix, (VertexConsumer)builder, (AABB)box, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    matrix.m_85849_();
                    buffer.m_109912_((RenderType)RenderType.f_110371_);
                }
            }
        }
    }
}

