/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import thut.api.entity.blockentity.world.IBlockEntityWorld;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.ControllerTile;
import thut.tech.common.entity.EntityLift;

public class ControllerRenderer
implements BlockEntityRenderer<ControllerTile> {
    private static final ResourceLocation overlay = new ResourceLocation("thuttech:textures/blocks/overlay.png");
    private static final ResourceLocation overlay_1 = new ResourceLocation("thuttech:textures/blocks/overlay_1.png");
    private static final ResourceLocation font = new ResourceLocation("thuttech:textures/blocks/font.png");
    private static final ResourceLocation call = new ResourceLocation("thuttech:textures/blocks/overlay_call.png");
    private static final ResourceLocation disp = new ResourceLocation("thuttech:textures/blocks/overlay_display.png");
    private static final ResourceLocation exit = new ResourceLocation("thuttech:textures/blocks/overlay_exit.png");
    private static final ResourceLocation unlink = new ResourceLocation("thuttech:textures/blocks/overlay_unlink.png");
    private static final RenderStateShard.TransparencyStateShard TRANSP = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
    }, () -> RenderSystem.m_69461_());
    private static final RenderStateShard.WriteMaskStateShard MASK = new RenderStateShard.WriteMaskStateShard(true, true);
    private static RenderType NUMBERS = ControllerRenderer.makeType(font);
    private static final RenderType OVERLAY_1 = ControllerRenderer.makeType(overlay_1);
    private static final RenderType OVERLAY = ControllerRenderer.makeType(overlay);
    private static final RenderType CALL = ControllerRenderer.makeType(call);
    private static final RenderType DISP = ControllerRenderer.makeType(disp);
    private static final RenderType EXIT = ControllerRenderer.makeType(exit);
    private static final RenderType UNLINK = ControllerRenderer.makeType(unlink);

    private static void render(RenderType type, PoseStack mat, MultiBufferSource buff, float x1, float y1, float x2, float y2, float r, float g, float b, float a, float[] uvs) {
        ControllerRenderer.render(type, mat, buff, x1, y1, x2, y2, r, g, b, a, uvs[0], uvs[1], uvs[2], uvs[3]);
    }

    private static void render(RenderType type, PoseStack mat, MultiBufferSource buff, float x1, float y1, float x2, float y2, float r, float g, float b, float a, float u1, float u2, float v1, float v2) {
        VertexConsumer buffer = buff.m_6299_(type);
        Matrix4f o = mat.m_85850_().m_85861_();
        buffer.m_85982_(o, x2, y2, 0.0f).m_85950_(r, g, b, a).m_7421_(u1, v1).m_5752_();
        buffer.m_85982_(o, x2, y1, 0.0f).m_85950_(r, g, b, a).m_7421_(u1, v2).m_5752_();
        buffer.m_85982_(o, x1, y1, 0.0f).m_85950_(r, g, b, a).m_7421_(u2, v2).m_5752_();
        buffer.m_85982_(o, x1, y2, 0.0f).m_85950_(r, g, b, a).m_7421_(u2, v1).m_5752_();
    }

    private static RenderType.CompositeState getState(ResourceLocation texture) {
        return RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173101_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, true)).m_110685_(TRANSP).m_110687_(MASK).m_110691_(false);
    }

    public static RenderType makeType(ResourceLocation tex) {
        return RenderType.m_173215_((String)tex.toString(), (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)ControllerRenderer.getState(tex));
    }

    public ControllerRenderer(BlockEntityRendererProvider.Context dispatcher) {
    }

    public void drawEditOverlay(PoseStack mat, MultiBufferSource buff, ControllerTile monitor, Direction side) {
        Color colour = monitor.callFaces[side.ordinal()] ? new Color(0, 255, 0, 255) : new Color(255, 0, 0, 255);
        this.drawOverLay(mat, buff, monitor, 1, colour, side, 0, 0.0f, CALL);
        colour = monitor.floorDisplay[side.ordinal()] ? new Color(0, 255, 0, 255) : new Color(255, 0, 0, 255);
        this.drawOverLay(mat, buff, monitor, 2, colour, side, 0, 0.0f, DISP);
        colour = monitor.getLift() != null ? new Color(255, 255, 255, 255) : new Color(0, 0, 0, 0);
        this.drawOverLay(mat, buff, monitor, 13, colour, side, 0, 0.0f, UNLINK);
        colour = new Color(255, 255, 255, 255);
        this.drawOverLay(mat, buff, monitor, 16, colour, side, 0, 0.0f, EXIT);
    }

    public void drawFloorNumbers(PoseStack mat, MultiBufferSource buffer, int page) {
        for (int floor = 1; floor <= 16; ++floor) {
            this.drawNumber(mat, buffer, floor + page * 16, floor);
        }
    }

    private void drawNumber(PoseStack mat, MultiBufferSource buffer, int number, int floor) {
        this.drawNumber(mat, buffer, number, floor, false);
    }

    private void drawNumber(PoseStack mat, MultiBufferSource buffer, int number, int floor, boolean wide) {
        boolean minus;
        mat.m_85836_();
        --floor;
        float dz = -0.006f;
        boolean bl = minus = number >= 64;
        if (minus) {
            number -= 64;
        }
        double x = (double)(3 - floor & 3) / 4.0;
        double y = (3.0 - (double)(floor >> 2)) / 4.0;
        if (wide) {
            x += -0.25;
        }
        int actFloor = number;
        float[] uvs = this.locationFromNumber(actFloor % 10);
        float[] uvs1 = this.locationFromNumber(actFloor / 10);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 1.0f;
        if (actFloor > 8) {
            mat.m_85837_(x + 0.01, y + 0.06, (double)-0.006f);
            float dx = minus ? -0.03f : 0.0f;
            float dy = -0.0f;
            ControllerRenderer.render(NUMBERS, mat, buffer, 0.0f + dx, 0.0f, 0.15f + dx, 0.15f + dy, 0.0f, 0.0f, 0.0f, 1.0f, uvs);
            ControllerRenderer.render(NUMBERS, mat, buffer, 0.1f + dx, 0.0f, 0.25f + dx, 0.15f + dy, 0.0f, 0.0f, 0.0f, 1.0f, uvs1);
            if (minus) {
                uvs = this.locationFromNumber(-3);
                dx = 0.135f;
                dy = -0.0175f;
                ControllerRenderer.render(NUMBERS, mat, buffer, 0.0f + dx, 0.0f, 0.15f + dx, 0.15f + dy, 0.0f, 0.0f, 0.0f, 1.0f, uvs);
            }
        } else {
            mat.m_85837_(x + 0.05, y + 0.06, (double)-0.006f);
            ControllerRenderer.render(NUMBERS, mat, buffer, 0.0f, 0.0f, 0.15f, 0.15f, 0.0f, 0.0f, 0.0f, 1.0f, uvs);
            if (minus) {
                uvs = this.locationFromNumber(-3);
                float dx = 0.075f;
                ControllerRenderer.render(NUMBERS, mat, buffer, 0.075f, 0.0f, 0.22500001f, 0.15f, 0.0f, 0.0f, 0.0f, 1.0f, uvs);
            }
        }
        mat.m_85849_();
    }

    public void drawOverLay(PoseStack mat, MultiBufferSource buffer, ControllerTile monitor, int floor, Color colour, Direction side, int order, float shift, RenderType type) {
        if (floor > 0 && floor < 17) {
            mat.m_85836_();
            float dz = -0.001f * (float)(1 + order);
            double x = (double)(3 - --floor & 3) / 4.0;
            double y = (3.0 - (double)(floor >> 2)) / 4.0;
            float r = (float)colour.getRed() / 255.0f;
            float g = (float)colour.getGreen() / 255.0f;
            float b = (float)colour.getBlue() / 255.0f;
            float a = (float)colour.getAlpha() / 255.0f;
            mat.m_85837_(x, y, (double)dz);
            ControllerRenderer.render(type, mat, buffer, 0.0f, 0.0f, 0.25f + shift, 0.25f, r, g, b, a, 0.0f, 1.0f, 0.0f, 1.0f);
            mat.m_85849_();
        }
    }

    public void drawOverLay(PoseStack mat, MultiBufferSource buffer, ControllerTile monitor, int floor, Color colour, Direction side, boolean wide, int order) {
        if (!wide) {
            floor -= monitor.getSidePage(side) * 16;
        }
        RenderType type = wide ? OVERLAY_1 : OVERLAY;
        this.drawOverLay(mat, buffer, monitor, floor, colour, side, order, wide ? 0.25f : 0.0f, type);
    }

    public float[] locationFromNumber(int number) {
        float[] ret = new float[4];
        int index = 16 + number;
        int dx = index % 10;
        int dz = index / 10;
        ret[0] = (float)dx / 10.0f;
        ret[2] = (float)dz / 10.0f;
        ret[1] = (float)(1 + dx) / 10.0f;
        ret[3] = (float)(1 + dz) / 10.0f;
        return ret;
    }

    public void render(ControllerTile tileentity, float partialTicks, PoseStack mat, MultiBufferSource buff, int combinedLightIn, int combinedOverlayIn) {
        BlockState copied;
        ControllerTile monitor = tileentity;
        int calledFloor = 0;
        int currentFloor = 0;
        boolean hasLinker = Screen.m_96638_();
        hasLinker = hasLinker && (Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() == TechCore.LINKER.get() || Minecraft.m_91087_().f_91074_.m_21206_().m_41720_() == TechCore.LINKER.get());
        EntityLift lift = monitor.getLift();
        if (lift != null) {
            calledFloor = lift.getCalled() ? lift.getDestinationFloor() : -1;
            currentFloor = lift.getCurrentFloor();
        }
        if ((copied = monitor.copiedState) != null) {
            BlockPos pos;
            mat.m_85836_();
            Level world = monitor.m_58904_();
            BlockPos randPos = pos = monitor.m_58899_();
            if (world instanceof IBlockEntityWorld) {
                IBlockEntityWorld w = (IBlockEntityWorld)world;
                world = w.getWorld();
                randPos = BlockPos.f_121853_;
            }
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            BakedModel model = dispatcher.m_110910_(copied);
            for (RenderType renderType : model.getRenderTypes(copied, RandomSource.m_216335_((long)copied.m_60726_(randPos)), ModelData.EMPTY)) {
                dispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)world, model, copied, pos, mat, buff.m_6299_(renderType), false, RandomSource.m_216327_(), copied.m_60726_(pos), OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
            }
            mat.m_85849_();
        }
        for (int i = 0; i < 6; ++i) {
            Direction dir = Direction.m_122376_((int)i);
            if (!monitor.isSideOn(dir)) continue;
            mat.m_85836_();
            float f = dir.m_122435_();
            mat.m_85837_(0.5, 0.5, 0.5);
            mat.m_85845_(Vector3f.f_122224_.m_122240_(f + 180.0f));
            mat.m_85837_(-0.5, -0.5, -0.5);
            int a = 64;
            if (monitor.isEditMode(dir)) {
                this.drawEditOverlay(mat, buff, monitor, dir);
            } else if (monitor.isFloorDisplay(dir)) {
                colour = new Color(255, 255, 255, 255);
                mat.m_85837_(-0.5, -0.095, 0.0);
                this.drawOverLay(mat, buff, monitor, 1, colour, dir, true, 0);
                mat.m_85836_();
                mat.m_85837_(0.4, 0.0, 0.0);
                this.drawNumber(mat, buff, currentFloor, 1, true);
                mat.m_85849_();
            } else if (monitor.isCallPanel(dir)) {
                colour = new Color(255, 255, 255, 255);
                mat.m_85837_(-0.5, -0.095, 0.0);
                this.drawOverLay(mat, buff, monitor, 1, colour, dir, true, 0);
                if (calledFloor == monitor.floor) {
                    colour = new Color(255, 255, 0, a);
                    this.drawOverLay(mat, buff, monitor, 1, colour, dir, true, 1);
                } else if (currentFloor == monitor.floor) {
                    colour = new Color(0, 128, 255, a);
                    this.drawOverLay(mat, buff, monitor, 1, colour, dir, true, 2);
                }
                mat.m_85836_();
                mat.m_85837_(0.4, 0.0, 0.0);
                this.drawNumber(mat, buff, monitor.floor, 1, true);
                mat.m_85849_();
            } else {
                int page = monitor.getSidePage(dir);
                int pageShift = page * 16;
                if (lift == null) {
                    this.drawFloorNumbers(mat, buff, monitor.getSidePage(dir));
                    Color colour = new Color(255, 255, 255, 255);
                    for (int j = pageShift + 1; j <= 16 + pageShift; ++j) {
                        this.drawOverLay(mat, buff, monitor, j, colour, dir, false, 0);
                    }
                    this.drawFloorNumbers(mat, buff, page);
                    mat.m_85849_();
                    continue;
                }
                Color mapped = new Color(255, 255, 255, 220);
                Color unmapped = new Color(255, 255, 255, 64);
                for (int floor = 1; floor <= 16; ++floor) {
                    int realFloor = floor + pageShift;
                    boolean hasFloor = lift.hasFloor(realFloor);
                    if (hasFloor) {
                        this.drawNumber(mat, buff, realFloor, floor);
                        this.drawOverLay(mat, buff, monitor, realFloor, mapped, dir, false, 0);
                        continue;
                    }
                    if (!hasLinker) continue;
                    this.drawNumber(mat, buff, realFloor, floor);
                    this.drawOverLay(mat, buff, monitor, realFloor, unmapped, dir, false, 0);
                }
                a = 128;
                Color colour = new Color(0, 255, 0, a);
                this.drawOverLay(mat, buff, monitor, monitor.floor, colour, dir, false, 0);
                colour = new Color(255, 255, 0, a);
                this.drawOverLay(mat, buff, monitor, monitor.getLift().getDestinationFloor(), colour, dir, false, 0);
                colour = new Color(0, 128, 255, a);
                this.drawOverLay(mat, buff, monitor, monitor.getLift().getCurrentFloor(), colour, dir, false, 0);
            }
            mat.m_85849_();
        }
    }
}

