/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.maths.Vector3;
import thut.core.common.ThutCore;
import thut.lib.ChatHelper;
import thut.lib.TComponent;
import thut.tech.common.TechCore;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.network.PacketLift;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="thuttech")
public class CommonHandler {
    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        TechCore.packets.registerMessage(PacketLift.class, PacketLift::new);
        MinecraftForge.EVENT_BUS.register(InteractionHelper.class);
        ThutCore.THUTICON = new ItemStack((ItemLike)TechCore.LINKER.get());
    }

    public static class InteractionHelper {
        @SubscribeEvent
        public static void interactRightClickBlock(PlayerInteractEvent.RightClickBlock evt) {
            if (evt.getHand() == InteractionHand.OFF_HAND || evt.getLevel().f_46443_ || evt.getItemStack().m_41619_() || evt.getItemStack().m_41720_() != TechCore.LIFT.get()) {
                return;
            }
            ItemStack itemstack = evt.getItemStack();
            Player playerIn = evt.getEntity();
            Level worldIn = evt.getLevel();
            if (!evt.getEntity().m_6144_()) {
                if (itemstack.m_41782_()) {
                    itemstack.m_41783_().m_128473_("min");
                    itemstack.m_41783_().m_128473_("time");
                    if (itemstack.m_41783_().m_128456_()) {
                        itemstack.m_41751_(null);
                    }
                    String message = "msg.lift.reset";
                    if (!worldIn.f_46443_) {
                        ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)"msg.lift.reset"));
                    }
                    evt.setCanceled(true);
                }
                return;
            }
            BlockPos pos = evt.getPos();
            if (itemstack.m_41782_() && playerIn.m_6144_() && itemstack.m_41783_().m_128441_("min")) {
                CompoundTag minTag = itemstack.m_41783_().m_128469_("min");
                itemstack.m_41783_().m_128356_("time", worldIn.m_46467_());
                BlockPos min = pos;
                BlockPos max = Vector3.readFromNBT((CompoundTag)minTag, (String)"").getPos();
                AABB box = new AABB(min, max);
                min = new BlockPos(box.f_82288_, box.f_82289_, box.f_82290_);
                max = new BlockPos(box.f_82291_, box.f_82292_, box.f_82293_);
                BlockPos mid = min;
                min = min.m_121996_((Vec3i)mid);
                max = max.m_121996_((Vec3i)mid);
                int dw = Math.max(max.m_123341_() - min.m_123341_(), max.m_123343_() - min.m_123343_());
                if (max.m_123342_() - min.m_123342_() > TechCore.config.maxHeight || dw > 2 * TechCore.config.maxRadius + 1) {
                    String message = "msg.lift.toobig";
                    if (!worldIn.f_46443_) {
                        ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)"msg.lift.toobig"));
                    }
                    return;
                }
                int num = (dw + 1) * (max.m_123342_() - min.m_123342_() + 1);
                int count = 0;
                for (ItemStack item : playerIn.m_150109_().f_35974_) {
                    if (item.m_41720_() != TechCore.LIFT.get()) continue;
                    count += item.m_41613_();
                }
                if (!playerIn.m_150110_().f_35937_ && count < num) {
                    String message = "msg.lift.noblock";
                    if (!worldIn.f_46443_) {
                        ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)"msg.lift.noblock", (Object[])new Object[]{num}));
                    }
                    return;
                }
                if (!playerIn.m_150110_().f_35937_) {
                    playerIn.m_150109_().m_36022_(b -> b.m_41720_() == TechCore.LIFT.get(), num, (Container)playerIn.f_36095_.m_39730_());
                }
                if (!worldIn.f_46443_) {
                    EntityLift lift = (EntityLift)IBlockEntity.BlockEntityFormer.makeBlockEntity((Level)worldIn, (BlockPos)min, (BlockPos)max, (BlockPos)mid, (EntityType)((EntityType)TechCore.LIFTTYPE.get()));
                    if (lift != null) {
                        lift.owner = playerIn.m_20148_();
                    }
                    String message = lift != null ? "msg.lift.create" : "msg.lift.fail";
                    ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)message));
                }
                itemstack.m_41783_().m_128473_("min");
                evt.setCanceled(true);
            } else {
                if (!itemstack.m_41782_()) {
                    itemstack.m_41751_(new CompoundTag());
                }
                CompoundTag min = new CompoundTag();
                new Vector3().set((Object)pos).writeToNBT(min, "");
                itemstack.m_41783_().m_128365_("min", (Tag)min);
                String message = "msg.lift.setcorner";
                if (!worldIn.f_46443_) {
                    ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)"msg.lift.setcorner", (Object[])new Object[]{pos}));
                }
                evt.setCanceled(true);
                itemstack.m_41783_().m_128356_("time", worldIn.m_46467_());
            }
        }

        @SubscribeEvent
        public static void interactRightClickBlock(PlayerInteractEvent.RightClickItem evt) {
            boolean alreadyUsed;
            if (evt.getHand() == InteractionHand.OFF_HAND || evt.getLevel().f_46443_ || evt.getItemStack().m_41619_() || evt.getItemStack().m_41720_() != TechCore.LIFT.get()) {
                return;
            }
            ItemStack itemstack = evt.getItemStack();
            Player playerIn = evt.getEntity();
            Level worldIn = evt.getLevel();
            if (!evt.getEntity().m_6144_()) {
                if (itemstack.m_41782_()) {
                    itemstack.m_41783_().m_128473_("min");
                    itemstack.m_41783_().m_128473_("time");
                    if (itemstack.m_41783_().m_128456_()) {
                        itemstack.m_41751_(null);
                    }
                }
                String message = "msg.lift.reset";
                if (!worldIn.f_46443_) {
                    ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)"msg.lift.reset"));
                }
                return;
            }
            boolean validTag = itemstack.m_41782_() && itemstack.m_41783_().m_128441_("min");
            boolean bl = alreadyUsed = validTag && itemstack.m_41783_().m_128454_("time") - worldIn.m_46467_() == 0L;
            if (validTag && !alreadyUsed) {
                BlockPos pos;
                CompoundTag minTag = itemstack.m_41783_().m_128469_("min");
                Vec3 loc = playerIn.m_20182_().m_82520_(0.0, (double)playerIn.m_20192_(), 0.0).m_82549_(playerIn.m_20154_().m_82490_(2.0));
                BlockPos min = pos = new BlockPos(loc);
                BlockPos max = Vector3.readFromNBT((CompoundTag)minTag, (String)"").getPos();
                AABB box = new AABB(min, max);
                min = new BlockPos(box.f_82288_, box.f_82289_, box.f_82290_);
                max = new BlockPos(box.f_82291_, box.f_82292_, box.f_82293_);
                BlockPos mid = min;
                min = min.m_121996_((Vec3i)mid);
                max = max.m_121996_((Vec3i)mid);
                int dw = Math.max(max.m_123341_() - min.m_123341_(), max.m_123343_() - min.m_123343_());
                if (max.m_123342_() - min.m_123342_() > TechCore.config.maxHeight || dw > 2 * TechCore.config.maxRadius + 1) {
                    String message = "msg.lift.toobig";
                    if (!worldIn.f_46443_) {
                        ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)"msg.lift.toobig"));
                    }
                    return;
                }
                int num = (dw + 1) * (max.m_123342_() - min.m_123342_() + 1);
                int count = 0;
                for (ItemStack item : playerIn.m_150109_().f_35974_) {
                    if (item.m_41720_() != TechCore.LIFT.get()) continue;
                    count += item.m_41613_();
                }
                if (!playerIn.m_150110_().f_35937_ && count < num) {
                    String message = "msg.lift.noblock";
                    if (!worldIn.f_46443_) {
                        ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)"msg.lift.noblock", (Object[])new Object[]{num}));
                    }
                    return;
                }
                if (!playerIn.m_150110_().f_35937_) {
                    playerIn.m_150109_().m_36022_(i -> i.m_41720_() == TechCore.LIFT.get(), num, (Container)playerIn.f_36095_.m_39730_());
                }
                if (!worldIn.f_46443_) {
                    EntityLift lift = (EntityLift)IBlockEntity.BlockEntityFormer.makeBlockEntity((Level)worldIn, (BlockPos)min, (BlockPos)max, (BlockPos)mid, (EntityType)((EntityType)TechCore.LIFTTYPE.get()));
                    if (lift != null) {
                        lift.owner = playerIn.m_20148_();
                    }
                    String message = lift != null ? "msg.lift.create" : "msg.lift.fail";
                    ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)message));
                }
                itemstack.m_41783_().m_128473_("min");
            }
        }
    }
}

