/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.core.common.ThutCore;
import thut.core.common.config.Config;
import thut.core.common.network.PacketHandler;
import thut.tech.common.blocks.lift.ControllerBlock;
import thut.tech.common.blocks.lift.ControllerTile;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.handlers.ConfigHandler;
import thut.tech.common.items.ItemLinker;
import thut.tech.common.util.RecipeSerializers;

@Mod(value="thuttech")
public class TechCore {
    public static final PacketHandler packets = new PacketHandler(new ResourceLocation("thuttech", "comms"), "1.0.1");
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<EntityType<?>> ENTITY;
    public static final DeferredRegister<BlockEntityType<?>> TILEENTITY;
    public static final RegistryObject<Block> LIFTCONTROLLER;
    public static final RegistryObject<Item> LIFT;
    public static final RegistryObject<Item> LINKER;
    public static final RegistryObject<EntityType<EntityLift>> LIFTTYPE;
    public static final RegistryObject<BlockEntityType<ControllerTile>> CONTROLTYPE;
    public static final ConfigHandler config;

    public TechCore() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        RecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCKS.register(modEventBus);
        TILEENTITY.register(modEventBus);
        ENTITY.register(modEventBus);
        Config.setupConfigs((Config.IConfigHolder)config, (String)"thuttech", (String)"thuttech");
    }

    static {
        config = new ConfigHandler("thuttech");
        TILEENTITY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"thuttech");
        ENTITY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"thuttech");
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"thuttech");
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"thuttech");
        LIFTTYPE = ENTITY.register("lift", () -> new BlockEntityBase.BlockEntityType(EntityLift::new));
        CONTROLTYPE = TILEENTITY.register("controller", () -> BlockEntityType.Builder.m_155273_(ControllerTile::new, (Block[])new Block[]{(Block)LIFTCONTROLLER.get()}).m_58966_(null));
        LIFTCONTROLLER = BLOCKS.register("controller", () -> new ControllerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.5f).m_60988_().m_60955_()));
        LIFT = ITEMS.register("lift", () -> new Item(new Item.Properties().m_41491_(ThutCore.THUTITEMS)));
        LINKER = ITEMS.register("linker", () -> new ItemLinker(new Item.Properties().m_41491_(ThutCore.THUTITEMS)));
        for (RegistryObject reg : BLOCKS.getEntries()) {
            ITEMS.register(reg.getId().m_135815_(), () -> new BlockItem((Block)reg.get(), new Item.Properties().m_41491_(ThutCore.THUTITEMS)));
        }
    }
}

