/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.lift;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import thut.api.block.ITickTile;
import thut.core.common.network.TileUpdate;
import thut.lib.ChatHelper;
import thut.lib.TComponent;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.ControllerTile;

public class ControllerBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty CALLED = BooleanProperty.m_61465_((String)"called");
    public static final BooleanProperty MASKED = BooleanProperty.m_61465_((String)"masked");
    public static final BooleanProperty CURRENT = BooleanProperty.m_61465_((String)"current");

    public ControllerBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CALLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)MASKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CURRENT, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ControllerTile(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ITickTile.getTicker((Level)level, (BlockState)state, type);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CALLED});
        builder.m_61104_(new Property[]{CURRENT});
        builder.m_61104_(new Property[]{MASKED});
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        ControllerTile te = (ControllerTile)blockAccess.m_7702_(pos);
        boolean here = (Boolean)blockState.m_61143_((Property)CURRENT);
        boolean called = (Boolean)blockState.m_61143_((Property)CALLED);
        if (te.isSideOn(side = side.m_122424_())) {
            if (te.isCallPanel(side)) {
                return called ? 15 : 0;
            }
            if (te.isFloorDisplay(side)) {
                return here ? 15 : 0;
            }
            return here ? 5 : 0;
        }
        return 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        ControllerTile te = (ControllerTile)blockAccess.m_7702_(pos);
        boolean here = (Boolean)blockState.m_61143_((Property)CURRENT);
        boolean called = (Boolean)blockState.m_61143_((Property)CALLED);
        if (te.isSideOn(side = side.m_122424_())) {
            if (te.isCallPanel(side)) {
                return called ? 15 : 0;
            }
            if (te.isFloorDisplay(side)) {
                return here ? 15 : 0;
            }
        }
        return 0;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        ControllerTile te = (ControllerTile)world.m_7702_(pos);
        side = side.m_122424_();
        boolean called = (Boolean)state.m_61143_((Property)CALLED);
        return te.isCallPanel(side) && !called;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = playerIn.m_21120_(handIn);
        Direction side = hit.m_82434_();
        boolean linkerOrStick = heldItem.m_41720_() == Items.f_42398_ || heldItem.m_41720_() == TechCore.LINKER.get();
        BlockEntity be = worldIn.m_7702_(pos);
        if (!(be instanceof ControllerTile)) {
            return InteractionResult.PASS;
        }
        ControllerTile te = (ControllerTile)be;
        if (!be.m_58898_()) {
            be.m_142339_(worldIn);
        }
        if (linkerOrStick && playerIn.m_6144_()) {
            if (te.isSideOn(side)) {
                te.setSide(side, false);
                if (!te.m_58904_().f_46443_) {
                    TileUpdate.sendUpdate((BlockEntity)te);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (!linkerOrStick && side == Direction.DOWN) {
            Item item = heldItem.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem block = (BlockItem)item;
                BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(playerIn, handIn, hit));
                te.copiedState = block.m_40614_().m_5573_(context);
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)MASKED, (Comparable)Boolean.valueOf(true)));
                if (!te.m_58904_().f_46443_) {
                    TileUpdate.sendUpdate((BlockEntity)te);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (!te.isSideOn(side) || heldItem.m_41720_() == Items.f_42398_) {
            if (linkerOrStick) {
                if (!worldIn.f_46443_) {
                    te.setSide(side, !te.isSideOn(side));
                    if (playerIn instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)playerIn;
                        te.sendUpdate(player);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (te.isSideOn(side)) {
            if (heldItem.m_41720_() == TechCore.LINKER.get()) {
                if (!(worldIn.f_46443_ || te.isEditMode(side) || te.isFloorDisplay(side))) {
                    te.setSidePage(side, (te.getSidePage(side) + 1) % 8);
                    if (playerIn instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)playerIn;
                        te.sendUpdate(player);
                    }
                    TileUpdate.sendUpdate((BlockEntity)te);
                }
                return InteractionResult.SUCCESS;
            }
            if (!playerIn.m_6144_()) {
                float hitX = (float)hit.m_82450_().f_82479_;
                float hitY = (float)hit.m_82450_().f_82480_;
                float hitZ = (float)hit.m_82450_().f_82481_;
                return te.doButtonClick((LivingEntity)playerIn, side, hitX, hitY, hitZ) ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        }
        if (playerIn.m_6144_() && handIn == InteractionHand.MAIN_HAND && playerIn instanceof ServerPlayer) {
            boolean sideOn = !te.isSideOn(side);
            ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)("msg.lift.side." + (sideOn ? "on" : "off"))));
            if (sideOn) {
                boolean call = te.isCallPanel(side);
                boolean edit = te.isEditMode(side);
                boolean display = te.isFloorDisplay(side);
                if (edit) {
                    ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)"msg.lift.side.edit"));
                } else if (call) {
                    ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)"msg.lift.side.call"));
                } else if (display) {
                    ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)"msg.lift.side.display"));
                } else {
                    int page = te.getSidePage(side);
                    ChatHelper.sendSystemMessage((Player)playerIn, (Component)TComponent.translatable((String)"msg.lift.side.page", (Object[])new Object[]{page}));
                }
            }
        }
        return InteractionResult.PASS;
    }
}

