/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.lift;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import net.minecraftforge.eventbus.api.Event;
import thut.api.block.ITickTile;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.entity.blockentity.world.IBlockEntityWorld;
import thut.api.maths.Vector3;
import thut.core.common.network.TileUpdate;
import thut.lib.ChatHelper;
import thut.lib.TComponent;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.ControllerBlock;
import thut.tech.common.blocks.lift.ControllerUpdate;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.network.PacketLift;

public class ControllerTile
extends BlockEntity
implements ITickTile {
    public int power = 0;
    public int prevPower = 1;
    private EntityLift lift;
    public BlockState copiedState = null;
    boolean listNull = false;
    List<Entity> list = new ArrayList<Entity>();
    Vector3 here;
    public ControllerTile rootNode;
    public Vector<ControllerTile> connected = new Vector();
    Direction sourceSide;
    boolean loaded = false;
    public int floor = 0;
    public UUID liftID = null;
    UUID empty = new UUID(0L, 0L);
    private byte[] sides = new byte[6];
    private byte[] sidePages = new byte[6];
    int tries = 0;
    public boolean toClear = false;
    public boolean first = true;
    public boolean read = false;
    public boolean redstone = true;
    public boolean powered = false;
    public boolean[] callFaces = new boolean[6];
    public boolean[] editFace = new boolean[6];
    public boolean[] floorDisplay = new boolean[6];
    private int tick = 0;

    public ControllerTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)TechCore.CONTROLTYPE.get(), pos, state);
    }

    public ControllerTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void buttonPress(int button, boolean callPanel) {
        if (callPanel && this.getLift() != null) {
            this.getLift().call(this.floor);
        } else if (button != 0 && button <= this.getLift().maxFloors() && this.getLift() != null && this.getLift().hasFloor(button)) {
            if (button != this.floor && this.getLift().getCurrentFloor() == this.floor) {
                this.getLift().setCurrentFloor(-1);
            }
            this.getLift().call(button);
        }
    }

    public boolean checkSides() {
        List check = this.f_58857_.m_45976_(EntityLift.class, new AABB((double)this.m_58899_().m_123341_() + 0.5 - 1.0, (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_() + 0.5 - 1.0, (double)this.m_58899_().m_123341_() + 0.5 + 1.0, (double)(this.m_58899_().m_123342_() + 1), (double)this.m_58899_().m_123343_() + 0.5 + 1.0));
        if (check != null && check.size() > 0) {
            this.setLift((EntityLift)((Object)check.get(0)));
            this.liftID = this.getLift().m_20148_();
        }
        return check != null && !check.isEmpty();
    }

    public String connectionInfo() {
        String ret = "";
        return "";
    }

    public boolean doButtonClick(LivingEntity clicker, Direction side, float hitX, float hitY, float hitZ) {
        boolean valid;
        int button = this.getButtonFromClick(side, hitX, hitY, hitZ);
        boolean bl = valid = this.getLift() != null && this.getLift().hasFloor(button);
        if (!this.isSideOn(side)) {
            return false;
        }
        if (this.isEditMode(side)) {
            if (!this.m_58904_().f_46443_ && clicker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)clicker;
                String message = "msg.callPanel";
                switch (button) {
                    case 1: {
                        this.callFaces[side.ordinal()] = !this.isCallPanel(side);
                        this.floorDisplay[side.ordinal()] = false;
                        ChatHelper.sendSystemMessage((Player)player, (Component)TComponent.translatable((String)message, (Object[])new Object[]{this.isCallPanel(side)}));
                        break;
                    }
                    case 2: {
                        this.floorDisplay[side.ordinal()] = !this.isFloorDisplay(side);
                        this.callFaces[side.ordinal()] = false;
                        message = "msg.floorDisplay";
                        ChatHelper.sendSystemMessage((Player)player, (Component)TComponent.translatable((String)message, (Object[])new Object[]{this.isFloorDisplay(side)}));
                        break;
                    }
                    case 13: {
                        if (this.getLift() == null) break;
                        this.setLift(null);
                        break;
                    }
                    case 16: {
                        this.editFace[side.ordinal()] = false;
                        message = "msg.editMode";
                        ChatHelper.sendSystemMessage((Player)player, (Component)TComponent.translatable((String)message, (Object[])new Object[]{false}));
                    }
                }
                if (clicker instanceof ServerPlayer) {
                    this.sendUpdate((ServerPlayer)clicker);
                }
            }
            return true;
        }
        if (this.isFloorDisplay(side)) {
            return false;
        }
        if (this.m_58904_().f_46443_) {
            boolean callPanel = this.isCallPanel(side);
            PacketLift.sendButtonPress(this.getLift(), this.m_58899_(), button, callPanel);
        }
        if (clicker instanceof ServerPlayer) {
            this.sendUpdate((ServerPlayer)clicker);
        }
        return valid;
    }

    public int getButtonFromClick(Direction side, double x, double y, double z) {
        int ret = 0;
        x -= (double)this.m_58899_().m_123341_();
        y -= (double)this.m_58899_().m_123342_();
        z -= (double)this.m_58899_().m_123343_();
        x %= 1.0;
        y %= 1.0;
        z %= 1.0;
        x = Math.abs(x);
        y = Math.abs(y);
        z = Math.abs(z);
        int page = this.getSidePage(side);
        switch (side.m_122411_()) {
            case 0: {
                return 0 + 16 * page;
            }
            case 1: {
                ret = 1 + (int)((1.0 - x) * 4.0 % 4.0) + 4 * (int)((1.0 - z) * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 2: {
                ret = 1 + (int)((1.0 - x) * 4.0 % 4.0) + 4 * (int)((1.0 - y) * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 3: {
                ret = 1 + (int)(x * 4.0 % 4.0) + 4 * (int)((1.0 - y) * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 4: {
                ret = 1 + 4 * (int)((1.0 - y) * 4.0 % 4.0) + (int)(z * 4.0 % 4.0);
                return ret + 16 * page;
            }
            case 5: {
                ret = 1 + 4 * (int)((1.0 - y) * 4.0 % 4.0) + (int)((1.0 - z) * 4.0 % 4.0);
                return ret + 16 * page;
            }
        }
        return 0 + 16 * page;
    }

    public AABB getRenderBoundingBox() {
        AABB bb = IForgeBlockEntity.INFINITE_EXTENT_AABB;
        return bb;
    }

    public int getSidePage(Direction side) {
        if (this.isEditMode(side)) {
            return 0;
        }
        return this.sidePages[side.m_122411_()];
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public boolean isSideOn(Direction side) {
        boolean state = true;
        byte byte0 = this.sides[side.m_122411_()];
        return (byte0 & 1) != 0;
    }

    public boolean isCallPanel(Direction side) {
        return this.callFaces[side.m_122411_()];
    }

    public boolean isFloorDisplay(Direction side) {
        return this.floorDisplay[side.m_122411_()];
    }

    public boolean isEditMode(Direction side) {
        return this.editFace[side.m_122411_()];
    }

    public void m_142466_(CompoundTag par1) {
        super.m_142466_(par1);
        this.floor = par1.m_128451_("floor");
        this.lift = null;
        if (par1.m_128403_("lift")) {
            this.liftID = par1.m_128342_("lift");
        }
        this.sides = par1.m_128463_("sides");
        for (Direction face : Direction.Plane.HORIZONTAL) {
            this.callFaces[face.ordinal()] = par1.m_128471_(face + "Call");
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            this.editFace[face.ordinal()] = par1.m_128471_(face + "Edit");
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            this.floorDisplay[face.ordinal()] = par1.m_128471_(face + "Display");
        }
        if (this.sides.length != 6) {
            this.sides = new byte[6];
        }
        this.sidePages = par1.m_128463_("sidePages");
        if (this.sidePages.length != 6) {
            this.sidePages = new byte[6];
        }
        if (par1.m_128441_("state")) {
            CompoundTag state = par1.m_128469_("state");
            this.copiedState = NbtUtils.m_129241_((CompoundTag)state);
        }
    }

    public void sendUpdate(ServerPlayer player) {
        if (this.f_58857_ instanceof IBlockEntityWorld) {
            return;
        }
        TileUpdate.sendUpdate((BlockEntity)this);
    }

    public void setFloor(int floor) {
        if (this.getLift() == null) {
            return;
        }
        if (this.getLift().setFoor(this, floor)) {
            this.floor = floor;
            this.m_6596_();
        }
    }

    public void setLift(EntityLift lift) {
        if (lift == null && this.lift != null) {
            this.lift.setFoor(null, this.floor);
        }
        this.lift = lift;
        this.liftID = lift != null ? lift.m_20148_() : null;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            TileUpdate.sendUpdate((BlockEntity)this);
        }
    }

    public void setSide(Direction side, boolean flag) {
        boolean state = true;
        byte byte0 = this.sides[side.m_122411_()];
        if (side.m_122411_() < 2) {
            return;
        }
        this.sides[side.m_122411_()] = flag ? (byte)(byte0 | 1) : (byte)(byte0 & 0xFFFFFFFE);
        this.m_6596_();
    }

    public void setSidePage(Direction side, int page) {
        this.sidePages[side.m_122411_()] = (byte)page;
    }

    public void m_142339_(Level worldIn) {
        IBlockEntityWorld beworld;
        IBlockEntity blockEntity;
        this.f_58857_ = worldIn;
        if (worldIn instanceof IBlockEntityWorld && (blockEntity = (beworld = (IBlockEntityWorld)worldIn).getBlockEntity()) instanceof EntityLift) {
            EntityLift lift = (EntityLift)blockEntity;
            this.setLift(lift);
        }
    }

    public void tick() {
        if (this.here == null) {
            this.here = new Vector3();
        }
        this.here.set((Object)this);
        EntityLift lift = this.getLift();
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.f_58857_ instanceof IBlockEntityWorld) {
            return;
        }
        if (!(this.floor <= 0 || lift != null && lift.m_6084_())) {
            this.setLift(null);
            lift = null;
            this.floor = 0;
        }
        if (lift == null && this.tick++ % 50 == 0) {
            for (Direction side : Direction.values()) {
                ControllerTile te;
                BlockEntity t = this.here.getTileEntity((BlockGetter)this.f_58857_, side);
                this.here.getBlock((BlockGetter)this.f_58857_, side);
                if (!(t instanceof ControllerTile) || (te = (ControllerTile)t).getLift() == null) continue;
                lift = te.getLift();
                this.setLift(lift);
                this.floor = te.floor;
                this.m_6596_();
                break;
            }
        }
        if (lift == null) {
            return;
        }
        if (this.floor > 0) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            boolean current = (Boolean)state.m_61143_((Property)ControllerBlock.CURRENT);
            boolean called = (Boolean)state.m_61143_((Property)ControllerBlock.CALLED);
            int yWhenLiftHere = this.getLift().getFloorPos(this.floor);
            if ((int)Math.round(this.getLift().m_20186_()) == yWhenLiftHere) {
                lift.setCurrentFloor(this.floor);
            } else if (this.getLift().getCurrentFloor() == this.floor) {
                lift.setCurrentFloor(-1);
            }
            if (!this.f_58857_.f_46443_) {
                boolean shouldBeCalled;
                boolean shouldBeCurrent = lift.m_20183_().m_123342_() == yWhenLiftHere;
                boolean bl = shouldBeCalled = lift.getCalled() && lift.getDestY() == (float)yWhenLiftHere;
                if (current && !shouldBeCurrent) {
                    this.f_58857_.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)ControllerBlock.CURRENT, (Comparable)Boolean.valueOf(false)));
                } else if (!current && shouldBeCurrent) {
                    this.f_58857_.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)ControllerBlock.CURRENT, (Comparable)Boolean.valueOf(true)));
                }
                if (called && !shouldBeCalled) {
                    this.f_58857_.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)ControllerBlock.CALLED, (Comparable)Boolean.valueOf(false)));
                } else if (!called && shouldBeCalled) {
                    this.f_58857_.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)ControllerBlock.CALLED, (Comparable)Boolean.valueOf(true)));
                }
                current = (Boolean)state.m_61143_((Property)ControllerBlock.CURRENT);
                called = (Boolean)state.m_61143_((Property)ControllerBlock.CALLED);
                if (!current && !called) {
                    for (Direction facing : Direction.values()) {
                        int power;
                        if (!this.isCallPanel(facing) || (power = this.f_58857_.m_46681_(this.m_58899_(), facing.m_122424_())) <= 0) continue;
                        lift.call(this.floor);
                    }
                }
                MinecraftForge.EVENT_BUS.post((Event)new ControllerUpdate(this));
            }
        }
    }

    public void m_183515_(CompoundTag par1) {
        super.m_183515_(par1);
        par1.m_128405_("floor", this.floor);
        par1.m_128382_("sides", this.sides);
        par1.m_128382_("sidePages", this.sidePages);
        for (Direction face : Direction.Plane.HORIZONTAL) {
            par1.m_128379_(face + "Call", this.callFaces[face.ordinal()]);
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            par1.m_128379_(face + "Edit", this.editFace[face.ordinal()]);
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            par1.m_128379_(face + "Display", this.floorDisplay[face.ordinal()]);
        }
        if (this.lift != null) {
            this.liftID = this.lift.m_20148_();
        }
        if (this.liftID != null) {
            par1.m_128362_("lift", this.liftID);
        }
        if (this.copiedState != null) {
            CompoundTag state = NbtUtils.m_129202_((BlockState)this.copiedState);
            par1.m_128365_("state", (Tag)state);
        }
    }

    public EntityLift getLift() {
        if (this.liftID == null) {
            return null;
        }
        if (this.lift == null) {
            this.lift = EntityLift.getLiftFromUUID(this.liftID, this.m_58904_());
            if (this.m_58904_().f_46443_) {
                if (this.lift != null) {
                    this.setLift(this.lift);
                }
                return this.lift;
            }
            if (this.lift == null) {
                this.setLift(null);
            } else {
                this.setLift(this.lift);
                if (this.floor > 0 && !this.getLift().hasFloor(this.floor)) {
                    this.setFloor(this.floor);
                }
            }
        }
        return this.lift;
    }
}

