/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import thut.api.ThutCaps;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.maths.Vector3;
import thut.core.common.ThutCore;
import thut.core.common.network.EntityUpdate;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.ControllerTile;
import thut.tech.common.entity.EventLiftConsumePower;
import thut.tech.common.entity.LiftInteractHandler;

public class EntityLift
extends BlockEntityBase {
    static final EntityDataAccessor<Integer> DESTINATIONFLOORDW = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    static final EntityDataAccessor<Float> DESTINATIONYDW = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    static final EntityDataAccessor<Float> DESTINATIONXDW = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    static final EntityDataAccessor<Float> DESTINATIONZDW = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    static final EntityDataAccessor<Integer> CURRENTFLOORDW = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    static final EntityDataAccessor<Boolean> CALLEDDW = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    static final EntityDataAccessor<Float> SPEEDUP = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    static final EntityDataAccessor<Float> SPEEDDOWN = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    static final EntityDataAccessor<Float> SPEEDSIDE = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    static final EntityDataAccessor<Float> ACCEL = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static boolean ENERGYUSE = false;
    public static int ENERGYCOST = 100;
    public IEnergyStorage energy = null;
    public UUID owner;
    public double prevFloorY = 0.0;
    public double prevFloor = 0.0;
    private final int[] floors = new int[128];
    private final int[] hasFloors = new int[128];
    EntityDimensions size;

    public static EntityLift getLiftFromUUID(UUID liftID, Level world) {
        ServerLevel level;
        Entity e;
        if (world instanceof ServerLevel && (e = (level = (ServerLevel)world).m_8791_(liftID)) instanceof EntityLift) {
            EntityLift lift = (EntityLift)e;
            return lift;
        }
        return LiftTracker.liftMap.get(liftID);
    }

    public EntityLift(EntityType<EntityLift> type, Level par1World) {
        super(type, par1World);
    }

    protected Vector3 getForceDirection() {
        this.updateForce();
        return this.F;
    }

    public void updateForce() {
        this.f_19804_.m_135381_(SPEEDUP, (Object)Float.valueOf((float)TechCore.config.LiftSpeedUp));
        this.f_19804_.m_135381_(SPEEDDOWN, (Object)Float.valueOf((float)TechCore.config.LiftSpeedDown));
        this.f_19804_.m_135381_(SPEEDSIDE, (Object)Float.valueOf((float)TechCore.config.LiftSpeedSideways));
        this.f_19804_.m_135381_(ACCEL, (Object)Float.valueOf((float)TechCore.config.LiftAcceleration));
        this.F.clear();
        this.m_146922_(0.0f);
        if (this.isServerWorld() && !this.consumePower()) {
            this.toMoveZ = false;
            this.toMoveX = false;
            this.toMoveY = false;
            this.setCalled(false);
        }
        if (!this.getCalled()) {
            this.setDestX((float)this.m_20185_());
            this.setDestY((float)this.m_20186_());
            this.setDestZ((float)this.m_20189_());
            this.toMoveZ = false;
            this.toMoveX = false;
            this.toMoveY = false;
        } else {
            this.toMoveX = (double)this.getDestX() != this.m_20185_();
            this.toMoveY = (double)this.getDestY() != this.m_20186_();
            boolean bl = this.toMoveZ = (double)this.getDestZ() != this.m_20189_();
        }
        if (!(this.toMoveX || this.toMoveY || this.toMoveZ)) {
            this.setCalled(false);
        }
        double F_x = (double)this.getDestX() - this.m_20185_();
        double F_y = (double)this.getDestY() - this.m_20186_();
        double F_z = (double)this.getDestZ() - this.m_20189_();
        if (!this.toMoveX) {
            F_x = 0.0;
        }
        if (!this.toMoveY) {
            F_y = 0.0;
        }
        if (!this.toMoveZ) {
            F_z = 0.0;
        }
        this.F.set(F_x, F_y, F_z);
    }

    public void call(int floor) {
        if (floor > 0 && floor <= this.floors.length) {
            if (!this.isServerWorld()) {
                return;
            }
            if (this.hasFloor(floor)) {
                this.callYValue(this.getFloorPos(floor));
                this.setDestinationFloor(floor);
                ThutCore.LOGGER.debug("Lift Called to floor: " + floor);
            }
        } else {
            ThutCore.LOGGER.error("Set floor out of range!");
        }
    }

    public void callYValue(int yValue) {
        this.setDestY(yValue);
    }

    protected boolean checkAccelerationConditions() {
        this.consumePower();
        return true;
    }

    private boolean consumePower() {
        if (!ENERGYUSE || !this.getCalled()) {
            return true;
        }
        if (this.energy == null) {
            this.energy = (IEnergyStorage)this.getCapability(ThutCaps.ENERGY, null).orElse(null);
        }
        if (this.energy == null) {
            return true;
        }
        boolean power = false;
        Vector3 bounds = new Vector3().set((Object)this.boundMax.m_121996_((Vec3i)this.boundMin));
        double volume = bounds.x * bounds.y * bounds.z;
        int energyCost = (int)(Math.abs((double)this.getDestY() - this.m_20186_()) * (double)ENERGYCOST * volume * 0.01);
        int canExtract = this.energy.extractEnergy(energyCost = Math.max(energyCost, 1), true);
        if (canExtract == energyCost) {
            power = true;
            this.energy.extractEnergy(energyCost, false);
        }
        MinecraftForge.EVENT_BUS.post((Event)new EventLiftConsumePower(this, energyCost));
        if (!power) {
            this.setDestinationFloor(-1);
            this.setDestY((float)this.m_20186_());
            this.setCalled(false);
            this.toMoveY = false;
        }
        return power;
    }

    protected BlockEntityInteractHandler createInteractHandler() {
        return new LiftInteractHandler(this);
    }

    public boolean getCalled() {
        return (Boolean)this.f_19804_.m_135370_(CALLEDDW);
    }

    public int getCurrentFloor() {
        return (Integer)this.f_19804_.m_135370_(CURRENTFLOORDW);
    }

    public int getDestinationFloor() {
        return (Integer)this.f_19804_.m_135370_(DESTINATIONFLOORDW);
    }

    public float getDestX() {
        return ((Float)this.f_19804_.m_135370_(DESTINATIONXDW)).floatValue();
    }

    public float getDestY() {
        return ((Float)this.f_19804_.m_135370_(DESTINATIONYDW)).floatValue();
    }

    public float getDestZ() {
        return ((Float)this.f_19804_.m_135370_(DESTINATIONZDW)).floatValue();
    }

    public float getSpeedUp() {
        return ((Float)this.f_19804_.m_135370_(SPEEDUP)).floatValue();
    }

    public float getSpeedDown() {
        return ((Float)this.f_19804_.m_135370_(SPEEDDOWN)).floatValue();
    }

    public float getSpeedHoriz() {
        return ((Float)this.f_19804_.m_135370_(SPEEDSIDE)).floatValue();
    }

    public float getAccel() {
        return ((Float)this.f_19804_.m_135370_(ACCEL)).floatValue();
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.size == null) {
            this.size = EntityDimensions.m_20398_((float)(1 + this.getMax().m_123341_() - this.getMin().m_123341_()), (float)this.getMax().m_123342_());
        }
        return this.size;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        LiftTracker.liftMap.put(this.m_20148_(), this);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        LiftTracker.liftMap.remove(this.m_20148_(), (Object)this);
    }

    protected void onGridAlign() {
        this.setCalled(false);
    }

    protected void preColliderTick() {
    }

    public void m_7378_(CompoundTag arg0) {
        super.m_7378_(arg0);
        CompoundTag tag = arg0.m_128469_("floors");
        for (int i = 0; i < this.hasFloors.length; ++i) {
            int num;
            if (!tag.m_128441_("" + i)) continue;
            int floor = tag.m_128451_("" + i);
            this.hasFloors[i] = num = tag.m_128451_("_" + i);
            this.floors[i] = floor;
        }
        if (arg0.m_128403_("owner")) {
            this.owner = arg0.m_128342_("owner");
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DESTINATIONFLOORDW, (Object)0);
        this.f_19804_.m_135372_(DESTINATIONYDW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DESTINATIONXDW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DESTINATIONZDW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CURRENTFLOORDW, (Object)-1);
        this.f_19804_.m_135372_(CALLEDDW, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(SPEEDUP, (Object)Float.valueOf((float)TechCore.config.LiftSpeedUp));
        this.f_19804_.m_135372_(SPEEDDOWN, (Object)Float.valueOf((float)TechCore.config.LiftSpeedDown));
        this.f_19804_.m_135372_(SPEEDSIDE, (Object)Float.valueOf((float)TechCore.config.LiftSpeedSideways));
        this.f_19804_.m_135372_(ACCEL, (Object)Float.valueOf((float)TechCore.config.LiftAcceleration));
    }

    private void setCalled(boolean called) {
        this.f_19804_.m_135381_(CALLEDDW, (Object)called);
    }

    public void setCurrentFloor(int currentFloor) {
        this.f_19804_.m_135381_(CURRENTFLOORDW, (Object)currentFloor);
    }

    public void setDestinationFloor(int destinationFloor) {
        this.f_19804_.m_135381_(DESTINATIONFLOORDW, (Object)destinationFloor);
    }

    public void setDestX(float dest) {
        this.f_19804_.m_135381_(DESTINATIONXDW, (Object)Float.valueOf(dest));
        this.f_19804_.m_135381_(DESTINATIONYDW, (Object)Float.valueOf((float)this.m_20186_()));
        this.f_19804_.m_135381_(DESTINATIONZDW, (Object)Float.valueOf((float)this.m_20189_()));
        this.setCalled(true);
    }

    public void setDestY(float dest) {
        this.f_19804_.m_135381_(DESTINATIONYDW, (Object)Float.valueOf(dest));
        this.f_19804_.m_135381_(DESTINATIONXDW, (Object)Float.valueOf((float)this.m_20185_()));
        this.f_19804_.m_135381_(DESTINATIONZDW, (Object)Float.valueOf((float)this.m_20189_()));
        this.setCalled(true);
    }

    public void setDestZ(float dest) {
        this.f_19804_.m_135381_(DESTINATIONZDW, (Object)Float.valueOf(dest));
        this.f_19804_.m_135381_(DESTINATIONYDW, (Object)Float.valueOf((float)this.m_20186_()));
        this.f_19804_.m_135381_(DESTINATIONXDW, (Object)Float.valueOf((float)this.m_20185_()));
        this.setCalled(true);
    }

    public boolean setFoor(ControllerTile te, int floor) {
        if (--floor < 0 || floor >= this.floors.length) {
            return false;
        }
        if (te != null) {
            int prev;
            boolean changed = false;
            if (this.hasFloors[floor] <= 0) {
                this.floors[floor] = te.m_58899_().m_123342_() - 2;
            }
            int n = floor;
            this.hasFloors[n] = this.hasFloors[n] + 1;
            changed = true;
            if (changed && (prev = te.floor - 1) != -1 && prev != floor && this.hasFloors[prev] > 0) {
                int n2 = prev;
                this.hasFloors[n2] = this.hasFloors[n2] - 1;
            }
        } else if (this.hasFloors[floor] > 0) {
            int n = floor;
            this.hasFloors[n] = this.hasFloors[n] - 1;
            if (this.hasFloors[floor] <= 0) {
                this.floors[floor] = 0;
            }
        }
        if (this.isServerWorld()) {
            EntityUpdate.sendEntityUpdate((Entity)this);
        }
        return true;
    }

    public void setFloorPos(int floor, int posY) {
        if (--floor >= 0 && floor < this.floors.length) {
            this.floors[floor] = posY;
        }
        ThutCore.LOGGER.error("Set floor out of range!");
    }

    public int getFloorPos(int floor) {
        if (--floor >= 0 && floor < this.floors.length) {
            return this.floors[floor];
        }
        ThutCore.LOGGER.error("Requested floor out of range!");
        return 0;
    }

    public boolean hasFloor(int floor) {
        if (--floor >= 0 && floor < this.hasFloors.length) {
            return this.hasFloors[floor] > 0;
        }
        ThutCore.LOGGER.error("Checked floor out of range!");
        return false;
    }

    public int maxFloors() {
        return this.hasFloors.length;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public void setSize(EntityDimensions size) {
        this.size = size;
    }

    public void setTiles(BlockEntity[][][] tiles) {
        super.setTiles(tiles);
        BlockEntity[][][] blockEntityArray = tiles;
        int n = blockEntityArray.length;
        for (int i = 0; i < n; ++i) {
            BlockEntity[][] tileArrArr;
            BlockEntity[][] blockEntityArray2 = tileArrArr = blockEntityArray[i];
            int n2 = blockEntityArray2.length;
            for (int j = 0; j < n2; ++j) {
                BlockEntity[] tileArr;
                for (BlockEntity tile : tileArr = blockEntityArray2[j]) {
                    if (!(tile instanceof ControllerTile)) continue;
                    ControllerTile controller = (ControllerTile)tile;
                    controller.setLift(this);
                    controller.m_142339_((Level)this.getFakeWorld());
                }
            }
        }
    }

    public void m_7380_(CompoundTag arg0) {
        super.m_7380_(arg0);
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.hasFloors.length; ++i) {
            if (this.hasFloors[i] <= 0) continue;
            tag.m_128405_("" + i, this.floors[i]);
            tag.m_128405_("_" + i, this.hasFloors[i]);
        }
        arg0.m_128365_("floors", (Tag)tag);
        if (this.owner != null) {
            arg0.m_128362_("owner", this.owner);
        }
    }

    public static class LiftTracker {
        protected static final Map<UUID, EntityLift> liftMap = Maps.newHashMap();
    }
}

