/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.entity.blockentity.IBlockEntity;
import thut.core.common.ThutCore;
import thut.lib.ChatHelper;
import thut.lib.TComponent;
import thut.tech.common.TechCore;
import thut.tech.common.entity.EntityLift;

public class LiftInteractHandler
extends BlockEntityInteractHandler {
    public static boolean DROPSPARTS = true;
    final EntityLift lift;

    public LiftInteractHandler(EntityLift lift) {
        super((IBlockEntity)lift);
        this.lift = lift;
    }

    public InteractionResult interactInternal(Player player, BlockPos pos, ItemStack stack, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public InteractionResult processInitialInteract(Player player, @Nullable ItemStack stack, InteractionHand hand) {
        boolean shouldKillLiftOwned;
        boolean isElevatorItemOrStick = stack.m_41720_() == Items.f_42398_ || stack.m_41720_() == TechCore.LIFT.get();
        boolean isLinker = stack.m_41720_() == TechCore.LINKER.get();
        boolean canEdit = player.m_20148_().equals(this.lift.owner) || player.m_150110_().f_35937_;
        boolean shouldLinkLift = player.m_6144_() && isLinker && canEdit;
        boolean shouldKillLiftUnowned = this.lift.owner == null;
        boolean shouldDisplayOwner = isLinker && canEdit;
        boolean bl = shouldKillLiftOwned = player.m_6144_() && isElevatorItemOrStick && canEdit;
        if (shouldKillLiftUnowned) {
            ThutCore.LOGGER.error("Killing unowned Lift: " + this.lift);
            if (!this.lift.m_20193_().f_46443_) {
                String message = "msg.lift.killed";
                ChatHelper.sendSystemMessage((Player)player, (Component)TComponent.translatable((String)"msg.lift.killed"));
                if (DROPSPARTS) {
                    BlockPos max = this.lift.boundMax;
                    BlockPos min = this.lift.boundMin;
                    int dw = Math.max(max.m_123341_() - min.m_123341_(), max.m_123343_() - min.m_123343_());
                    int num = (dw + 1) * (max.m_123342_() - min.m_123342_() + 1);
                    stack = new ItemStack((ItemLike)TechCore.LIFT.get());
                    stack.m_41764_(num);
                    player.m_7197_(stack, false, true);
                }
                this.lift.m_142687_(Entity.RemovalReason.KILLED);
            }
            return InteractionResult.SUCCESS;
        }
        if (shouldLinkLift) {
            if (stack.m_41783_() == null) {
                stack.m_41751_(new CompoundTag());
            }
            stack.m_41783_().m_128359_("lift", this.lift.m_20149_());
            String message = "msg.liftSet";
            if (!this.lift.m_20193_().f_46443_) {
                ChatHelper.sendSystemMessage((Player)player, (Component)TComponent.translatable((String)"msg.liftSet"));
            }
            return InteractionResult.SUCCESS;
        }
        if (shouldDisplayOwner) {
            if (!this.lift.m_20193_().f_46443_ && this.lift.owner != null) {
                Player ownerentity = this.lift.m_20193_().m_46003_(this.lift.owner);
                String message = "msg.lift.owner";
                ChatHelper.sendSystemMessage((Player)player, (Component)TComponent.translatable((String)"msg.lift.owner", (Object[])new Object[]{ownerentity.m_7755_()}));
            }
            return InteractionResult.SUCCESS;
        }
        if (shouldKillLiftOwned) {
            if (!this.lift.m_20193_().f_46443_) {
                String message = "msg.lift.killed";
                ChatHelper.sendSystemMessage((Player)player, (Component)TComponent.translatable((String)"msg.lift.killed"));
                if (DROPSPARTS) {
                    BlockPos max = this.lift.boundMax;
                    BlockPos min = this.lift.boundMin;
                    int dw = Math.max(max.m_123341_() - min.m_123341_(), max.m_123343_() - min.m_123343_());
                    int num = (dw + 1) * (max.m_123342_() - min.m_123342_() + 1);
                    stack = new ItemStack((ItemLike)TechCore.LIFT.get());
                    stack.m_41764_(num);
                    player.m_7197_(stack, false, true);
                }
                this.lift.m_142687_(Entity.RemovalReason.KILLED);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

