/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.handlers;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import thut.api.ThutCaps;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.ControllerTile;
import thut.tech.common.entity.EntityLift;

@Mod.EventBusSubscriber
public class EnergyHandler {
    private static final ResourceLocation ENERGY = new ResourceLocation("thuttech", "energy");

    @SubscribeEvent
    public static void onEntityCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLift && !event.getCapabilities().containsKey(ENERGY)) {
            event.addCapability(ENERGY, (ICapabilityProvider)new ProviderLift());
        }
    }

    @SubscribeEvent
    public static void onTileCapabilityAttach(AttachCapabilitiesEvent<BlockEntity> event) {
        if (event.getObject() instanceof ControllerTile && !event.getCapabilities().containsKey(ENERGY)) {
            event.addCapability(ENERGY, (ICapabilityProvider)new ProviderLiftController((ControllerTile)((Object)event.getObject())));
        }
    }

    public static class ProviderLift
    extends EnergyStorage
    implements ICapabilityProvider {
        private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this);

        public ProviderLift() {
            super(TechCore.config.maxLiftEnergy, TechCore.config.maxLiftEnergy);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            return ThutCaps.ENERGY.orEmpty(capability, this.holder);
        }
    }

    public static class ProviderLiftController
    implements ICapabilityProvider,
    IEnergyStorage {
        private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this);
        final ControllerTile tile;
        IEnergyStorage lift = null;

        public ProviderLiftController(ControllerTile tile) {
            this.tile = tile;
        }

        public boolean canExtract() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.canExtract();
            }
            return false;
        }

        public boolean canReceive() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.canReceive();
            }
            return false;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.extractEnergy(maxExtract, simulate);
            }
            return 0;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            return ThutCaps.ENERGY.orEmpty(capability, this.holder);
        }

        public int getEnergyStored() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.getEnergyStored();
            }
            return 0;
        }

        public int getMaxEnergyStored() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.getMaxEnergyStored();
            }
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.receiveEnergy(maxReceive, simulate);
            }
            return 0;
        }

        private void updateLift() {
            this.lift = this.tile.getLift() == null ? null : (IEnergyStorage)this.tile.getLift().getCapability(ThutCaps.ENERGY, null).orElse(null);
        }
    }
}

