/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.compat.cct;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import thut.core.common.ThutCore;
import thut.tech.common.blocks.lift.ControllerTile;

public class Peripherals {
    private static boolean reged = false;

    public static void register() {
        if (!reged) {
            reged = true;
            ThutCore.LOGGER.info("Registering CC Peripheral!");
            ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new ElevatorPeripheralProvider());
        }
    }

    public static class ElevatorPeripheralProvider
    implements IPeripheralProvider {
        public LazyOptional<IPeripheral> getPeripheral(Level world, BlockPos pos, Direction side) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof ControllerTile) {
                return LazyOptional.of(() -> new ElevatorPeripheral((ControllerTile)tile));
            }
            return LazyOptional.empty();
        }
    }

    public static class ElevatorPeripheral
    implements IDynamicPeripheral {
        private final Provider provider;

        public String[] getMethodNames() {
            return new String[]{"move_by", "goto_floor", "find", "has", "isReady", "callFloor", "callXValue", "callYValue", "callZValue", "setFloor", "getXValue", "getYValue", "getZValue", "getFloorYValue"};
        }

        public MethodResult callMethod(IComputerAccess iComputerAccess, ILuaContext iLuaContext, int method, IArguments iArguments) throws LuaException {
            switch (method) {
                case 0: {
                    return MethodResult.of((Object)this.provider.moveBy(iArguments.getString(0), iArguments.getInt(1)));
                }
                case 1: 
                case 5: {
                    return MethodResult.of((Object)this.provider.goTo(iArguments.getInt(0)));
                }
                case 2: {
                    return MethodResult.of((Object)Arrays.toString(this.provider.find()));
                }
                case 3: {
                    return MethodResult.of((Object)this.provider.has());
                }
                case 4: {
                    return MethodResult.of((Object)this.provider.isReady());
                }
                case 6: {
                    return MethodResult.of((Object)this.provider.moveBy("x", iArguments.getInt(0)));
                }
                case 7: {
                    return MethodResult.of((Object)this.provider.moveBy("y", iArguments.getInt(0)));
                }
                case 8: {
                    return MethodResult.of((Object)this.provider.moveBy("Z", iArguments.getInt(0)));
                }
                case 9: {
                    return MethodResult.of((Object)this.provider.setFloor(iArguments.getInt(0)));
                }
                case 10: {
                    return MethodResult.of((Object)this.provider.getCoord("x"));
                }
                case 11: {
                    return MethodResult.of((Object)this.provider.getCoord("y"));
                }
                case 12: {
                    return MethodResult.of((Object)this.provider.getCoord("z"));
                }
                case 13: {
                    return MethodResult.of((Object)this.provider.getFloorYValue(iArguments.getInt(0)));
                }
            }
            return null;
        }

        public ElevatorPeripheral(ControllerTile tile) {
            this.provider = new Provider(tile);
        }

        public String getType() {
            return "lift";
        }

        public Object getTarget() {
            return this.provider;
        }

        public boolean equals(IPeripheral other) {
            return other instanceof ElevatorPeripheral && ((ElevatorPeripheral)other).provider.tile == this.provider.tile;
        }

        public static class Provider {
            private final ControllerTile tile;

            public Provider(ControllerTile tile) {
                this.tile = tile;
            }

            public boolean moveBy(String axis, float amount) throws LuaException {
                if (this.tile.getLift() == null) {
                    throw new LuaException("No Elevator Linked!");
                }
                if (axis.equalsIgnoreCase("x")) {
                    this.tile.getLift().setDestX((float)(this.tile.getLift().m_20185_() + (double)amount));
                }
                if (axis.equalsIgnoreCase("y")) {
                    this.tile.getLift().setDestY((float)(this.tile.getLift().m_20186_() + (double)amount));
                }
                if (axis.equalsIgnoreCase("z")) {
                    this.tile.getLift().setDestZ((float)(this.tile.getLift().m_20189_() + (double)amount));
                }
                return true;
            }

            public boolean goTo(int floor) throws LuaException {
                if (this.tile.getLift() == null) {
                    throw new LuaException("No Elevator Linked!");
                }
                if (floor < 0) {
                    floor = 64 - floor;
                }
                if (floor - 1 >= this.tile.getLift().maxFloors()) {
                    throw new LuaException("Floor not in range");
                }
                if (!this.tile.getLift().hasFloor(floor)) {
                    throw new LuaException("Floor not found.");
                }
                this.tile.getLift().call(floor);
                return true;
            }

            public double[] find() throws LuaException {
                if (this.tile.getLift() == null) {
                    throw new LuaException("No Elevator Linked!");
                }
                return new double[]{this.tile.getLift().m_20185_(), this.tile.getLift().m_20186_(), this.tile.getLift().m_20189_()};
            }

            public boolean has() {
                return this.tile.liftID != null;
            }

            public boolean isReady() throws LuaException {
                if (this.tile.getLift() == null) {
                    throw new LuaException("No Elevator Linked!");
                }
                return this.tile.getLift().getCurrentFloor() == this.tile.getLift().getDestinationFloor();
            }

            public boolean setFloor(int floor) throws LuaException {
                if (this.tile.getLift() == null) {
                    throw new LuaException("No Elevator Linked!");
                }
                if (this.tile.floor != floor) {
                    this.tile.floor = floor;
                    return true;
                }
                return false;
            }

            public double getCoord(String axis) throws LuaException {
                if (this.tile.getLift() == null) {
                    throw new LuaException("No Elevator Linked!");
                }
                if (axis.equalsIgnoreCase("x")) {
                    return this.tile.getLift().m_20185_();
                }
                if (axis.equalsIgnoreCase("y")) {
                    return this.tile.getLift().m_20186_();
                }
                if (axis.equalsIgnoreCase("z")) {
                    return this.tile.getLift().m_20189_();
                }
                return -1.0;
            }

            public double getFloorYValue(int floor) throws LuaException {
                if (this.tile.getLift() == null) {
                    throw new LuaException("No Elevator Linked!");
                }
                return this.tile.getLift().getFloorPos(floor);
            }
        }
    }
}

