/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.timeflies;

import java.util.function.Supplier;
import net.mcreator.timeflies.TimeFliesMod;
import net.mcreator.timeflies.TimeFliesModElements;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class TimeFliesModVariables {
    public TimeFliesModVariables(TimeFliesModElements elements) {
        elements.addNetworkMessage(WorldSavedDataSyncMessage.class, WorldSavedDataSyncMessage::buffer, WorldSavedDataSyncMessage::new, WorldSavedDataSyncMessage::handler);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            MapVariables mapdata = MapVariables.get((IWorld)event.getPlayer().field_70170_p);
            WorldVariables worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p);
            if (mapdata != null) {
                TimeFliesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(0, mapdata));
            }
            if (worlddata != null) {
                TimeFliesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WorldVariables worlddata;
        if (!event.getPlayer().field_70170_p.func_201670_d() && (worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p)) != null) {
            TimeFliesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
        }
    }

    public static class WorldSavedDataSyncMessage {
        public int type;
        public WorldSavedData data;

        public WorldSavedDataSyncMessage(PacketBuffer buffer) {
            this.type = buffer.readInt();
            this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            this.data.func_76184_a(buffer.func_150793_b());
        }

        public WorldSavedDataSyncMessage(int type, WorldSavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(WorldSavedDataSyncMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.type);
            buffer.func_150786_a(message.data.func_189551_b(new CompoundNBT()));
        }

        public static void handler(WorldSavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "time_flies_mapvars";
        public boolean TimeFliesEnable = true;
        public boolean SleepEnable = true;
        public double DayLength = 10.0;
        public double NightLength = 10.0;
        public boolean PlayerSleeping = false;
        public double SleepTimer = 0.0;
        public double TimeAccumulator = 0.0;
        public double WorldDay = 0.0;
        public double NextDawn = 0.0;
        static MapVariables clientSide = new MapVariables();

        public MapVariables() {
            super(DATA_NAME);
        }

        public MapVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.TimeFliesEnable = nbt.func_74767_n("TimeFliesEnable");
            this.SleepEnable = nbt.func_74767_n("SleepEnable");
            this.DayLength = nbt.func_74769_h("DayLength");
            this.NightLength = nbt.func_74769_h("NightLength");
            this.PlayerSleeping = nbt.func_74767_n("PlayerSleeping");
            this.SleepTimer = nbt.func_74769_h("SleepTimer");
            this.TimeAccumulator = nbt.func_74769_h("TimeAccumulator");
            this.WorldDay = nbt.func_74769_h("WorldDay");
            this.NextDawn = nbt.func_74769_h("NextDawn");
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            nbt.func_74757_a("TimeFliesEnable", this.TimeFliesEnable);
            nbt.func_74757_a("SleepEnable", this.SleepEnable);
            nbt.func_74780_a("DayLength", this.DayLength);
            nbt.func_74780_a("NightLength", this.NightLength);
            nbt.func_74757_a("PlayerSleeping", this.PlayerSleeping);
            nbt.func_74780_a("SleepTimer", this.SleepTimer);
            nbt.func_74780_a("TimeAccumulator", this.TimeAccumulator);
            nbt.func_74780_a("WorldDay", this.WorldDay);
            nbt.func_74780_a("NextDawn", this.NextDawn);
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (world instanceof World && !world.func_201670_d()) {
                TimeFliesMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new WorldSavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(IWorld world) {
            if (world instanceof IServerWorld) {
                return (MapVariables)((IServerWorld)world).func_201672_e().func_73046_m().func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "time_flies_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public WorldVariables() {
            super(DATA_NAME);
        }

        public WorldVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (world instanceof World && !world.func_201670_d()) {
                TimeFliesMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((World)((World)world)).func_234923_W_()), (Object)new WorldSavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(IWorld world) {
            if (world instanceof ServerWorld) {
                return (WorldVariables)((ServerWorld)world).func_217481_x().func_215752_a(WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }
}

